/*
 * Decompiled with CFR 0.152.
 */
package com.rae.creatingspace.content.life_support.spacesuit;

import com.rae.creatingspace.content.life_support.spacesuit.OxygenBacktankUtil;
import com.rae.creatingspace.content.life_support.spacesuit.UpgradableEquipment;
import com.simibubi.create.foundation.item.LayeredArmorItem;
import java.util.Locale;
import java.util.function.Supplier;
import net.minecraft.nbt.CompoundTag;
import net.minecraft.resources.ResourceLocation;
import net.minecraft.util.Mth;
import net.minecraft.world.InteractionResult;
import net.minecraft.world.entity.Entity;
import net.minecraft.world.entity.EquipmentSlot;
import net.minecraft.world.entity.LivingEntity;
import net.minecraft.world.item.ArmorItem;
import net.minecraft.world.item.ArmorMaterial;
import net.minecraft.world.item.BlockItem;
import net.minecraft.world.item.Item;
import net.minecraft.world.item.ItemStack;
import net.minecraft.world.item.context.UseOnContext;
import net.minecraft.world.level.Level;
import net.minecraft.world.level.block.Block;
import org.jetbrains.annotations.Nullable;

public class OxygenBacktankItem
extends UpgradableEquipment {
    public static final ArmorItem.Type TYPE = ArmorItem.Type.CHESTPLATE;
    public static final int BAR_COLOR = 0xEFEFEF;
    private final Supplier<O2BacktankBlockItem> blockItem;

    public OxygenBacktankItem(ArmorMaterial material, Item.Properties properties, ResourceLocation textureLoc, Supplier<O2BacktankBlockItem> placeable) {
        super(material, TYPE, properties, textureLoc);
        this.blockItem = placeable;
    }

    public void m_6883_(ItemStack backtank, Level level, Entity entity, int nbr, boolean isMoving) {
        CompoundTag tag = backtank.m_41784_();
        float o2amount = tag.m_128457_("Oxygen");
        float prevO2amount = tag.m_128457_("prevOxygen");
        boolean toUpdate = tag.m_128471_("toUpdate");
        if (toUpdate) {
            tag.m_128350_("prevOxygen", o2amount);
            tag.m_128379_("toUpdate", false);
        }
    }

    @Nullable
    public static OxygenBacktankItem getWornBy(Entity entity) {
        if (!(entity instanceof LivingEntity)) {
            return null;
        }
        LivingEntity livingEntity = (LivingEntity)entity;
        Item item = livingEntity.m_6844_(TYPE.m_266308_()).m_41720_();
        if (!(item instanceof OxygenBacktankItem)) {
            return null;
        }
        OxygenBacktankItem item2 = (OxygenBacktankItem)item;
        return item2;
    }

    @Override
    public InteractionResult m_6225_(UseOnContext ctx) {
        return this.blockItem.get().m_6225_(ctx);
    }

    public boolean m_41465_() {
        return false;
    }

    public boolean m_8120_(ItemStack p_77616_1_) {
        return true;
    }

    public boolean m_142522_(ItemStack stack) {
        return true;
    }

    public int m_142158_(ItemStack stack) {
        return Math.round(13.0f * Mth.m_14036_((float)(OxygenBacktankItem.getRemainingAir(stack) / (float)OxygenBacktankUtil.maxOxygen(stack)), (float)0.0f, (float)1.0f));
    }

    public int m_142159_(ItemStack stack) {
        return 0xEFEFEF;
    }

    public Block getBlock() {
        return this.blockItem.get().m_40614_();
    }

    public static float getRemainingAir(ItemStack stack) {
        CompoundTag orCreateTag = stack.m_41784_();
        return orCreateTag.m_128457_("Oxygen");
    }

    public static class O2BacktankBlockItem
    extends BlockItem {
        private final Supplier<Item> actualItem;

        public O2BacktankBlockItem(Block block, Supplier<Item> actualItem, Item.Properties properties) {
            super(block, properties);
            this.actualItem = actualItem;
        }

        public String m_5524_() {
            return this.m_41467_();
        }

        public Item getActualItem() {
            return this.actualItem.get();
        }
    }

    public static class Layered
    extends OxygenBacktankItem
    implements LayeredArmorItem {
        public Layered(ArmorMaterial material, Item.Properties properties, ResourceLocation textureLoc, Supplier<O2BacktankBlockItem> placeable) {
            super(material, properties, textureLoc, placeable);
        }

        public String getArmorTextureLocation(LivingEntity entity, EquipmentSlot slot, ItemStack stack, int layer) {
            return String.format(Locale.ROOT, "%s:textures/models/armor/%s_layer_%d.png", this.textureLoc.m_135827_(), this.textureLoc.m_135815_(), layer);
        }
    }
}

