/*
 * Decompiled with CFR 0.152.
 */
package com.rae.creatingspace.content.rocket.contraption;

import com.mojang.datafixers.kinds.App;
import com.mojang.datafixers.kinds.Applicative;
import com.mojang.serialization.Codec;
import com.mojang.serialization.DynamicOps;
import com.mojang.serialization.codecs.RecordCodecBuilder;
import com.rae.creatingspace.configs.CSConfigs;
import com.rae.creatingspace.content.rocket.engine.RocketEngineBlockEntity;
import com.rae.creatingspace.content.rocket.engine.design.PropellantType;
import com.rae.creatingspace.content.rocket.flight_recorder.FlightRecorderBlock;
import com.rae.creatingspace.init.CSContraptionType;
import com.rae.creatingspace.init.ingameobject.PropellantTypeInit;
import com.rae.creatingspace.legacy.utilities.CSMassUtil;
import com.simibubi.create.api.contraption.ContraptionType;
import com.simibubi.create.content.contraptions.AssemblyException;
import com.simibubi.create.content.contraptions.TranslatingContraption;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.HashMap;
import java.util.Map;
import java.util.Queue;
import java.util.Set;
import net.minecraft.core.BlockPos;
import net.minecraft.core.Direction;
import net.minecraft.core.Vec3i;
import net.minecraft.core.registries.Registries;
import net.minecraft.nbt.CompoundTag;
import net.minecraft.nbt.NbtOps;
import net.minecraft.nbt.Tag;
import net.minecraft.resources.ResourceKey;
import net.minecraft.tags.TagKey;
import net.minecraft.world.level.Level;
import net.minecraft.world.level.block.Block;
import net.minecraft.world.level.block.entity.BlockEntity;
import net.minecraft.world.level.levelgen.structure.templatesystem.StructureTemplate;
import net.minecraft.world.level.material.Fluid;
import org.apache.commons.lang3.tuple.Pair;
import org.jetbrains.annotations.Nullable;

public class RocketContraption
extends TranslatingContraption {
    private int thrust = 0;
    private int dryMass = 0;
    private HashMap<PropellantType, ConsumptionInfo> theoreticalPerTagFluidConsumption = new HashMap();
    private final ArrayList<BlockPos> localPosOfFlightRecorders = new ArrayList();
    public static final Codec<Map<PropellantType, ConsumptionInfo>> CODEC = Codec.unboundedMap((Codec)PropellantTypeInit.getSyncedPropellantRegistry().m_194605_(), ConsumptionInfo.CODEC);

    public boolean assemble(Level level, BlockPos pos) throws AssemblyException {
        if (!this.searchMovedStructure(level, pos, null)) {
            return false;
        }
        this.startMoving(level);
        this.expandBoundsAroundAxis(Direction.Axis.Y);
        return true;
    }

    protected void addBlock(Level level, BlockPos pos, Pair<StructureTemplate.StructureBlockInfo, BlockEntity> pair) {
        Block blockAdded = ((StructureTemplate.StructureBlockInfo)pair.getLeft()).f_74676_().m_60734_();
        BlockEntity blockEntityAdded = (BlockEntity)pair.getRight();
        BlockPos localPos = pos.m_121996_((Vec3i)this.anchor);
        if (blockEntityAdded instanceof RocketEngineBlockEntity) {
            RocketEngineBlockEntity engineBlockEntity = (RocketEngineBlockEntity)blockEntityAdded;
            this.thrust += engineBlockEntity.getThrust();
            float totalPropellantMassFlow = (float)((double)engineBlockEntity.getThrust() / ((double)engineBlockEntity.getIsp() * (Double)CSConfigs.SERVER.rocketEngine.ISPModifier.get() * 9.81));
            PropellantType propellantType = engineBlockEntity.getPropellantType();
            ConsumptionInfo previousCombInfo = new ConsumptionInfo(new HashMap<TagKey<Fluid>, Float>(), 0);
            if (this.theoreticalPerTagFluidConsumption.containsKey(propellantType)) {
                previousCombInfo = this.theoreticalPerTagFluidConsumption.get(propellantType);
            }
            HashMap<TagKey<Fluid>, Float> proportions = new HashMap<TagKey<Fluid>, Float>(engineBlockEntity.getPropellantType().getPropellantRatio());
            RocketContraption.multiplyMap(proportions, totalPropellantMassFlow);
            this.theoreticalPerTagFluidConsumption.put(propellantType, previousCombInfo.add(proportions, engineBlockEntity.getThrust()));
        }
        this.dryMass += CSMassUtil.mass(blockAdded.m_49966_(), blockEntityAdded);
        if (blockAdded instanceof FlightRecorderBlock) {
            this.localPosOfFlightRecorders.add(localPos);
        }
        super.addBlock(level, pos, pair);
    }

    public static void multiplyMap(HashMap<TagKey<Fluid>, Float> map, float amount) {
        for (TagKey<Fluid> fluid : map.keySet()) {
            map.put(fluid, Float.valueOf(map.get(fluid).floatValue() * amount));
        }
    }

    protected boolean moveBlock(Level world, @Nullable Direction forcedDirection, Queue<BlockPos> frontier, Set<BlockPos> visited) throws AssemblyException {
        return super.moveBlock(world, forcedDirection, frontier, visited);
    }

    protected boolean isAnchoringBlockAt(BlockPos pos) {
        return false;
    }

    public ContraptionType getType() {
        return (ContraptionType)CSContraptionType.ROCKET.get();
    }

    public void readNBT(Level world, CompoundTag nbt, boolean clientPacket) {
        this.thrust = nbt.m_128451_("thrust");
        this.dryMass = nbt.m_128451_("dryMass");
        Arrays.stream(nbt.m_128467_("localPosOfFlightRecorders")).forEach(l -> this.localPosOfFlightRecorders.add(BlockPos.m_122022_((long)l)));
        this.theoreticalPerTagFluidConsumption = new HashMap(CODEC.parse((DynamicOps)NbtOps.f_128958_, (Object)nbt.m_128423_("theoreticalPerTagFluidConsumption")).result().orElse(new HashMap()));
        super.readNBT(world, nbt, clientPacket);
    }

    public CompoundTag writeNBT(boolean spawnPacket) {
        CompoundTag nbt = super.writeNBT(spawnPacket);
        nbt.m_128405_("thrust", this.thrust);
        nbt.m_128405_("dryMass", this.dryMass);
        nbt.m_128428_("localPosOfFlightRecorders", this.localPosOfFlightRecorders.stream().map(BlockPos::m_121878_).toList());
        nbt.m_128365_("theoreticalPerTagFluidConsumption", (Tag)CODEC.encodeStart((DynamicOps)NbtOps.f_128958_, this.theoreticalPerTagFluidConsumption).result().orElse(new CompoundTag()));
        return nbt;
    }

    public ArrayList<BlockPos> getLocalPosOfFlightRecorders() {
        return this.localPosOfFlightRecorders;
    }

    public float getDryMass() {
        return this.dryMass;
    }

    public float getThrust() {
        return this.thrust;
    }

    public HashMap<PropellantType, ConsumptionInfo> getTPTFluidConsumption() {
        return this.theoreticalPerTagFluidConsumption;
    }

    public record ConsumptionInfo(Map<TagKey<Fluid>, Float> propellantConsumption, int partialThrust) {
        public static final Codec<ConsumptionInfo> CODEC = RecordCodecBuilder.create(instance -> instance.group((App)Codec.unboundedMap((Codec)TagKey.m_203877_((ResourceKey)Registries.f_256808_), (Codec)Codec.FLOAT).fieldOf("propellantConsumption").forGetter(i -> i.propellantConsumption), (App)Codec.INT.fieldOf("partialThrust").forGetter(i -> i.partialThrust)).apply((Applicative)instance, ConsumptionInfo::new));

        public ConsumptionInfo add(Map<TagKey<Fluid>, Float> propellantConsumption, int partialThrust) {
            HashMap<TagKey<Fluid>, Float> newMap = new HashMap<TagKey<Fluid>, Float>(this.propellantConsumption());
            for (TagKey<Fluid> fluid : propellantConsumption.keySet()) {
                newMap.put(fluid, Float.valueOf(newMap.getOrDefault(fluid, Float.valueOf(0.0f)).floatValue() + propellantConsumption.get(fluid).floatValue()));
            }
            return new ConsumptionInfo(newMap, this.partialThrust + partialThrust);
        }
    }
}

