/*
 * Decompiled with CFR 0.152.
 */
package com.rae.creatingspace.content.rocket.contraption.behaviour.interaction;

import com.rae.creatingspace.configs.CSCfgClient;
import com.rae.creatingspace.configs.CSConfigs;
import com.rae.creatingspace.content.rocket.RocketContraptionEntity;
import com.rae.creatingspace.legacy.utilities.CSUtil;
import com.rae.creatingspace.legacy.utilities.data.FlightDataHelper;
import com.simibubi.create.api.behaviour.interaction.MovingInteractionBehaviour;
import com.simibubi.create.content.contraptions.AbstractContraptionEntity;
import java.util.Locale;
import java.util.concurrent.atomic.AtomicReference;
import net.minecraft.ChatFormatting;
import net.minecraft.core.BlockPos;
import net.minecraft.network.chat.Component;
import net.minecraft.server.level.ServerPlayer;
import net.minecraft.tags.TagKey;
import net.minecraft.world.InteractionHand;
import net.minecraft.world.entity.player.Player;
import net.minecraft.world.level.material.Fluid;
import net.minecraftforge.registries.ForgeRegistries;

public class FlightRecorderInteraction
extends MovingInteractionBehaviour {
    private static final boolean shouldBeDisplayed = false;
    String tradKey = "creatingspace.overlay.flight_recorder.";

    public boolean handlePlayerInteraction(Player player, InteractionHand activeHand, BlockPos localPos, AbstractContraptionEntity contraptionEntity) {
        if (player instanceof ServerPlayer) {
            ServerPlayer serverPlayer = (ServerPlayer)player;
            if (contraptionEntity instanceof RocketContraptionEntity) {
                RocketContraptionEntity rocket = (RocketContraptionEntity)contraptionEntity;
                FlightDataHelper.RocketAssemblyData lastAssemblyData = rocket.assemblyData;
                if (lastAssemblyData != null) {
                    if (lastAssemblyData.hasFailed()) {
                        if (lastAssemblyData.propellantStatusData().status().isFailReason) {
                            serverPlayer.m_213846_((Component)Component.m_237110_((String)(this.tradKey + "propellant_status." + String.valueOf((Object)lastAssemblyData.propellantStatusData().status()).toLowerCase(Locale.ROOT)), (Object[])new Object[]{false}));
                            for (TagKey<Fluid> fluidTagKey : lastAssemblyData.propellantStatusData().consumedMassForEachPropellant().keySet()) {
                                Integer consumedMass = lastAssemblyData.propellantStatusData().consumedMassForEachPropellant().get(fluidTagKey);
                                Integer fluidMass = lastAssemblyData.propellantStatusData().massForEachPropellant().get(fluidTagKey);
                                if (fluidMass == null) {
                                    fluidMass = 0;
                                }
                                if (((CSCfgClient.Measurement)((Object)CSConfigs.CLIENT.recorder_measurement.get())).equals((Object)CSCfgClient.Measurement.MASS)) {
                                    serverPlayer.m_240418_((Component)Component.m_237115_((String)("fluid." + fluidTagKey.f_203868_().m_214298_())).m_130946_(" ").m_7220_((Component)Component.m_237113_((String)CSUtil.scientificNbrFormatting(Float.valueOf((float)fluidMass.intValue() / 1000.0f), 5)).m_7220_((Component)Component.m_237115_((String)"creatingspace.science.unit.metric_ton")).m_130940_(consumedMass >= fluidMass ? ChatFormatting.DARK_RED : ChatFormatting.DARK_GREEN)).m_7220_((Component)Component.m_237113_((String)(" / " + CSUtil.scientificNbrFormatting(Float.valueOf((float)consumedMass.intValue() / 1000.0f), 5))).m_7220_((Component)Component.m_237115_((String)"creatingspace.science.unit.metric_ton")).m_130940_(ChatFormatting.GOLD)), false);
                                    continue;
                                }
                                if (!((CSCfgClient.Measurement)((Object)CSConfigs.CLIENT.recorder_measurement.get())).equals((Object)CSCfgClient.Measurement.VOLUMETRIC)) continue;
                                AtomicReference fluidRef = new AtomicReference();
                                ForgeRegistries.FLUIDS.getEntries().forEach(resourceKeyFluidEntry -> {
                                    if (((Fluid)resourceKeyFluidEntry.getValue()).m_205067_(fluidTagKey)) {
                                        fluidRef.set((Fluid)resourceKeyFluidEntry.getValue());
                                    }
                                });
                                if (fluidRef.get() == null) {
                                    serverPlayer.m_240418_((Component)Component.m_237113_((String)"Warning : failed to find a fluid in game data"), false);
                                    continue;
                                }
                                float fluidVolume = fluidMass / ((Fluid)fluidRef.get()).getFluidType().getDensity();
                                serverPlayer.m_240418_((Component)Component.m_237115_((String)("fluid." + fluidTagKey.f_203868_().m_214298_())).m_130946_(" ").m_7220_((Component)Component.m_237113_((String)CSUtil.scientificNbrFormatting(Float.valueOf(fluidVolume), 5)).m_7220_((Component)Component.m_237113_((String)"B")).m_130940_(consumedMass >= fluidMass ? ChatFormatting.DARK_RED : ChatFormatting.DARK_GREEN)).m_7220_((Component)Component.m_237113_((String)(" / " + CSUtil.scientificNbrFormatting(Float.valueOf((float)consumedMass.intValue() / (float)((Fluid)fluidRef.get()).getFluidType().getDensity()), 5))).m_7220_((Component)Component.m_237113_((String)"B")).m_130940_(ChatFormatting.GOLD)), false);
                            }
                        }
                        if (lastAssemblyData.thrust() < lastAssemblyData.weight()) {
                            serverPlayer.m_240418_((Component)Component.m_237115_((String)(this.tradKey + "not_enough_thrust")), false);
                            serverPlayer.m_240418_((Component)Component.m_237115_((String)"creatingspace.overlay.flight_recorder.thrust1").m_7220_((Component)Component.m_237113_((String)(" : " + CSUtil.scientificNbrFormatting(Float.valueOf(lastAssemblyData.thrust()), 3)))).m_7220_((Component)Component.m_237115_((String)"creatingspace.science.unit.newton")), false);
                            serverPlayer.m_240418_((Component)Component.m_237115_((String)"creatingspace.overlay.flight_recorder.thrust2").m_7220_((Component)Component.m_237113_((String)(" : " + CSUtil.scientificNbrFormatting(Float.valueOf(lastAssemblyData.weight()), 3))).m_7220_((Component)Component.m_237115_((String)"creatingspace.science.unit.newton"))), false);
                        }
                    } else {
                        serverPlayer.m_240418_((Component)Component.m_237115_((String)(this.tradKey + "no_failure")), false);
                    }
                } else {
                    serverPlayer.m_240418_((Component)Component.m_237115_((String)(this.tradKey + "no_flight")), false);
                }
            }
        }
        return super.handlePlayerInteraction(player, activeHand, localPos, contraptionEntity);
    }
}

