/*
 * Decompiled with CFR 0.152.
 */
package com.rae.creatingspace.content.rocket.engine;

import com.mojang.serialization.DynamicOps;
import com.rae.creatingspace.CreatingSpace;
import com.rae.creatingspace.configs.CSCfgClient;
import com.rae.creatingspace.configs.CSConfigs;
import com.rae.creatingspace.content.rocket.engine.design.PropellantType;
import com.rae.creatingspace.init.ingameobject.PropellantTypeInit;
import com.rae.creatingspace.legacy.utilities.CSUtil;
import java.util.HashMap;
import java.util.List;
import java.util.concurrent.atomic.AtomicReference;
import net.minecraft.ChatFormatting;
import net.minecraft.nbt.CompoundTag;
import net.minecraft.nbt.NbtOps;
import net.minecraft.network.chat.Component;
import net.minecraft.resources.ResourceLocation;
import net.minecraft.tags.TagKey;
import net.minecraft.world.item.BlockItem;
import net.minecraft.world.item.Item;
import net.minecraft.world.level.block.Block;
import net.minecraft.world.level.material.Fluid;
import net.minecraftforge.registries.ForgeRegistries;

public abstract class RocketEngineItem
extends BlockItem {
    public RocketEngineItem(Block p_40565_, Item.Properties p_40566_) {
        super(p_40565_, p_40566_);
    }

    private static void appendEngineDependentText(List<Component> components, Integer ISP, Integer mass, Integer thrust) {
        if (ISP != null) {
            components.add((Component)Component.m_237115_((String)"creatingspace.science.isp").m_7220_((Component)Component.m_237113_((String)(" : " + ISP))).m_7220_((Component)Component.m_237115_((String)"creatingspace.science.unit.second")));
        }
        if (mass != null) {
            components.add((Component)Component.m_237115_((String)"creatingspace.science.mass").m_130946_(" : " + mass).m_7220_((Component)Component.m_237115_((String)"creatingspace.science.unit.kilo_gramme")));
        }
        if (thrust != null) {
            components.add((Component)Component.m_237115_((String)"creatingspace.science.thrust").m_7220_((Component)Component.m_237113_((String)(" : " + CSUtil.scientificNbrFormatting(Float.valueOf(thrust.intValue()), 10)))).m_7220_((Component)Component.m_237115_((String)"creatingspace.science.unit.newton")));
        }
    }

    public static void appendEngineDependentText(List<Component> components, CompoundTag beTag) {
        try {
            PropellantType propellantType = beTag.m_128441_("propellantType") ? (PropellantType)PropellantTypeInit.getSyncedPropellantRegistry().m_6612_(ResourceLocation.f_135803_.parse((DynamicOps)NbtOps.f_128958_, (Object)beTag.m_128423_("propellantType")).resultOrPartial(s -> {}).orElse(PropellantTypeInit.METHALOX.getId())).orElseThrow() : null;
            RocketEngineItem.appendEngineTextDirect(components, propellantType, beTag.m_128441_("efficiency") && propellantType != null ? Integer.valueOf((int)((float)propellantType.getMaxISP().intValue() * beTag.m_128457_("efficiency"))) : null, beTag.m_128441_("mass") ? Integer.valueOf(beTag.m_128451_("mass")) : null, beTag.m_128441_("thrust") ? Integer.valueOf(beTag.m_128451_("thrust")) : null);
        }
        catch (Exception exception) {
            // empty catch block
        }
    }

    public static void appendEngineTextDirect(List<Component> components, PropellantType propellantType, Integer ISP, Integer mass, Integer thrust) {
        RocketEngineItem.appendEngineDependentText(components, ISP, mass, thrust);
        RocketEngineItem.appendFluidInfo(components, propellantType);
    }

    private static void appendFluidInfo(List<Component> components, PropellantType propellantType) {
        components.add((Component)Component.m_237113_((String)"ratio of fluid consumed :"));
        if (((CSCfgClient.Measurement)((Object)CSConfigs.CLIENT.recorder_measurement.get())).equals((Object)CSCfgClient.Measurement.MASS)) {
            for (TagKey<Fluid> fluidTagkey : propellantType.getPropellantRatio().keySet()) {
                components.add((Component)Component.m_237115_((String)("fluid." + fluidTagkey.f_203868_().m_214298_())).m_130940_(ChatFormatting.AQUA).m_130946_(" : ").m_7220_((Component)Component.m_237113_((String)String.valueOf((float)((int)(propellantType.getPropellantRatio().get(fluidTagkey).floatValue() * 1000.0f)) / 10.0f))).m_130946_("%"));
            }
        }
        if (((CSCfgClient.Measurement)((Object)CSConfigs.CLIENT.recorder_measurement.get())).equals((Object)CSCfgClient.Measurement.VOLUMETRIC)) {
            HashMap<Object, Float> collector = new HashMap<Object, Float>();
            float total = 0.0f;
            for (TagKey<Fluid> fluidTagkey : propellantType.getPropellantRatio().keySet()) {
                AtomicReference fluidRef = new AtomicReference();
                ForgeRegistries.FLUIDS.getEntries().forEach(resourceKeyFluidEntry -> {
                    if (((Fluid)resourceKeyFluidEntry.getValue()).m_205067_(fluidTagkey)) {
                        fluidRef.set((Fluid)resourceKeyFluidEntry.getValue());
                    }
                });
                if (fluidRef.get() == null) {
                    CreatingSpace.LOGGER.warn("Warning : failed to find a fluid in game data");
                    continue;
                }
                collector.put(fluidTagkey, Float.valueOf(propellantType.getPropellantRatio().get(fluidTagkey).floatValue() / (float)((Fluid)fluidRef.get()).getFluidType().getDensity()));
                total += propellantType.getPropellantRatio().get(fluidTagkey).floatValue() / (float)((Fluid)fluidRef.get()).getFluidType().getDensity();
            }
            float finalTotal = total;
            collector.forEach((k, v) -> {
                if (finalTotal != 0.0f) {
                    components.add((Component)Component.m_237115_((String)("fluid." + k.f_203868_().m_214298_())).m_130940_(ChatFormatting.AQUA).m_130946_(" : ").m_7220_((Component)Component.m_237113_((String)String.valueOf((float)((int)(((Float)collector.get(k)).floatValue() / finalTotal * 1000.0f)) / 10.0f))).m_130946_("%"));
                }
            });
        }
    }
}

