/*
 * Decompiled with CFR 0.152.
 */
package com.rae.creatingspace.content.rocket.engine.design;

import com.mojang.datafixers.kinds.App;
import com.mojang.datafixers.kinds.Applicative;
import com.mojang.serialization.Codec;
import com.mojang.serialization.codecs.RecordCodecBuilder;
import java.util.List;
import net.minecraft.resources.ResourceLocation;

public class ExhaustPackType {
    float minExpansionRatio;
    float maxExpansionRatio;
    List<ResourceLocation> allowedPropellants;
    public static final Codec<ExhaustPackType> DIRECT_CODEC = RecordCodecBuilder.create(instance -> instance.group((App)Codec.FLOAT.fieldOf("minExpansionRatio").forGetter(i -> Float.valueOf(i.minExpansionRatio)), (App)Codec.FLOAT.fieldOf("maxExpansionRatio").forGetter(i -> Float.valueOf(i.maxExpansionRatio)), (App)Codec.list((Codec)ResourceLocation.f_135803_).fieldOf("allowedPropellants").forGetter(i -> i.allowedPropellants)).apply((Applicative)instance, ExhaustPackType::new));

    public ExhaustPackType(float minExpansionRatio, float maxExpansionRatio, List<ResourceLocation> allowedPropellants) {
        this.minExpansionRatio = minExpansionRatio;
        this.maxExpansionRatio = maxExpansionRatio;
        this.allowedPropellants = allowedPropellants;
    }

    public float getMinExpansionRatio() {
        return this.minExpansionRatio;
    }

    public float getMaxExpansionRatio() {
        return this.maxExpansionRatio;
    }

    public int getMass(float size, float expansionRatio) {
        return (int)((expansionRatio / (this.maxExpansionRatio - this.minExpansionRatio) + 1.0f) * size * 2000.0f);
    }

    public String toString() {
        return "ExhaustPackType{minExpansionRatio=" + this.minExpansionRatio + ", maxExpansionRatio=" + this.maxExpansionRatio + "}";
    }

    public List<ResourceLocation> getAllowedPropellants() {
        return this.allowedPropellants;
    }
}

