/*
 * Decompiled with CFR 0.152.
 */
package com.rae.creatingspace.content.rocket.engine.design;

import com.mojang.datafixers.kinds.App;
import com.mojang.datafixers.kinds.Applicative;
import com.mojang.serialization.Codec;
import com.mojang.serialization.codecs.RecordCodecBuilder;
import java.util.HashMap;
import java.util.Map;
import java.util.function.Function;
import net.minecraft.core.registries.Registries;
import net.minecraft.resources.ResourceKey;
import net.minecraft.tags.TagKey;
import net.minecraft.world.level.material.Fluid;

public class PropellantType {
    static final float R = 8.314463f;
    Map<TagKey<Fluid>, Float> propellantRatio;
    Integer maxISP;
    Float Cp;
    Float gamma;
    Float Rs;
    Integer M;
    public static final Codec<Map<TagKey<Fluid>, Float>> MAP_CODEC = Codec.unboundedMap((Codec)TagKey.m_203877_((ResourceKey)Registries.f_256808_), (Codec)Codec.FLOAT);
    public static final Codec<PropellantType> DIRECT_CODEC = RecordCodecBuilder.create(instance -> instance.group((App)MAP_CODEC.fieldOf("propellantRatio").forGetter(i -> i.propellantRatio), (App)Codec.INT.fieldOf("maxIsp").forGetter(i -> i.maxISP), (App)Codec.FLOAT.fieldOf("Cp").forGetter(i -> i.Cp), (App)Codec.FLOAT.fieldOf("gamma").forGetter(i -> i.gamma), (App)Codec.INT.fieldOf("M").forGetter(i -> i.M)).apply((Applicative)instance, PropellantType::new));

    public PropellantType(Map<TagKey<Fluid>, Float> propellantRatio, Integer maxISP, Float Cp, Float gamma, int M) {
        this.propellantRatio = PropellantType.normalise(propellantRatio);
        this.maxISP = maxISP;
        this.Rs = Float.valueOf(8.314463f / ((float)M / 1000.0f));
        this.M = M;
        this.gamma = gamma;
        this.Cp = Cp;
    }

    private static Map<TagKey<Fluid>, Float> normalise(Map<TagKey<Fluid>, Float> propellantConsumptions) {
        Float total = Float.valueOf(0.0f);
        HashMap<TagKey<Fluid>, Float> newMap = new HashMap<TagKey<Fluid>, Float>(propellantConsumptions);
        for (float f : propellantConsumptions.values()) {
            total = Float.valueOf(total.floatValue() + f);
        }
        for (TagKey tagKey : propellantConsumptions.keySet()) {
            newMap.put((TagKey<Fluid>)tagKey, Float.valueOf(propellantConsumptions.get(tagKey).floatValue() / total.floatValue()));
        }
        return newMap;
    }

    public String toString() {
        return "PropellantType{propellantRatio=" + this.propellantRatio + ", maxISP=" + this.maxISP + "}";
    }

    public Map<TagKey<Fluid>, Float> getPropellantRatio() {
        return this.propellantRatio;
    }

    public Float getCombustionTemperature(float combustionEfficiency) {
        return Float.valueOf(300.0f + (float)(0.5 * Math.pow((double)this.maxISP.intValue() * 9.81, 2.0) * (double)combustionEfficiency / (double)this.Cp.floatValue()));
    }

    private float machErFunc(float expansionRatio, float mach) {
        return (float)(Math.pow((this.gamma.floatValue() + 1.0f) / 2.0f, -(this.gamma.floatValue() + 1.0f) / (2.0f * (this.gamma.floatValue() - 1.0f))) * Math.pow(1.0 + (double)((this.gamma.floatValue() - 1.0f) / 2.0f) * Math.pow(mach, 2.0), (this.gamma.floatValue() + 1.0f) / (2.0f * (this.gamma.floatValue() - 1.0f))) / (double)mach - (double)expansionRatio);
    }

    float getAreaOfThroat(float size) {
        return size / 6.0f;
    }

    private float getExhaustTemperature(float mach, float combustionEfficiency) {
        return (float)(Math.pow(1.0 + (double)((this.gamma.floatValue() - 1.0f) / 2.0f) * Math.pow(mach, 2.0), -1.0) * (double)this.getCombustionTemperature(combustionEfficiency).floatValue());
    }

    private float dichotomy(Function<Float, Float> function, float a, float b, float epsilon) {
        try {
            if (function.apply(Float.valueOf(a)).floatValue() * function.apply(Float.valueOf(b)).floatValue() > 0.0f) {
                throw new RuntimeException("Mauvais choix de a ou b.");
            }
            float m = (float)((double)(a + b) / 2.0);
            while (Math.abs(a - b) > epsilon) {
                if ((double)function.apply(Float.valueOf(m)).floatValue() == 0.0) {
                    return m;
                }
                if (function.apply(Float.valueOf(a)).floatValue() * function.apply(Float.valueOf(m)).floatValue() > 0.0f) {
                    a = m;
                } else {
                    b = m;
                }
                m = (a + b) / 2.0f;
            }
            return m;
        }
        catch (RuntimeException e) {
            System.out.println(e);
            return 0.0f;
        }
    }

    public Float getExitMach(float expansionRatio) {
        return Float.valueOf(this.dichotomy(mach -> Float.valueOf(this.machErFunc(expansionRatio, mach.floatValue())), 1.0f, 1000.0f, 0.002f));
    }

    public Integer getMaxISP() {
        return this.maxISP;
    }

    private float getExhaustVelocity(float mach, float combustionEfficiency) {
        return (float)((double)mach * Math.pow(this.gamma.floatValue() * this.Rs.floatValue() * this.getExhaustTemperature(mach, combustionEfficiency), 0.5));
    }

    public float getRealIsp(float combustionEfficiency, float expansionRatio) {
        return (float)((double)this.getExhaustVelocity(this.getExitMach(expansionRatio).floatValue(), combustionEfficiency) / 9.81);
    }

    public float getChamberPressure(float thrust, float size, float combustionEfficiency, float expansionRatio) {
        float q = thrust / this.getRealIsp(combustionEfficiency, expansionRatio);
        return (float)((double)q * (Math.pow(this.getCombustionTemperature(combustionEfficiency).floatValue() * this.Rs.floatValue() / this.gamma.floatValue(), 0.5) / (double)this.getAreaOfThroat(size) * Math.pow((this.gamma.floatValue() + 1.0f) / 2.0f, (this.gamma.floatValue() + 1.0f) / (2.0f * (this.gamma.floatValue() - 1.0f)))));
    }
}

