/*
 * Decompiled with CFR 0.152.
 */
package com.rae.creatingspace.content.rocket.engine.table;

import com.mojang.serialization.DynamicOps;
import com.rae.creatingspace.content.rocket.engine.RocketEngineItem;
import com.rae.creatingspace.content.rocket.engine.design.ExhaustPackType;
import com.rae.creatingspace.content.rocket.engine.design.PowerPackType;
import com.rae.creatingspace.content.rocket.engine.design.PropellantType;
import com.rae.creatingspace.init.MiscInit;
import com.rae.creatingspace.init.ingameobject.PropellantTypeInit;
import java.util.List;
import net.minecraft.nbt.CompoundTag;
import net.minecraft.nbt.NbtOps;
import net.minecraft.nbt.Tag;
import net.minecraft.network.chat.Component;
import net.minecraft.resources.ResourceLocation;
import net.minecraft.world.item.Item;
import net.minecraft.world.item.ItemStack;
import net.minecraft.world.item.TooltipFlag;
import net.minecraft.world.level.Level;
import org.jetbrains.annotations.Nullable;

public class EngineFabricationBlueprint
extends Item {
    public EngineFabricationBlueprint(Item.Properties properties) {
        super(properties);
    }

    public void m_7373_(ItemStack itemStack, @Nullable Level level, List<Component> components, TooltipFlag tooltipFlag) {
        CompoundTag recipeData = itemStack.m_41737_("engineRecipeData");
        try {
            CompoundTag engineInfo;
            if (recipeData != null) {
                int size = recipeData.m_128451_("size");
                int materialLevel = recipeData.m_128451_("materialLevel");
                if (recipeData.m_128441_("size")) {
                    components.add((Component)Component.m_237113_((String)("size : " + size)));
                }
                if (recipeData.m_128441_("materialLevel")) {
                    components.add((Component)Component.m_237113_((String)("materialLevel : " + materialLevel)));
                }
                try {
                    ResourceLocation exhaustPackType = (ResourceLocation)ResourceLocation.f_135803_.parse((DynamicOps)NbtOps.f_128958_, (Object)recipeData.m_128423_("exhaustPackType")).get().orThrow();
                    components.add((Component)Component.m_237115_((String)exhaustPackType.m_214296_("exhaust_pack_type")));
                }
                catch (Exception exhaustPackType) {
                    // empty catch block
                }
                try {
                    ResourceLocation powerPackType = (ResourceLocation)ResourceLocation.f_135803_.parse((DynamicOps)NbtOps.f_128958_, (Object)recipeData.m_128423_("powerPackType")).get().orThrow();
                    components.add((Component)Component.m_237115_((String)powerPackType.m_214296_("power_pack_type")));
                }
                catch (Exception exception) {
                    // empty catch block
                }
            }
            if ((engineInfo = itemStack.m_41737_("blockEntity")) != null) {
                components.add((Component)Component.m_237113_((String)"for engine :"));
                RocketEngineItem.appendEngineDependentText(components, engineInfo);
            }
        }
        catch (Exception exception) {
            // empty catch block
        }
        super.m_7373_(itemStack, level, components, tooltipFlag);
    }

    public ItemStack getBlueprintForEngine(int throatArea, int expansionRatio, int materialLevel, int thrust, float efficiency, ResourceLocation propellantTypeLocation, ResourceLocation exhaustPackTypeLocation, ResourceLocation powerPackTypeLocation) {
        PropellantType propellantType = PropellantTypeInit.getSyncedPropellantRegistry().m_6612_(propellantTypeLocation).orElse((PropellantType)PropellantTypeInit.METHALOX.get());
        ExhaustPackType exhaustPackType = (ExhaustPackType)MiscInit.getSyncedExhaustPackRegistry().m_7745_(exhaustPackTypeLocation);
        PowerPackType powerPackType = (PowerPackType)MiscInit.getSyncedPowerPackRegistry().m_7745_(powerPackTypeLocation);
        ItemStack defaultInstance = super.m_7968_();
        CompoundTag nbt = defaultInstance.m_41784_();
        CompoundTag engineInfo = new CompoundTag();
        engineInfo.m_128405_("thrust", thrust);
        assert (exhaustPackType != null);
        engineInfo.m_128405_("mass", exhaustPackType.getMass((float)throatArea / 1000.0f, expansionRatio));
        engineInfo.m_128350_("efficiency", efficiency);
        engineInfo.m_128365_("propellantType", (Tag)ResourceLocation.f_135803_.encodeStart((DynamicOps)NbtOps.f_128958_, (Object)propellantTypeLocation).get().orThrow());
        CompoundTag recipeData = new CompoundTag();
        recipeData.m_128365_("exhaustPackType", (Tag)ResourceLocation.f_135803_.encodeStart((DynamicOps)NbtOps.f_128958_, (Object)exhaustPackTypeLocation).get().orThrow());
        recipeData.m_128365_("powerPackType", (Tag)ResourceLocation.f_135803_.encodeStart((DynamicOps)NbtOps.f_128958_, (Object)powerPackTypeLocation).get().orThrow());
        recipeData.m_128405_("size", throatArea);
        recipeData.m_128405_("expansionRatio", expansionRatio);
        recipeData.m_128405_("materialLevel", materialLevel);
        nbt.m_128365_("blockEntity", (Tag)engineInfo);
        nbt.m_128365_("engineRecipeData", (Tag)recipeData);
        defaultInstance.m_41751_(nbt);
        return defaultInstance;
    }
}

