/*
 * Decompiled with CFR 0.152.
 */
package com.rae.creatingspace.init;

import com.simibubi.create.AllTags;
import com.simibubi.create.foundation.utility.CreateLang;
import net.minecraft.core.Holder;
import net.minecraft.core.registries.Registries;
import net.minecraft.resources.ResourceKey;
import net.minecraft.resources.ResourceLocation;
import net.minecraft.tags.BlockTags;
import net.minecraft.tags.FluidTags;
import net.minecraft.tags.ItemTags;
import net.minecraft.tags.TagKey;
import net.minecraft.world.entity.Entity;
import net.minecraft.world.entity.EntityType;
import net.minecraft.world.item.BlockItem;
import net.minecraft.world.item.Item;
import net.minecraft.world.item.ItemStack;
import net.minecraft.world.level.biome.Biome;
import net.minecraft.world.level.block.Block;
import net.minecraft.world.level.block.state.BlockState;
import net.minecraft.world.level.material.Fluid;
import net.minecraft.world.level.material.FluidState;
import net.minecraftforge.registries.ForgeRegistries;
import net.minecraftforge.registries.IForgeRegistry;

public class TagsInit
extends AllTags {
    public static void init() {
        CustomBlockTags.init();
        CustomItemTags.init();
        CustomEntityTag.init();
        CustomFluidTags.init();
        CustomBiomeTags.init();
    }

    public static enum CustomBlockTags {
        MOON_CARVER_REPLACEABLES,
        MOON_STONE_ORE_REPLACEABLES;

        public final TagKey<Block> tag;
        public final boolean alwaysDatagen;

        private CustomBlockTags() {
            this(CustomNameSpace.MOD);
        }

        private CustomBlockTags(CustomNameSpace namespace) {
            this(namespace, namespace.optionalDefault, namespace.alwaysDatagenDefault);
        }

        private CustomBlockTags(CustomNameSpace namespace, String path) {
            this(namespace, path, namespace.optionalDefault, namespace.alwaysDatagenDefault);
        }

        private CustomBlockTags(CustomNameSpace namespace, boolean optional, boolean alwaysDatagen) {
            this(namespace, null, optional, alwaysDatagen);
        }

        private CustomBlockTags(CustomNameSpace namespace, String path, boolean optional, boolean alwaysDatagen) {
            ResourceLocation id = new ResourceLocation(namespace.id, path == null ? CreateLang.asId((String)this.name()) : path);
            this.tag = optional ? AllTags.optionalTag((IForgeRegistry)ForgeRegistries.BLOCKS, (ResourceLocation)id) : BlockTags.create((ResourceLocation)id);
            this.alwaysDatagen = alwaysDatagen;
        }

        public boolean matches(Block block) {
            return block.m_204297_().m_203656_(this.tag);
        }

        public boolean matches(ItemStack stack) {
            BlockItem blockItem;
            Item item;
            return stack != null && (item = stack.m_41720_()) instanceof BlockItem && this.matches((blockItem = (BlockItem)item).m_40614_());
        }

        public boolean matches(BlockState state) {
            return state.m_204336_(this.tag);
        }

        private static void init() {
        }
    }

    public static enum CustomItemTags {
        OXYGEN_SOURCES,
        SPACESUIT;

        public final TagKey<Item> tag;
        public final boolean alwaysDatagen;

        private CustomItemTags() {
            this(CustomNameSpace.MOD);
        }

        private CustomItemTags(String path) {
            this(CustomNameSpace.MOD, path);
        }

        private CustomItemTags(CustomNameSpace namespace) {
            this(namespace, namespace.optionalDefault, namespace.alwaysDatagenDefault);
        }

        private CustomItemTags(CustomNameSpace namespace, String path) {
            this(namespace, path, namespace.optionalDefault, namespace.alwaysDatagenDefault);
        }

        private CustomItemTags(CustomNameSpace namespace, boolean optional, boolean alwaysDatagen) {
            this(namespace, null, optional, alwaysDatagen);
        }

        private CustomItemTags(CustomNameSpace namespace, String path, boolean optional, boolean alwaysDatagen) {
            ResourceLocation id = new ResourceLocation(namespace.id, path == null ? CreateLang.asId((String)this.name()) : path);
            this.tag = optional ? AllTags.optionalTag((IForgeRegistry)ForgeRegistries.ITEMS, (ResourceLocation)id) : ItemTags.create((ResourceLocation)id);
            this.alwaysDatagen = alwaysDatagen;
        }

        public boolean matches(Item item) {
            return item.m_204114_().m_203656_(this.tag);
        }

        public boolean matches(ItemStack stack) {
            return stack.m_204117_(this.tag);
        }

        private static void init() {
        }
    }

    public static enum CustomEntityTag {
        SPACE_CREATURES;

        public final TagKey<EntityType<?>> tag;
        public final boolean alwaysDatagen;

        private CustomEntityTag() {
            this(CustomNameSpace.MOD);
        }

        private CustomEntityTag(CustomNameSpace namespace) {
            this(namespace, namespace.optionalDefault, namespace.alwaysDatagenDefault);
        }

        private CustomEntityTag(CustomNameSpace namespace, String path) {
            this(namespace, path, namespace.optionalDefault, namespace.alwaysDatagenDefault);
        }

        private CustomEntityTag(CustomNameSpace namespace, boolean optional, boolean alwaysDatagen) {
            this(namespace, null, optional, alwaysDatagen);
        }

        private CustomEntityTag(CustomNameSpace namespace, String path, boolean optional, boolean alwaysDatagen) {
            ResourceLocation id = new ResourceLocation(namespace.id, path == null ? CreateLang.asId((String)this.name()) : path);
            this.tag = optional ? AllTags.optionalTag((IForgeRegistry)ForgeRegistries.ENTITY_TYPES, (ResourceLocation)id) : TagKey.m_203882_((ResourceKey)Registries.f_256939_, (ResourceLocation)id);
            this.alwaysDatagen = alwaysDatagen;
        }

        public boolean matches(Entity entity) {
            return entity.m_6095_().m_204039_(this.tag);
        }

        private static void init() {
        }
    }

    public static enum CustomFluidTags {
        LIQUID_METHANE,
        LIQUID_HYDROGEN,
        LIQUID_OXYGEN,
        METALIC_HYDROGEN,
        DISSIPATE_IN_SPACE,
        LIQUID_CO2;

        public final TagKey<Fluid> tag;
        public final boolean alwaysDatagen;

        private CustomFluidTags() {
            this(CustomNameSpace.MOD);
        }

        private CustomFluidTags(CustomNameSpace namespace) {
            this(namespace, namespace.optionalDefault, namespace.alwaysDatagenDefault);
        }

        private CustomFluidTags(CustomNameSpace namespace, String path) {
            this(namespace, path, namespace.optionalDefault, namespace.alwaysDatagenDefault);
        }

        private CustomFluidTags(CustomNameSpace namespace, boolean optional, boolean alwaysDatagen) {
            this(namespace, null, optional, alwaysDatagen);
        }

        private CustomFluidTags(CustomNameSpace namespace, String path, boolean optional, boolean alwaysDatagen) {
            ResourceLocation id = new ResourceLocation(namespace.id, path == null ? CreateLang.asId((String)this.name()) : path);
            this.tag = optional ? AllTags.optionalTag((IForgeRegistry)ForgeRegistries.FLUIDS, (ResourceLocation)id) : FluidTags.create((ResourceLocation)id);
            this.alwaysDatagen = alwaysDatagen;
        }

        public boolean matches(Fluid fluid) {
            return fluid.m_205067_(this.tag);
        }

        public boolean matches(FluidState state) {
            return state.m_205070_(this.tag);
        }

        private static void init() {
        }
    }

    public static enum CustomBiomeTags {
        NO_OXYGEN;

        public final TagKey<Biome> tag;
        public final boolean alwaysDatagen;

        private CustomBiomeTags() {
            this(CustomNameSpace.MOD);
        }

        private CustomBiomeTags(CustomNameSpace namespace) {
            this(namespace, namespace.optionalDefault, namespace.alwaysDatagenDefault);
        }

        private CustomBiomeTags(CustomNameSpace namespace, String path) {
            this(namespace, path, namespace.optionalDefault, namespace.alwaysDatagenDefault);
        }

        private CustomBiomeTags(CustomNameSpace namespace, boolean optional, boolean alwaysDatagen) {
            this(namespace, null, optional, alwaysDatagen);
        }

        private CustomBiomeTags(CustomNameSpace namespace, String path, boolean optional, boolean alwaysDatagen) {
            ResourceLocation id = new ResourceLocation(namespace.id, path == null ? CreateLang.asId((String)this.name()) : path);
            this.tag = optional ? AllTags.optionalTag((IForgeRegistry)ForgeRegistries.BIOMES, (ResourceLocation)id) : TagKey.m_203882_((ResourceKey)Registries.f_256952_, (ResourceLocation)id);
            this.alwaysDatagen = alwaysDatagen;
        }

        public boolean matches(Biome biome) {
            return this.matches((Holder<Biome>)((Holder)ForgeRegistries.BIOMES.getHolder((Object)biome).orElse(null)));
        }

        public boolean matches(ResourceLocation biome) {
            return this.matches((Holder<Biome>)((Holder)ForgeRegistries.BIOMES.getHolder(biome).orElse(null)));
        }

        public boolean matches(Holder<Biome> biome) {
            if (biome != null) {
                return biome.m_203656_(this.tag);
            }
            return false;
        }

        private static void init() {
        }
    }

    public static enum CustomNameSpace {
        MOD("creatingspace", false, true),
        FORGE("forge"),
        TIC("tconstruct"),
        QUARK("quark");

        public final String id;
        public final boolean optionalDefault;
        public final boolean alwaysDatagenDefault;

        private CustomNameSpace(String id) {
            this(id, true, false);
        }

        private CustomNameSpace(String id, boolean optionalDefault, boolean alwaysDatagenDefault) {
            this.id = id;
            this.optionalDefault = optionalDefault;
            this.alwaysDatagenDefault = alwaysDatagenDefault;
        }
    }
}

