/*
 * Decompiled with CFR 0.152.
 */
package com.rae.creatingspace.legacy.server.particle;

import com.rae.creatingspace.legacy.server.particle.RocketPlumeParticleData;
import java.util.List;
import javax.annotation.Nonnull;
import net.createmod.catnip.theme.Color;
import net.minecraft.client.multiplayer.ClientLevel;
import net.minecraft.client.particle.Particle;
import net.minecraft.client.particle.ParticleProvider;
import net.minecraft.client.particle.ParticleRenderType;
import net.minecraft.client.particle.SimpleAnimatedParticle;
import net.minecraft.client.particle.SpriteSet;
import net.minecraft.core.BlockPos;
import net.minecraft.core.Direction;
import net.minecraft.util.Mth;
import net.minecraft.world.entity.Entity;
import net.minecraft.world.level.BlockGetter;
import net.minecraft.world.level.Level;
import net.minecraft.world.level.block.Blocks;
import net.minecraft.world.level.block.state.BlockState;
import net.minecraft.world.phys.AABB;
import net.minecraft.world.phys.Vec3;

public class PlumeParticle
extends SimpleAnimatedParticle {
    public static final float SIZE_FACTOR = 0.55f;
    private final float drag;
    private Vec3 speed;

    public PlumeParticle(ClientLevel world, RocketPlumeParticleData data, double x, double y, double z, double xSpeed, double ySpeed, double zSpeed, SpriteSet sprite) {
        super(world, x, y, z, sprite, world.f_46441_.m_188501_() * 0.5f);
        this.f_107225_ = (int)(200.0f * world.f_46441_.m_188501_());
        this.f_107219_ = true;
        this.selectSprite(0);
        this.m_107264_(x, y, z);
        this.drag = (float)((double)data.drag * Math.max(0.8, (double)world.f_46441_.m_188501_() + 0.4));
        this.f_107209_ = x;
        this.f_107210_ = y;
        this.f_107211_ = z;
        this.speed = new Vec3(xSpeed, ySpeed, zSpeed);
        this.f_107663_ = (float)this.speed.m_82553_() * 0.55f;
        this.morphColor();
    }

    @Nonnull
    public ParticleRenderType m_7556_() {
        return ParticleRenderType.f_107431_;
    }

    public void m_5989_() {
        this.f_107209_ = this.f_107212_;
        this.f_107210_ = this.f_107213_;
        this.f_107211_ = this.f_107214_;
        if (this.f_107224_++ >= this.f_107225_) {
            this.m_107274_();
            return;
        }
        if (!this.isFlame()) {
            this.selectSprite(2 + this.f_107224_ / 200);
            if (this.f_107663_ < 3.0f) {
                this.m_107250_((float)(1.0 / this.speed.m_82553_()), (float)(1.0 / this.speed.m_82553_()));
            }
            if (this.speed.m_82553_() < (double)0.05f) {
                this.m_107274_();
                return;
            }
        } else {
            this.f_107663_ = (float)this.speed.m_82553_() * 0.55f;
        }
        if (this.speed.m_82553_() < (double)0.05f) {
            this.m_107274_();
            return;
        }
        if (this.drag != 0.0f) {
            float scaleFactor = this.drag > 0.0f ? 1.0f / (1.0f + this.drag) : 1.0f - this.drag;
            this.speed = this.speed.m_82490_((double)scaleFactor);
        }
        this.f_107215_ = this.speed.m_7096_();
        this.f_107216_ = this.speed.m_7098_();
        this.f_107217_ = this.speed.m_7094_();
        this.morphColor();
        this.m_6257_(this.f_107215_, this.f_107216_, this.f_107217_);
        if (this.isCloseToGround() && this.isFlame()) {
            this.setFire();
        }
    }

    private boolean isCloseToGround() {
        BlockPos pos = new BlockPos((int)this.f_107212_, (int)this.f_107213_, (int)this.f_107214_);
        for (int i = 1; i <= 3; ++i) {
            BlockPos below = pos.m_6625_(i);
            if (this.f_107208_.m_46859_(below)) continue;
            return true;
        }
        return false;
    }

    public void m_6257_(double vx, double vy, double vz) {
        Vec3 vFinal;
        Vec3 vec3 = Entity.m_198894_(null, (Vec3)new Vec3(vx, vy, vz), (AABB)this.m_107277_(), (Level)this.f_107208_, List.of());
        float coef = vec3.m_82554_(new Vec3(vx, vy, vz)) > 0.1 ? 0.7f : 1.0f;
        this.speed = vFinal = vec3.m_82541_().m_82490_(this.speed.m_82553_() * (double)coef);
        this.m_107259_(this.m_107277_().m_82383_(vec3));
        this.m_107275_();
    }

    public void setFire() {
        Direction[] directions;
        BlockPos pos = new BlockPos((int)this.f_107212_, (int)this.f_107213_ - 1, (int)this.f_107214_);
        BlockState blockState = this.f_107208_.m_8055_(pos);
        for (Direction direction : directions = new Direction[]{Direction.UP, Direction.DOWN, Direction.NORTH, Direction.SOUTH, Direction.EAST, Direction.WEST}) {
            BlockPos adjacentPos = pos.m_121945_(direction);
            BlockState adjacentState = this.f_107208_.m_8055_(adjacentPos);
            if (!this.f_107208_.m_46859_(adjacentPos) || !blockState.m_60734_().isFlammable(blockState, (BlockGetter)this.f_107208_, pos, direction)) continue;
            this.f_107208_.m_46597_(adjacentPos, Blocks.f_50083_.m_49966_());
            break;
        }
    }

    public void morphColor() {
        float speedFactor = (float)this.speed.m_82553_();
        Color yellow = new Color(-10240);
        Color red = new Color(-65536);
        Color color = red.mixWith(yellow, speedFactor / 1.6f);
        if (this.speed.m_82553_() < 1.0) {
            color = Color.WHITE;
        }
        Vec3 colorVec = color.asVector();
        this.m_107253_((float)colorVec.f_82479_, (float)colorVec.f_82480_, (float)colorVec.f_82481_);
        this.m_107271_((float)Mth.m_14008_((double)this.speed.m_82553_(), (double)0.2, (double)1.0));
    }

    private boolean isFlame() {
        return this.speed.m_82553_() > (double)1.1f;
    }

    public int m_6355_(float partialTick) {
        BlockPos blockpos = new BlockPos((int)this.f_107212_, (int)this.f_107213_, (int)this.f_107214_);
        return this.f_107208_.m_46749_(blockpos) ? 0xF000F0 : 0;
    }

    private void selectSprite(int index) {
        this.m_108337_(this.f_107644_.m_5819_(index, 8));
    }

    public static class Factory
    implements ParticleProvider<RocketPlumeParticleData> {
        private final SpriteSet spriteSet;

        public Factory(SpriteSet animatedSprite) {
            this.spriteSet = animatedSprite;
        }

        public Particle createParticle(RocketPlumeParticleData data, ClientLevel worldIn, double x, double y, double z, double xSpeed, double ySpeed, double zSpeed) {
            return new PlumeParticle(worldIn, data, x, y, z, xSpeed, ySpeed, zSpeed, this.spriteSet);
        }
    }
}

