/*
 * Decompiled with CFR 0.152.
 */
package com.rae.creatingspace.legacy.utilities;

import java.math.BigDecimal;

public class CSUtil {
    public static boolean isInteger(String input) {
        try {
            Integer.parseInt(input);
            return true;
        }
        catch (Exception e) {
            return false;
        }
    }

    public static String scientificNbrFormatting(Float toRound, int digit) {
        try {
            return CSUtil.scientificNbrFormatting(BigDecimal.valueOf(toRound.floatValue()), digit);
        }
        catch (NumberFormatException exception) {
            return "NaN";
        }
    }

    public static String scientificNbrFormatting(BigDecimal toRound, int digit) {
        if (toRound.floatValue() == 0.0f) {
            return "0";
        }
        BigDecimal rounded = toRound;
        int nbrOf10Pow = 0;
        while ((rounded.floatValue() > 1000.0f || (double)rounded.floatValue() < 0.1) && -3 < nbrOf10Pow && nbrOf10Pow < 6) {
            if (rounded.floatValue() > 1.0f) {
                rounded = rounded.movePointLeft(3);
                nbrOf10Pow += 3;
                continue;
            }
            if (!(rounded.floatValue() < 1.0f)) continue;
            rounded = rounded.movePointRight(3);
            nbrOf10Pow -= 3;
        }
        String unitCoef = nbrOf10Pow >= 6 ? "M" : (nbrOf10Pow >= 3 ? "k" : (nbrOf10Pow >= 0 ? "" : "m"));
        String floatString = String.valueOf(rounded.floatValue());
        return floatString.subSequence(0, Math.min(floatString.length(), (double)rounded.floatValue() < Math.pow(10.0, digit - 1) ? digit + 1 : digit)) + unitCoef;
    }
}

