/*
 * Decompiled with CFR 0.152.
 */
package com.nanaios.curiosable_ammo_box.util;

import java.util.Map;
import net.minecraft.world.entity.LivingEntity;
import net.minecraft.world.entity.player.Inventory;
import net.minecraft.world.item.ItemStack;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;
import top.theillusivec4.curios.api.CuriosApi;
import top.theillusivec4.curios.api.type.capability.ICuriosItemHandler;
import top.theillusivec4.curios.api.type.inventory.ICurioStacksHandler;
import top.theillusivec4.curios.api.type.inventory.IDynamicStackHandler;

public class InventoryWithCurios
extends Inventory {
    @Nullable
    private ICuriosItemHandler curiosInventory;
    private final Inventory overrideInventory;

    public InventoryWithCurios(Inventory inventory) {
        super(inventory.f_35978_);
        this.overrideInventory = inventory;
        CuriosApi.getCuriosInventory((LivingEntity)this.f_35978_).ifPresent(iCuriosItemHandler -> {
            this.curiosInventory = iCuriosItemHandler;
        });
    }

    public int m_6643_() {
        int defaultContainerSize = this.overrideInventory.m_6643_();
        int curiosSize = this.curiosInventory != null ? this.curiosInventory.getSlots() : 0;
        int playerInventorySize = this.f_35978_.m_150109_().f_35976_.size();
        return defaultContainerSize + curiosSize + playerInventorySize;
    }

    private ItemStack getItemFromCurios(int index) {
        if (this.curiosInventory == null) {
            return ItemStack.f_41583_;
        }
        int count = 0;
        for (Map.Entry curiosEntry : this.curiosInventory.getCurios().entrySet()) {
            IDynamicStackHandler handler = ((ICurioStacksHandler)curiosEntry.getValue()).getStacks();
            for (int j = 0; j < handler.getSlots(); ++j) {
                if (index == count) {
                    return handler.getStackInSlot(j);
                }
                ++count;
            }
        }
        return ItemStack.f_41583_;
    }

    @NotNull
    public ItemStack m_8020_(int index) {
        int curiosSize;
        int overrideInventoryContainerSize = this.overrideInventory.m_6643_();
        if (index < overrideInventoryContainerSize) {
            return this.overrideInventory.m_8020_(index);
        }
        int n = curiosSize = this.curiosInventory != null ? this.curiosInventory.getSlots() : 0;
        if (index < (curiosSize += overrideInventoryContainerSize)) {
            return this.getItemFromCurios(index - overrideInventoryContainerSize);
        }
        return (ItemStack)this.f_35978_.m_150109_().f_35976_.get(index - curiosSize);
    }
}

