/*
 * Decompiled with CFR 0.152.
 */
package mod.azure.doom.entities;

import java.util.UUID;
import mod.azure.azurelib.ai.pathing.AzureNavigation;
import mod.azure.azurelib.animatable.GeoEntity;
import mod.azure.azurelib.network.packet.EntityPacket;
import mod.azure.doom.entities.projectiles.entity.BarenBlastEntity;
import mod.azure.doom.entities.projectiles.entity.BloodBoltEntity;
import mod.azure.doom.entities.projectiles.entity.CustomFireballEntity;
import mod.azure.doom.entities.projectiles.entity.CustomSmallFireballEntity;
import mod.azure.doom.entities.projectiles.entity.DroneBoltEntity;
import mod.azure.doom.entities.projectiles.entity.EnergyCellMobEntity;
import mod.azure.doom.entities.projectiles.entity.FireProjectile;
import mod.azure.doom.entities.projectiles.entity.GladiatorMaceEntity;
import mod.azure.doom.entities.projectiles.entity.RocketMobEntity;
import net.minecraft.core.BlockPos;
import net.minecraft.nbt.CompoundTag;
import net.minecraft.network.protocol.Packet;
import net.minecraft.network.protocol.game.ClientGamePacketListener;
import net.minecraft.network.syncher.EntityDataAccessor;
import net.minecraft.network.syncher.EntityDataSerializer;
import net.minecraft.network.syncher.EntityDataSerializers;
import net.minecraft.network.syncher.SynchedEntityData;
import net.minecraft.sounds.SoundEvent;
import net.minecraft.sounds.SoundEvents;
import net.minecraft.tags.FluidTags;
import net.minecraft.util.RandomSource;
import net.minecraft.util.TimeUtil;
import net.minecraft.util.valueproviders.UniformInt;
import net.minecraft.world.Difficulty;
import net.minecraft.world.damagesource.DamageSource;
import net.minecraft.world.effect.MobEffectInstance;
import net.minecraft.world.effect.MobEffects;
import net.minecraft.world.entity.Entity;
import net.minecraft.world.entity.EntityType;
import net.minecraft.world.entity.LivingEntity;
import net.minecraft.world.entity.Mob;
import net.minecraft.world.entity.MobSpawnType;
import net.minecraft.world.entity.MobType;
import net.minecraft.world.entity.NeutralMob;
import net.minecraft.world.entity.ai.navigation.PathNavigation;
import net.minecraft.world.entity.monster.Enemy;
import net.minecraft.world.entity.monster.Monster;
import net.minecraft.world.entity.projectile.ThrownPotion;
import net.minecraft.world.item.ItemStack;
import net.minecraft.world.item.Items;
import net.minecraft.world.item.alchemy.Potion;
import net.minecraft.world.item.alchemy.PotionUtils;
import net.minecraft.world.item.alchemy.Potions;
import net.minecraft.world.level.ItemLike;
import net.minecraft.world.level.Level;
import net.minecraft.world.level.LevelAccessor;
import net.minecraft.world.level.block.Blocks;
import net.minecraft.world.level.material.FluidState;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;

public abstract class DemonEntity
extends Monster
implements NeutralMob,
Enemy,
GeoEntity {
    protected int flameTimer;
    private UUID targetUuid;
    protected int targetChangeTime;
    private static final UniformInt ANGER_TIME_RANGE = TimeUtil.m_145020_((int)20, (int)39);
    public static final EntityDataAccessor<Boolean> SCREAM = SynchedEntityData.m_135353_(DemonEntity.class, (EntityDataSerializer)EntityDataSerializers.f_135035_);
    public static final EntityDataAccessor<Integer> STATE = SynchedEntityData.m_135353_(DemonEntity.class, (EntityDataSerializer)EntityDataSerializers.f_135028_);
    private static final EntityDataAccessor<Integer> ANGER_TIME = SynchedEntityData.m_135353_(DemonEntity.class, (EntityDataSerializer)EntityDataSerializers.f_135028_);

    protected DemonEntity(EntityType<? extends Monster> type, Level worldIn) {
        super(type, worldIn);
        this.f_21364_ = (int)this.m_21233_();
        this.m_274367_(1.5f);
    }

    public static boolean canSpawnInDark(EntityType<? extends DemonEntity> ignoredType, LevelAccessor serverWorldAccess, MobSpawnType ignoredSpawnReason, BlockPos pos, RandomSource ignoredRandom) {
        if (serverWorldAccess.m_46791_() == Difficulty.PEACEFUL) {
            return false;
        }
        return !serverWorldAccess.m_8055_(pos.m_7495_()).m_60713_(Blocks.f_50451_);
    }

    @NotNull
    public MobType m_6336_() {
        return MobType.f_21641_;
    }

    public boolean m_203441_(FluidState fluidState) {
        return fluidState.m_205070_(FluidTags.f_13132_);
    }

    public int getAttckingState() {
        return (Integer)this.f_19804_.m_135370_(STATE);
    }

    public void setAttackingState(int time) {
        this.f_19804_.m_135381_(STATE, (Object)time);
    }

    protected void m_8097_() {
        super.m_8097_();
        this.f_19804_.m_135372_(ANGER_TIME, (Object)0);
        this.f_19804_.m_135372_(STATE, (Object)0);
        this.f_19804_.m_135372_(SCREAM, (Object)false);
    }

    public void m_7378_(@NotNull CompoundTag compound) {
        super.m_7378_(compound);
        this.setAttackingState(compound.m_128451_("state"));
    }

    public void m_7380_(@NotNull CompoundTag tag) {
        super.m_7380_(tag);
        tag.m_128405_("state", this.getAttckingState());
    }

    public int m_6784_() {
        return (Integer)this.f_19804_.m_135370_(ANGER_TIME);
    }

    public void m_7870_(int ticks) {
        this.f_19804_.m_135381_(ANGER_TIME, (Object)ticks);
    }

    public UUID m_6120_() {
        return this.targetUuid;
    }

    public void m_6925_(@Nullable UUID uuid) {
        this.targetUuid = uuid;
    }

    public void m_6825_() {
        this.m_7870_(ANGER_TIME_RANGE.m_214085_(this.f_19796_));
    }

    protected void m_6153_() {
        ++this.f_20919_;
        if (this.f_20919_ == 80) {
            this.m_142687_(Entity.RemovalReason.KILLED);
        }
    }

    public void m_6667_(@NotNull DamageSource damageSource) {
        super.m_6667_(damageSource);
        this.triggerAnim("livingController", "death");
    }

    protected float m_6121_() {
        return 0.4f;
    }

    @NotNull
    protected PathNavigation m_6037_(@NotNull Level world) {
        return new AzureNavigation((Mob)this, world);
    }

    public void m_8032_() {
        SoundEvent soundEvent = this.m_7515_();
        if (soundEvent != null) {
            this.m_5496_(soundEvent, 0.25f, this.m_6100_());
        }
    }

    public boolean m_6469_(@NotNull DamageSource source, float amount) {
        if (source == this.m_269291_().m_269318_() || source == this.m_269291_().m_269549_() || source == this.m_269291_().m_269387_()) {
            return false;
        }
        return super.m_6469_(source, amount);
    }

    @NotNull
    public Packet<ClientGamePacketListener> m_5654_() {
        return EntityPacket.createPacket((Entity)this);
    }

    public void shootBloodBolt(float damage) {
        if (!this.m_9236_().f_46443_ && this.m_5448_() != null) {
            BloodBoltEntity projectile = new BloodBoltEntity(this.m_9236_(), (LivingEntity)this, this.m_5448_().m_20185_() - (this.m_20185_() + this.m_20252_((float)1.0f).f_82479_ * 2.0), this.m_5448_().m_20227_(0.5) - this.m_20227_(0.5), this.m_5448_().m_20189_() - (this.m_20189_() + this.m_20252_((float)1.0f).f_82481_ * 2.0), damage);
            projectile.m_6034_(this.m_20185_() + this.m_20252_((float)1.0f).f_82479_, this.m_20227_(0.5), this.m_20189_() + this.m_20252_((float)1.0f).f_82481_);
            this.m_9236_().m_7967_((Entity)projectile);
        }
    }

    public void shootBolt(float damage) {
        if (!this.m_9236_().f_46443_ && this.m_5448_() != null) {
            DroneBoltEntity projectile = new DroneBoltEntity(this.m_9236_(), (LivingEntity)this, this.m_5448_().m_20185_() - (this.m_20185_() + this.m_20252_((float)1.0f).f_82479_ * 2.0), this.m_5448_().m_20227_(0.5) - this.m_20227_(0.5), this.m_5448_().m_20189_() - (this.m_20189_() + this.m_20252_((float)1.0f).f_82481_ * 2.0), damage);
            projectile.m_6034_(this.m_20185_() + this.m_20252_((float)1.0f).f_82479_, this.m_20227_(0.5), this.m_20189_() + this.m_20252_((float)1.0f).f_82481_);
            this.m_9236_().m_7967_((Entity)projectile);
        }
    }

    public void shootEnergyCell(float damage) {
        if (!this.m_9236_().f_46443_ && this.m_5448_() != null) {
            EnergyCellMobEntity projectile = new EnergyCellMobEntity(this.m_9236_(), (LivingEntity)this, this.m_5448_().m_20185_() - (this.m_20185_() + this.m_20252_((float)1.0f).f_82479_ * 2.0), this.m_5448_().m_20227_(0.5) - this.m_20227_(0.5), this.m_5448_().m_20189_() - (this.m_20189_() + this.m_20252_((float)1.0f).f_82481_ * 2.0), damage);
            projectile.m_6034_(this.m_20185_() + this.m_20252_((float)1.0f).f_82479_, this.m_20227_(0.5), this.m_20189_() + this.m_20252_((float)1.0f).f_82481_);
            this.m_9236_().m_7967_((Entity)projectile);
        }
    }

    public void shootMancubus(float damage) {
        if (!this.m_9236_().f_46443_ && this.m_5448_() != null) {
            FireProjectile projectile = new FireProjectile(this.m_9236_(), (LivingEntity)this, this.m_5448_().m_20185_() - (this.m_20185_() + this.m_20252_((float)1.0f).f_82479_ * 2.0), this.m_5448_().m_20227_(0.5) - this.m_20227_(0.5), this.m_5448_().m_20189_() - (this.m_20189_() + this.m_20252_((float)1.0f).f_82481_ * 2.0), damage);
            projectile.m_6034_(this.m_20185_() + this.m_20252_((float)1.0f).f_82479_, this.m_20227_(0.5), this.m_20189_() + this.m_20252_((float)1.0f).f_82481_);
            this.m_9236_().m_7967_((Entity)projectile);
        }
    }

    public void shootRocket(float damage) {
        if (!this.m_9236_().f_46443_ && this.m_5448_() != null) {
            RocketMobEntity projectile = new RocketMobEntity(this.m_9236_(), (LivingEntity)this, this.m_5448_().m_20185_() - (this.m_20185_() + this.m_20252_((float)1.0f).f_82479_ * 2.0), this.m_5448_().m_20227_(0.5) - this.m_20227_(0.5), this.m_5448_().m_20189_() - (this.m_20189_() + this.m_20252_((float)1.0f).f_82481_ * 2.0), damage);
            projectile.m_6034_(this.m_20185_() + this.m_20252_((float)1.0f).f_82479_, this.m_20227_(0.5), this.m_20189_() + this.m_20252_((float)1.0f).f_82481_);
            this.m_9236_().m_7967_((Entity)projectile);
        }
    }

    public void shootFireball(float damage, int offset) {
        if (!this.m_9236_().f_46443_ && this.m_5448_() != null) {
            CustomFireballEntity projectile = new CustomFireballEntity(this.m_9236_(), (LivingEntity)this, this.m_5448_().m_20185_() - (this.m_20185_() + this.m_20252_((float)1.0f).f_82479_ * 2.0), this.m_5448_().m_20227_(0.5) - this.m_20227_(0.5), this.m_5448_().m_20189_() - (this.m_20189_() + this.m_20252_((float)1.0f).f_82481_ * 2.0), damage);
            projectile.m_6034_(this.m_20185_() + this.m_20252_((float)1.0f).f_82479_ + (double)offset, this.m_20227_(0.5), this.m_20189_() + this.m_20252_((float)1.0f).f_82481_);
            this.m_9236_().m_7967_((Entity)projectile);
        }
    }

    public void shootBaron(float damage, double offsetx, double offsety, double offsetz) {
        if (!this.m_9236_().f_46443_ && this.m_5448_() != null) {
            BarenBlastEntity projectile = new BarenBlastEntity(this.m_9236_(), (LivingEntity)this, this.m_5448_().m_20185_() - (this.m_20185_() + this.m_20252_((float)1.0f).f_82479_ * 2.0) + offsetx, this.m_5448_().m_20227_(0.5) - this.m_20227_(0.5) + offsety, this.m_5448_().m_20189_() - (this.m_20189_() + this.m_20252_((float)1.0f).f_82481_ * 2.0) + offsetz, damage);
            projectile.m_6034_(this.m_20185_() + this.m_20252_((float)1.0f).f_82479_ + offsetx, this.m_20227_(0.5) + offsety, this.m_20189_() + this.m_20252_((float)1.0f).f_82481_ + offsetz);
            this.m_9236_().m_7967_((Entity)projectile);
        }
    }

    public void shootSmallFireball(float damage) {
        if (!this.m_9236_().f_46443_ && this.m_5448_() != null) {
            CustomSmallFireballEntity projectile = new CustomSmallFireballEntity(this.m_9236_(), (LivingEntity)this, this.m_5448_().m_20185_() - (this.m_20185_() + this.m_20252_((float)1.0f).f_82479_ * 2.0), this.m_5448_().m_20227_(0.5) - this.m_20227_(0.5), this.m_5448_().m_20189_() - (this.m_20189_() + this.m_20252_((float)1.0f).f_82481_ * 2.0), damage);
            projectile.m_6034_(this.m_20185_() + this.m_20252_((float)1.0f).f_82479_, this.m_20227_(0.5), this.m_20189_() + this.m_20252_((float)1.0f).f_82481_);
            this.m_9236_().m_7967_((Entity)projectile);
        }
    }

    public void shootMace() {
        if (!this.m_9236_().f_46443_ && this.m_5448_() != null) {
            GladiatorMaceEntity projectile = new GladiatorMaceEntity(this.m_9236_(), (LivingEntity)this, this.m_5448_().m_20185_() - (this.m_20185_() + this.m_20252_((float)1.0f).f_82479_ * 2.0), this.m_5448_().m_20227_(0.5) - this.m_20227_(0.5), this.m_5448_().m_20189_() - (this.m_20189_() + this.m_20252_((float)1.0f).f_82481_ * 2.0));
            projectile.m_6034_(this.m_20185_() + this.m_20252_((float)1.0f).f_82479_, this.m_20227_(0.5), this.m_20189_() + this.m_20252_((float)1.0f).f_82481_);
            this.m_9236_().m_7967_((Entity)projectile);
        }
    }

    public void throwPotion(LivingEntity target) {
        if (!this.m_9236_().f_46443_ && this.m_5448_() != null) {
            double d0 = target.m_20185_() + target.m_20184_().f_82479_ - this.m_20185_();
            double d1 = target.m_20188_() - (double)1.1f - this.m_20186_();
            double d2 = target.m_20189_() + target.m_20184_().f_82481_ - this.m_20189_();
            ThrownPotion thrownpotion = new ThrownPotion(this.m_9236_(), (LivingEntity)this);
            thrownpotion.m_37446_(PotionUtils.m_43549_((ItemStack)new ItemStack((ItemLike)Items.f_42736_), (Potion)Potions.f_43584_));
            thrownpotion.m_146926_(thrownpotion.m_146909_() + 20.0f);
            thrownpotion.m_6686_(d0, d1 + Math.sqrt(d0 * d0 + d2 * d2) * 0.2, d2, 0.75f, 8.0f);
            thrownpotion.m_6034_(this.m_20185_() + this.m_20252_((float)1.0f).f_82479_ * 2.0, this.m_20227_(0.5), this.m_20189_() + this.m_20252_((float)1.0f).f_82481_ * 2.0);
            this.m_9236_().m_6263_(null, this.m_20185_(), this.m_20186_(), this.m_20189_(), SoundEvents.f_12553_, this.m_5720_(), 1.0f, 0.8f + this.f_19796_.m_188501_() * 0.4f);
            this.m_9236_().m_7967_((Entity)thrownpotion);
            this.m_7292_(new MobEffectInstance(MobEffects.f_19597_, 10, 10, false, false));
        }
    }
}

