/*
 * Decompiled with CFR 0.152.
 */
package mod.azure.doom.entities.task;

import java.util.function.Consumer;
import mod.azure.doom.entities.DemonEntity;
import mod.azure.doom.entities.tierboss.GladiatorEntity;
import mod.azure.doom.entities.tierboss.IconofsinEntity;
import mod.azure.doom.entities.tierheavy.Hellknight2016Entity;
import mod.azure.doom.entities.tierheavy.MancubusEntity;
import mod.azure.doom.entities.tiersuperheavy.DoomHunterEntity;
import mod.azure.doom.entities.tiersuperheavy.MarauderEntity;
import net.minecraft.server.level.ServerLevel;
import net.minecraft.world.effect.MobEffectInstance;
import net.minecraft.world.effect.MobEffects;
import net.minecraft.world.phys.Vec3;
import net.tslat.smartbrainlib.api.core.behaviour.ExtendedBehaviour;
import org.jetbrains.annotations.NotNull;

public abstract class CustomDelayedMeleeBehaviour<E extends DemonEntity>
extends ExtendedBehaviour<E> {
    protected final int delayTime;
    protected long delayFinishedAt = 0L;
    protected Consumer<E> delayedCallback = entity -> {};

    protected CustomDelayedMeleeBehaviour(int delayTicks) {
        this.delayTime = delayTicks;
        this.runFor(entity -> Math.max(delayTicks, 60));
    }

    protected final void start(@NotNull ServerLevel level, @NotNull E entity, long gameTime) {
        if (this.delayTime > 0) {
            this.delayFinishedAt = gameTime + (long)this.delayTime;
            super.m_6735_(level, entity, gameTime);
        } else {
            super.m_6735_(level, entity, gameTime);
            this.doDelayedAction(entity);
        }
        entity.triggerAnim("attackController", "melee");
        if (!(entity instanceof MarauderEntity)) {
            entity.triggerAnim("livingController", "melee");
        }
        if (entity instanceof MarauderEntity) {
            MarauderEntity marauder = (MarauderEntity)((Object)entity);
            marauder.m_7292_(new MobEffectInstance(MobEffects.f_19597_, 40, 100, false, false));
            marauder.triggerAnim("attackController", marauder.m_217043_().m_188503_(3) == 2 ? "hook" : "cut");
        }
        if (entity instanceof MancubusEntity) {
            MancubusEntity mancubusEntity = (MancubusEntity)((Object)entity);
            mancubusEntity.setAttackingState(3);
        }
        if (entity instanceof DoomHunterEntity) {
            DoomHunterEntity doomHunterEntity = (DoomHunterEntity)((Object)entity);
            doomHunterEntity.setAttackingState(3);
        }
        if (entity instanceof GladiatorEntity) {
            GladiatorEntity gladiatorEntity = (GladiatorEntity)entity;
            if (gladiatorEntity.getDeathState() == 0) {
                gladiatorEntity.triggerAnim("attackController", gladiatorEntity.m_217043_().m_188503_(3) == 1 ? "meleetwo" : "meleeone");
            } else {
                gladiatorEntity.triggerAnim("attackController", gladiatorEntity.m_217043_().m_188503_(3) == 1 ? "melee2two" : "melee2one");
            }
            gladiatorEntity.m_7292_(new MobEffectInstance(MobEffects.f_19597_, 20, 100, false, false));
        }
        if (entity instanceof IconofsinEntity) {
            IconofsinEntity iconEntity = (IconofsinEntity)entity;
            if (iconEntity.getDeathState() == 0) {
                iconEntity.triggerAnim("attackController", "phaseonestomp");
            } else {
                iconEntity.triggerAnim("attackController", "phasetwostomp");
            }
        }
        if (!(entity instanceof IconofsinEntity && entity instanceof MancubusEntity && entity instanceof Hellknight2016Entity && entity instanceof DoomHunterEntity)) {
            ((DemonEntity)((Object)entity)).setAttackingState(2);
        }
        if (entity instanceof MarauderEntity) {
            MarauderEntity marauderEntity = (MarauderEntity)((Object)entity);
            marauderEntity.triggerAnim("livingController", "attacking");
        }
        if (entity instanceof Hellknight2016Entity) {
            Hellknight2016Entity hellknight2016 = (Hellknight2016Entity)((Object)entity);
            hellknight2016.triggerAnim("livingController", "attack");
            if (hellknight2016.m_5448_() != null && !hellknight2016.m_9236_().m_5776_()) {
                Vec3 vec3d2 = new Vec3(hellknight2016.m_5448_().m_20185_() - hellknight2016.m_20185_(), 0.0, hellknight2016.m_5448_().m_20189_() - hellknight2016.m_20189_());
                vec3d2 = vec3d2.m_82541_().m_82490_(0.8).m_82549_(hellknight2016.m_20184_().m_82490_(0.4));
                hellknight2016.m_20334_(vec3d2.f_82479_, 0.6f, vec3d2.f_82481_);
            }
        }
    }

    protected final void stop(@NotNull ServerLevel level, @NotNull E entity, long gameTime) {
        super.m_6732_(level, entity, gameTime);
        this.delayFinishedAt = 0L;
        ((DemonEntity)((Object)entity)).setAttackingState(0);
    }

    protected boolean shouldKeepRunning(E entity) {
        return this.delayFinishedAt >= entity.m_9236_().m_46467_();
    }

    protected final void tick(@NotNull ServerLevel level, @NotNull E entity, long gameTime) {
        super.m_6725_(level, entity, gameTime);
        if (this.delayFinishedAt <= gameTime) {
            this.doDelayedAction(entity);
            this.delayedCallback.accept(entity);
        }
    }

    protected void doDelayedAction(E entity) {
    }
}

