/*
 * Decompiled with CFR 0.152.
 */
package mod.azure.doom.entities.task;

import com.mojang.datafixers.util.Pair;
import it.unimi.dsi.fastutil.objects.ObjectArrayList;
import java.util.List;
import java.util.function.ToIntFunction;
import mod.azure.doom.entities.DemonEntity;
import mod.azure.doom.entities.task.CustomDelayedMeleeBehaviour;
import mod.azure.doom.entities.tierambient.CueBallEntity;
import mod.azure.doom.entities.tierboss.GladiatorEntity;
import mod.azure.doom.entities.tierboss.IconofsinEntity;
import mod.azure.doom.entities.tierheavy.Hellknight2016Entity;
import mod.azure.doom.entities.tierheavy.MancubusEntity;
import net.minecraft.core.particles.ParticleOptions;
import net.minecraft.core.particles.ParticleTypes;
import net.minecraft.server.level.ServerLevel;
import net.minecraft.util.Mth;
import net.minecraft.world.InteractionHand;
import net.minecraft.world.effect.MobEffectInstance;
import net.minecraft.world.effect.MobEffects;
import net.minecraft.world.entity.AreaEffectCloud;
import net.minecraft.world.entity.Entity;
import net.minecraft.world.entity.LivingEntity;
import net.minecraft.world.entity.ai.attributes.Attributes;
import net.minecraft.world.entity.ai.behavior.BehaviorUtils;
import net.minecraft.world.entity.ai.memory.MemoryModuleType;
import net.minecraft.world.entity.ai.memory.MemoryStatus;
import net.minecraft.world.entity.ai.targeting.TargetingConditions;
import net.minecraft.world.item.Items;
import net.minecraft.world.level.Level;
import net.minecraft.world.phys.AABB;
import net.tslat.smartbrainlib.util.BrainUtils;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;

public class DemonMeleeAttack<E extends DemonEntity>
extends CustomDelayedMeleeBehaviour<E> {
    private static final List<Pair<MemoryModuleType<?>, MemoryStatus>> MEMORY_REQUIREMENTS = ObjectArrayList.of((Object[])new Pair[]{Pair.of((Object)MemoryModuleType.f_26372_, (Object)MemoryStatus.VALUE_PRESENT), Pair.of((Object)MemoryModuleType.f_26373_, (Object)MemoryStatus.VALUE_ABSENT)});
    protected ToIntFunction<E> attackIntervalSupplier = entity -> 20;
    @Nullable
    protected LivingEntity target = null;

    public DemonMeleeAttack(int delayTicks) {
        super(delayTicks);
    }

    public DemonMeleeAttack<E> attackInterval(ToIntFunction<E> supplier) {
        this.attackIntervalSupplier = supplier;
        return this;
    }

    protected List<Pair<MemoryModuleType<?>, MemoryStatus>> getMemoryRequirements() {
        return MEMORY_REQUIREMENTS;
    }

    protected boolean checkExtraStartConditions(@NotNull ServerLevel level, @NotNull E entity) {
        this.target = BrainUtils.getTargetOfEntity(entity);
        assert (this.target != null);
        return entity.m_21574_().m_148306_((Entity)this.target) && entity.m_217066_(this.target) && !entity.m_203117_();
    }

    protected void start(E entity) {
        entity.m_6674_(InteractionHand.MAIN_HAND);
        assert (this.target != null);
        BehaviorUtils.m_22595_(entity, (LivingEntity)this.target);
    }

    protected void stop(E entity) {
        this.target = null;
        if (entity instanceof Hellknight2016Entity) {
            Hellknight2016Entity hellknight = (Hellknight2016Entity)((Object)entity);
            hellknight.m_7292_(new MobEffectInstance(MobEffects.f_19597_, this.delayTime, 100, false, false));
        }
    }

    @Override
    protected void doDelayedAction(E entity) {
        BrainUtils.setForgettableMemory(entity, (MemoryModuleType)MemoryModuleType.f_26373_, (Object)true, (int)this.attackIntervalSupplier.applyAsInt(entity));
        if (this.target == null) {
            return;
        }
        if (!entity.m_21574_().m_148306_((Entity)this.target) || !entity.m_217066_(this.target)) {
            return;
        }
        BehaviorUtils.m_22595_(entity, (LivingEntity)this.target);
        if (entity instanceof IconofsinEntity) {
            IconofsinEntity iconEntity = (IconofsinEntity)entity;
            iconEntity.m_7327_((Entity)this.target);
            iconEntity.m_9236_().m_255391_(entity, this.target.m_20185_(), this.target.m_20186_(), this.target.m_20189_(), 3.0f, false, Level.ExplosionInteraction.BLOCK);
            this.target.f_19802_ = 0;
        } else if (entity instanceof MancubusEntity) {
            MancubusEntity mancubusEntity = (MancubusEntity)((Object)entity);
            for (int j = 0; j < 5; ++j) {
                float h2 = (float)Mth.m_14136_((double)(this.target.m_20189_() - entity.m_20189_()), (double)(this.target.m_20185_() - entity.m_20185_())) + (float)j * (float)Math.PI * 0.4f;
                mancubusEntity.spawnFlames(entity.m_20185_() + (double)Mth.m_14089_((float)h2) * 1.5, entity.m_20189_() + (double)Mth.m_14031_((float)h2) * 1.5, Math.min(this.target.m_20186_(), entity.m_20186_()), Math.max(this.target.m_20186_(), entity.m_20186_()) + 1.0);
            }
        } else if (entity instanceof CueBallEntity) {
            CueBallEntity cueballEntity = (CueBallEntity)((Object)entity);
            if (cueballEntity.getVariant() != 3) {
                cueballEntity.setFuseSpeed(1);
            } else {
                cueballEntity.m_7327_((Entity)this.target);
            }
        } else if (entity instanceof GladiatorEntity) {
            GladiatorEntity gladiatorEntity = (GladiatorEntity)entity;
            AreaEffectCloud areaeffectcloudentity = new AreaEffectCloud(entity.m_9236_(), entity.m_20185_(), entity.m_20186_(), entity.m_20189_());
            areaeffectcloudentity.m_19724_((ParticleOptions)ParticleTypes.f_123762_);
            areaeffectcloudentity.m_19712_(3.0f);
            areaeffectcloudentity.m_19734_(55);
            areaeffectcloudentity.m_6034_(entity.m_20185_(), entity.m_20186_(), entity.m_20189_());
            gladiatorEntity.m_9236_().m_7967_((Entity)areaeffectcloudentity);
            gladiatorEntity.m_7327_((Entity)this.target);
            gladiatorEntity.tryAttack1((Entity)this.target);
        } else if (entity instanceof Hellknight2016Entity) {
            Hellknight2016Entity marauderEntity = (Hellknight2016Entity)((Object)entity);
            AABB aabb = marauderEntity.m_20191_().m_82400_(16.0);
            TargetingConditions checkBlocking = TargetingConditions.m_148352_().m_26883_(3.0).m_26888_(target2 -> !target2.m_21211_().m_150930_(Items.f_42740_));
            marauderEntity.m_9236_().m_45971_(LivingEntity.class, checkBlocking, (LivingEntity)marauderEntity, aabb).forEach(target1 -> target1.m_6469_(marauderEntity.m_269291_().m_269333_((LivingEntity)marauderEntity), (float)marauderEntity.m_21133_(Attributes.f_22281_)));
        } else {
            entity.m_7327_((Entity)this.target);
        }
    }
}

