/*
 * Decompiled with CFR 0.152.
 */
package mod.azure.doom.items.enums;

import java.util.function.Supplier;
import mod.azure.doom.MCDoom;
import mod.azure.doom.platform.Services;
import net.minecraft.sounds.SoundEvent;
import net.minecraft.sounds.SoundEvents;
import net.minecraft.util.LazyLoadedValue;
import net.minecraft.world.item.ArmorItem;
import net.minecraft.world.item.ArmorMaterial;
import net.minecraft.world.item.crafting.Ingredient;
import net.minecraft.world.level.ItemLike;
import org.jetbrains.annotations.NotNull;

public enum DAMat implements ArmorMaterial
{
    DOOM_ARMOR("doomweapon:doom_armor", 500, new int[]{MCDoom.config.doom_armor_boots_stat, MCDoom.config.doom_armor_leggings_stat, MCDoom.config.doom_armor_chestplate_stat, MCDoom.config.doom_armor_head_stat}, 40, SoundEvents.f_11675_, MCDoom.config.doom_armor_toughness, MCDoom.config.doom_armor_knockbackResistance, () -> Ingredient.m_43929_((ItemLike[])new ItemLike[]{Services.ITEMS_HELPER.getArgentEngery()}));

    private static final int[] BASE_DURABILITY;
    private final String name;
    private final int durabilityMultiplier;
    private final int[] protectionAmounts;
    private final int enchantability;
    private final SoundEvent equipSound;
    private final float toughness;
    private final float knockbackResistance;
    private final LazyLoadedValue<Ingredient> repairIngredientSupplier;

    private DAMat(String name, int durabilityMultiplier, int[] protectionAmounts, int enchantability, SoundEvent equipSound, float toughness, float knockbackResistance, Supplier<Ingredient> supplier) {
        this.name = name;
        this.durabilityMultiplier = durabilityMultiplier;
        this.protectionAmounts = protectionAmounts;
        this.enchantability = enchantability;
        this.equipSound = equipSound;
        this.toughness = toughness;
        this.knockbackResistance = knockbackResistance;
        this.repairIngredientSupplier = new LazyLoadedValue(supplier);
    }

    @NotNull
    public SoundEvent m_7344_() {
        return this.equipSound;
    }

    @NotNull
    public Ingredient m_6230_() {
        return (Ingredient)this.repairIngredientSupplier.m_13971_();
    }

    @NotNull
    public String m_6082_() {
        return this.name;
    }

    public float m_6651_() {
        return this.toughness;
    }

    public float m_6649_() {
        return this.knockbackResistance;
    }

    public int m_266425_(ArmorItem.Type slot) {
        return BASE_DURABILITY[slot.m_266308_().m_20749_()] * this.durabilityMultiplier;
    }

    public int m_7366_(ArmorItem.Type slot) {
        return this.protectionAmounts[slot.m_266308_().m_20749_()];
    }

    public int m_6646_() {
        return this.enchantability;
    }

    static {
        BASE_DURABILITY = new int[]{MCDoom.config.doom_armor_boots_stat, MCDoom.config.doom_armor_leggings_stat, MCDoom.config.doom_armor_chestplate_stat, MCDoom.config.doom_armor_head_stat};
    }
}

