/*
 * Decompiled with CFR 0.152.
 */
package mod.azure.doom.network.packets;

import java.util.function.Supplier;
import mod.azure.doom.items.weapons.BaseSwordItem;
import net.minecraft.network.FriendlyByteBuf;
import net.minecraft.network.PacketListener;
import net.minecraft.server.level.ServerPlayer;
import net.minecraft.server.network.ServerGamePacketListenerImpl;
import net.minecraft.world.InteractionHand;
import net.minecraft.world.entity.player.Player;
import net.minecraftforge.network.NetworkEvent;

public class ReloadingMeleePacket {
    public int slot;

    public ReloadingMeleePacket(int slot) {
        this.slot = slot;
    }

    public ReloadingMeleePacket(FriendlyByteBuf packetBuffer) {
        this.slot = packetBuffer.readInt();
    }

    public static void handle(ReloadingMeleePacket packet, Supplier<NetworkEvent.Context> ctx) {
        ctx.get().enqueueWork(() -> {
            NetworkEvent.Context context = (NetworkEvent.Context)ctx.get();
            PacketListener handler = context.getNetworkManager().m_129538_();
            if (handler instanceof ServerGamePacketListenerImpl) {
                ServerGamePacketListenerImpl serverGamePacketListener = (ServerGamePacketListenerImpl)handler;
                ServerPlayer playerEntity = serverGamePacketListener.f_9743_;
                BaseSwordItem.reload((Player)playerEntity, InteractionHand.MAIN_HAND);
            }
        });
        ctx.get().setPacketHandled(true);
    }

    public void encode(FriendlyByteBuf packetBuffer) {
        packetBuffer.writeInt(this.slot);
    }
}

