/*
 * Decompiled with CFR 0.152.
 */
package shetiphian.enderchests.common.tileentity;

import com.google.common.base.Strings;
import java.util.ArrayList;
import java.util.List;
import javax.annotation.Nonnull;
import javax.annotation.Nullable;
import net.minecraft.core.BlockPos;
import net.minecraft.core.Direction;
import net.minecraft.nbt.CompoundTag;
import net.minecraft.nbt.ListTag;
import net.minecraft.nbt.StringTag;
import net.minecraft.nbt.Tag;
import net.minecraft.sounds.SoundEvents;
import net.minecraft.sounds.SoundSource;
import net.minecraft.util.Mth;
import net.minecraft.world.Container;
import net.minecraft.world.entity.Entity;
import net.minecraft.world.entity.player.Player;
import net.minecraft.world.item.DyeColor;
import net.minecraft.world.item.ItemStack;
import net.minecraft.world.level.Level;
import net.minecraft.world.level.block.entity.BlockEntity;
import net.minecraft.world.level.block.entity.BlockEntityType;
import net.minecraft.world.level.block.entity.LidBlockEntity;
import net.minecraft.world.level.block.state.BlockState;
import net.minecraft.world.level.block.state.properties.Property;
import net.minecraft.world.phys.AABB;
import net.minecraft.world.phys.shapes.VoxelShape;
import net.minecraftforge.api.distmarker.Dist;
import net.minecraftforge.api.distmarker.OnlyIn;
import net.minecraftforge.common.capabilities.Capability;
import net.minecraftforge.common.capabilities.ForgeCapabilities;
import net.minecraftforge.common.util.LazyOptional;
import net.minecraftforge.items.IItemHandler;
import net.minecraftforge.items.wrapper.InvWrapper;
import net.minecraftforge.registries.ForgeRegistries;
import shetiphian.core.common.Function;
import shetiphian.core.common.NameHelper;
import shetiphian.core.common.inventory.IContainerCallback;
import shetiphian.core.common.inventory.InventoryInternal;
import shetiphian.core.common.rgb16.IRGB16_Tile;
import shetiphian.core.common.rgb16.RGB16;
import shetiphian.core.common.rgb16.RGB16Helper;
import shetiphian.core.common.tileentity.TileEntityBase;
import shetiphian.enderchests.Configuration;
import shetiphian.enderchests.Roster;
import shetiphian.enderchests.common.block.BlockEnderChest;
import shetiphian.enderchests.common.inventory.ContainerEnderChest;
import shetiphian.enderchests.common.misc.ChestHelper;
import shetiphian.enderchests.common.misc.ChestInfoHelper;
import shetiphian.enderchests.common.misc.LocationManager;

public class TileEntityEnderChest
extends TileEntityBase
implements LidBlockEntity,
IRGB16_Tile,
IContainerCallback {
    private String code = "000";
    private String ownerID = null;
    private String owner = "all";
    private ItemStack personalItem;
    private float lidAngle;
    private float prevLidAngle;
    private int numPlayersUsing;
    private int ticksSinceSync;
    private final List<String> usedUpgrades = new ArrayList<String>();
    private LazyOptional<IItemHandler> cachedCapability = LazyOptional.empty();

    public TileEntityEnderChest(BlockPos pos, BlockState state) {
        super((BlockEntityType)Roster.Tiles.ENDERCHEST.get(), pos, state);
    }

    public void buildNBT(CompoundTag nbtTag) {
        nbtTag.m_128359_("code", this.getCode());
        nbtTag.m_128359_("owner", this.owner);
        if (!Strings.isNullOrEmpty((String)this.ownerID)) {
            nbtTag.m_128359_("owner.id", this.ownerID);
        }
        nbtTag.m_128359_("owner_id", this.getOwnerID());
        if (this.personalItem != null) {
            CompoundTag compound = new CompoundTag();
            this.personalItem.m_41739_(compound);
            nbtTag.m_128365_("upgrade.access", (Tag)compound);
            nbtTag.m_128359_("personal", ForgeRegistries.ITEMS.getKey((Object)this.personalItem.m_41720_()).toString());
        }
        if (!this.usedUpgrades.isEmpty()) {
            ListTag listNBT = new ListTag();
            for (String upgrade : this.usedUpgrades) {
                listNBT.add((Object)StringTag.m_129297_((String)upgrade));
            }
            nbtTag.m_128365_("used_upgrades", (Tag)listNBT);
        }
    }

    public void processNBT(CompoundTag nbtTag) {
        this.setCode(nbtTag.m_128461_("code"));
        this.owner = nbtTag.m_128461_("owner");
        if (nbtTag.m_128441_("owner.id")) {
            this.ownerID = nbtTag.m_128461_("owner.id");
        }
        if (nbtTag.m_128441_("upgrade.access")) {
            ItemStack stack = ItemStack.m_41712_((CompoundTag)nbtTag.m_128469_("upgrade.access"));
            if (!stack.m_41619_() && stack.m_41613_() != 1) {
                stack.m_41764_(1);
            }
            this.personalItem = stack;
        }
        if (nbtTag.m_128441_("used_upgrades")) {
            this.usedUpgrades.clear();
            ListTag listNBT = nbtTag.m_128437_("used_upgrades", 8);
            listNBT.listIterator().forEachRemaining(entry -> this.usedUpgrades.add(entry.m_7916_()));
        }
    }

    public void processNBT_SaveOnly(CompoundTag nbtTag) {
        super.processNBT_SaveOnly(nbtTag);
        if (!Strings.isNullOrEmpty((String)this.ownerID)) {
            this.owner = NameHelper.getDisplayNameFor((String)this.ownerID);
        }
    }

    public boolean applyItem(ItemStack stack) {
        String key = ForgeRegistries.ITEMS.getKey((Object)stack.m_41720_()).toString();
        if (this.usedUpgrades.contains(key)) {
            return false;
        }
        this.usedUpgrades.add(key);
        return true;
    }

    public AABB getRenderBoundingBox() {
        return new AABB(this.f_58858_).m_82377_(1.0, 1.0, 1.0);
    }

    public float m_6683_(float partialTick) {
        return Mth.m_14179_((float)partialTick, (float)this.prevLidAngle, (float)this.lidAngle);
    }

    public static void tick(Level world, BlockPos pos, BlockState state, TileEntityEnderChest tile) {
        int x = pos.m_123341_();
        int y = pos.m_123342_();
        int z = pos.m_123343_();
        ++tile.ticksSinceSync;
        if (!world.m_5776_() && tile.numPlayersUsing != 0 && (tile.ticksSinceSync + x + y + z) % 200 == 0) {
            tile.numPlayersUsing = 0;
            for (Player player : world.m_45976_(Player.class, new AABB((double)((float)x - 5.0f), (double)((float)y - 5.0f), (double)((float)z - 5.0f), (double)((float)(x + 1) + 5.0f), (double)((float)(y + 1) + 5.0f), (double)((float)(z + 1) + 5.0f)))) {
                if (!(player.f_36096_ instanceof ContainerEnderChest) || !((ContainerEnderChest)player.f_36096_).isParentTile(tile)) continue;
                ++tile.numPlayersUsing;
            }
        }
        tile.prevLidAngle = tile.lidAngle;
        if (tile.numPlayersUsing > 0 && tile.lidAngle == 0.0f) {
            world.m_6263_(null, (double)x + 0.5, (double)y + 0.5, (double)z + 0.5, SoundEvents.f_11749_, SoundSource.BLOCKS, 0.5f, world.f_46441_.m_188501_() * 0.1f + 0.9f);
        }
        if (tile.numPlayersUsing == 0 && tile.lidAngle > 0.0f || tile.numPlayersUsing > 0 && tile.lidAngle < 1.0f) {
            float oldAngle = tile.lidAngle;
            tile.lidAngle = tile.numPlayersUsing > 0 ? (tile.lidAngle += 0.075f) : (tile.lidAngle -= 0.075f);
            if (tile.lidAngle > 1.0f) {
                tile.lidAngle = 1.0f;
            }
            if (tile.lidAngle < 0.5f && oldAngle >= 0.5f) {
                world.m_6263_(null, (double)x + 0.5, (double)y + 0.5, (double)z + 0.5, SoundEvents.f_11747_, SoundSource.BLOCKS, 0.5f, world.f_46441_.m_188501_() * 0.1f + 0.9f);
            }
            if (tile.lidAngle < 0.0f) {
                tile.lidAngle = 0.0f;
            }
        }
    }

    @OnlyIn(value=Dist.CLIENT)
    public float getLidAngle(float partialTicks) {
        return Mth.m_14179_((float)partialTicks, (float)this.prevLidAngle, (float)this.lidAngle);
    }

    public int getLidOffsetIndex() {
        return Math.round(this.lidAngle * 100.0f) / 10;
    }

    public boolean m_7531_(int id, int value) {
        if (id == 1) {
            this.numPlayersUsing = value;
            return true;
        }
        return super.m_7531_(id, value);
    }

    public boolean isOpen() {
        return this.numPlayersUsing > 0;
    }

    public void m_155250_(BlockState state) {
        super.m_155250_(state);
        this.invalidateCaps();
    }

    public void invalidateCaps() {
        super.invalidateCaps();
        this.cachedCapability.invalidate();
    }

    public <T> LazyOptional<T> getCapability(@Nonnull Capability<T> capability, @Nullable Direction side) {
        if (capability == ForgeCapabilities.ITEM_HANDLER && this.canBeAutomated()) {
            if (!this.cachedCapability.isPresent()) {
                this.cachedCapability = LazyOptional.of(() -> new InvWrapper((Container)this.getChest()));
            }
            return this.cachedCapability.cast();
        }
        return super.getCapability(capability, side);
    }

    private boolean canBeAutomated() {
        return this.isPublic() ? (Boolean)Configuration.ACCESS_SETTINGS.enableAutomationPublic.get() : (this.isTeam() ? (Boolean)Configuration.ACCESS_SETTINGS.enableAutomationTeam.get() : (Boolean)Configuration.ACCESS_SETTINGS.enableAutomationPersonal.get());
    }

    public InventoryInternal getChest() {
        return ChestHelper.getChest(this.f_58857_, this.getOwnerID(), this.getCode());
    }

    public boolean canInteractWith(BlockEntity owner, Container inventory, Player player, boolean original) {
        return this.f_58857_ != null && this.f_58857_.m_7702_(this.f_58858_) == this && player.m_20275_((double)this.f_58858_.m_123341_() + 0.5, (double)this.f_58858_.m_123342_() + 0.5, (double)this.f_58858_.m_123343_() + 0.5) <= 64.0;
    }

    public void onContainerOpen(BlockEntity owner, Container inventory, Player player) {
        if (this.numPlayersUsing < 0) {
            this.numPlayersUsing = 0;
        }
        if (!player.m_5833_()) {
            ++this.numPlayersUsing;
            if (this.f_58857_ != null) {
                this.f_58857_.m_7696_(this.f_58858_, this.m_58900_().m_60734_(), 1, this.numPlayersUsing);
                this.f_58857_.m_46672_(this.f_58858_, this.m_58900_().m_60734_());
            }
        }
    }

    public void onContainerClosed(BlockEntity owner, Container inventory, Player player) {
        if (!player.m_5833_()) {
            --this.numPlayersUsing;
            if (this.f_58857_ != null) {
                this.f_58857_.m_7696_(this.f_58858_, this.m_58900_().m_60734_(), 1, this.numPlayersUsing);
                this.f_58857_.m_46672_(this.f_58858_, this.m_58900_().m_60734_());
            }
        }
    }

    public boolean canEdit(Player player) {
        return this.canEdit(player, true);
    }

    public boolean canEdit(Player player, boolean notify) {
        boolean canEdit = true;
        String msg = "";
        if (!player.m_150110_().f_35937_) {
            if (this.isTeam()) {
                canEdit = (Boolean)Configuration.ACCESS_SETTINGS.lockTeamEdit.get() == false || this.ownerID.equalsIgnoreCase(this.getPlayerTeam(player));
                msg = "team.denied";
            } else if (!this.isPublic()) {
                canEdit = (Boolean)Configuration.ACCESS_SETTINGS.lockPersonalEdit.get() == false || !Strings.isNullOrEmpty((String)this.ownerID) && this.ownerID.equals(player.m_20148_().toString());
                msg = "private.denied";
            }
        }
        if (notify && !canEdit && !Strings.isNullOrEmpty((String)msg)) {
            ChestInfoHelper.sendError(player, "enderchests.chest." + msg);
        }
        return canEdit;
    }

    public boolean canUse(Player player) {
        boolean canUse = true;
        String msg = "";
        if (!player.m_150110_().f_35937_) {
            if (this.isTeam()) {
                canUse = (Boolean)Configuration.ACCESS_SETTINGS.lockTeamUse.get() == false || this.ownerID.equalsIgnoreCase(this.getPlayerTeam(player));
                msg = "team.denied";
            } else if (this.isPublic()) {
                canUse = (Boolean)Configuration.ACCESS_SETTINGS.allowPublicChests.get();
                msg = "public.disabled";
            } else {
                canUse = (Boolean)Configuration.ACCESS_SETTINGS.lockPersonalUse.get() == false || !Strings.isNullOrEmpty((String)this.ownerID) && this.ownerID.equals(player.m_20148_().toString());
                msg = "private.denied";
            }
        }
        if (!canUse && !Strings.isNullOrEmpty((String)msg)) {
            ChestInfoHelper.sendError(player, "enderchests.chest." + msg);
        }
        return canUse;
    }

    public boolean canLink(Player player) {
        boolean canLink = true;
        String msg = "";
        if (!player.m_150110_().f_35937_) {
            if (this.isTeam()) {
                if (((Boolean)Configuration.ACCESS_SETTINGS.allowTeamBags.get()).booleanValue()) {
                    canLink = (Boolean)Configuration.ACCESS_SETTINGS.lockTeamLink.get() == false || this.ownerID.equalsIgnoreCase(this.getPlayerTeam(player));
                    msg = "chest.team.denied";
                } else {
                    canLink = false;
                    msg = "bag.team.disabled";
                }
            } else if (!this.isPublic()) {
                if (((Boolean)Configuration.ACCESS_SETTINGS.allowPersonalBags.get()).booleanValue()) {
                    canLink = (Boolean)Configuration.ACCESS_SETTINGS.lockPersonalLink.get() == false || !Strings.isNullOrEmpty((String)this.ownerID) && this.ownerID.equals(player.m_20148_().toString());
                    msg = "chest.private.denied";
                } else {
                    canLink = false;
                    msg = "bag.private.disabled";
                }
            }
        }
        if (!canLink && !Strings.isNullOrEmpty((String)msg)) {
            ChestInfoHelper.sendError(player, "enderchests." + msg);
        }
        return canLink;
    }

    private String getPlayerTeam(Player player) {
        String team = Function.getPlayerTeamID((Player)player);
        return "#" + (Strings.isNullOrEmpty((String)team) ? "none" : team);
    }

    public String getOwner() {
        return !Strings.isNullOrEmpty((String)this.owner) ? this.owner : "all";
    }

    public String getOwnerID() {
        if (this.getOwner().equalsIgnoreCase("all")) {
            return "all";
        }
        if (!Strings.isNullOrEmpty((String)this.ownerID)) {
            return this.ownerID;
        }
        return this.getOwner();
    }

    public String getOwnerName() {
        return ChestInfoHelper.getDisplayNameFromOwnerID(this.ownerID);
    }

    public void setOwner(Player player, ItemStack stack) {
        this.clearMyLocation();
        this.personalItem = stack;
        this.owner = player.m_5446_().getString();
        this.ownerID = player.m_20148_().toString();
        this.setMyLocation();
    }

    public void setOwner(String ownerName, String ownerID, ItemStack stack) {
        this.clearMyLocation();
        if (ownerID != null) {
            this.personalItem = stack;
            this.owner = ownerName;
            this.ownerID = ownerID;
        }
        this.setMyLocation();
    }

    public ItemStack getPersonalItem() {
        if (this.personalItem != null && !this.personalItem.m_41619_()) {
            if (this.personalItem.m_41613_() != 1) {
                this.personalItem.m_41764_(1);
            }
            return this.personalItem;
        }
        return ItemStack.f_41583_;
    }

    public boolean isPublic() {
        return this.getOwner().equalsIgnoreCase("all");
    }

    public boolean isTeam() {
        return this.ownerID != null && this.ownerID.startsWith("#");
    }

    public String getCode() {
        while (this.code.length() < 3) {
            this.code = "0" + this.code;
        }
        return this.code.toUpperCase();
    }

    public void setCode(String code) {
        this.clearMyLocation();
        while (((String)code).length() < 3) {
            code = "0" + (String)code;
        }
        this.code = ((String)code).toUpperCase();
        this.setMyLocation();
        this.invalidateCaps();
    }

    public boolean hasError() {
        return !this.isPublic() && Strings.isNullOrEmpty((String)this.ownerID);
    }

    public RGB16 getRGB16(Player player) {
        if (player == null) {
            return null;
        }
        int ring = this.getRingHit(player);
        if (ring < 0 || ring > 2) {
            return null;
        }
        int value = Integer.parseInt("" + this.getCode().charAt(ring), 16);
        return new RGB16(DyeColor.m_41053_((int)value).m_41065_());
    }

    public boolean setRGB16(short rgbIndex, Player player) {
        return this.doColorRing(DyeColor.m_41053_((int)RGB16Helper.getSimpleColor((short)rgbIndex)), player);
    }

    public boolean doColorRing(DyeColor color, Player player) {
        if (player == null || !this.canEdit(player) || !((Boolean)Configuration.GENERAL.enableInWorldRecoloring.get()).booleanValue()) {
            return false;
        }
        int ring = this.getRingHit(player);
        if (ring < 0 || ring > 2) {
            return false;
        }
        char charColor = Integer.toHexString(color.m_41060_()).toUpperCase().charAt(0);
        char[] charCode = this.getCode().toCharArray();
        if (charCode[ring] != charColor) {
            charCode[ring] = charColor;
            this.setCode("" + charCode[0] + charCode[1] + charCode[2]);
            Function.syncTile((BlockEntity)this);
            return true;
        }
        return false;
    }

    private int getRingHit(Player player) {
        VoxelShape[] shapes = BlockEnderChest.SHAPES.get(this.m_58900_().m_61143_((Property)BlockEnderChest.FACING));
        return Function.getSubShapeHit((Entity)player, (BlockPos)this.f_58858_, (VoxelShape[])shapes) - 1;
    }

    private void setMyLocation() {
        if (this.f_58857_ != null && !this.f_58857_.m_5776_()) {
            LocationManager.set(this.getOwnerID(), this.getCode(), this);
        }
    }

    private void clearMyLocation() {
        if (this.f_58857_ != null && !this.f_58857_.m_5776_()) {
            LocationManager.clear(this.getOwnerID(), this.getCode(), this);
        }
    }

    public void onLoad() {
        super.onLoad();
        this.setMyLocation();
    }

    public void onChunkUnloaded() {
        super.onChunkUnloaded();
        this.clearMyLocation();
    }
}

