/*
 * Decompiled with CFR 0.152.
 */
package software.bernie.geckolib.network.packet;

import java.util.function.Supplier;
import net.minecraft.network.FriendlyByteBuf;
import net.minecraft.world.entity.Entity;
import net.minecraftforge.network.NetworkEvent;
import software.bernie.geckolib.animatable.stateless.StatelessAnimatable;
import software.bernie.geckolib.core.animatable.GeoAnimatable;
import software.bernie.geckolib.core.animation.RawAnimation;
import software.bernie.geckolib.util.ClientUtils;
import software.bernie.geckolib.util.NetworkUtil;
import software.bernie.geckolib.util.RenderUtils;

public class StatelessEntityPlayAnimPacket {
    private final int entityId;
    private final boolean isReplacedEntity;
    private final RawAnimation animation;

    public StatelessEntityPlayAnimPacket(int entityId, RawAnimation animation) {
        this(entityId, false, animation);
    }

    public StatelessEntityPlayAnimPacket(int entityId, boolean isReplacedEntity, RawAnimation animation) {
        this.entityId = entityId;
        this.isReplacedEntity = isReplacedEntity;
        this.animation = animation;
    }

    public void encode(FriendlyByteBuf buffer) {
        buffer.m_130130_(this.entityId);
        buffer.writeBoolean(this.isReplacedEntity);
        NetworkUtil.writeRawAnimationToBuffer(this.animation, buffer);
    }

    public static StatelessEntityPlayAnimPacket decode(FriendlyByteBuf buffer) {
        int entityId = buffer.m_130242_();
        boolean isReplacedEntity = buffer.readBoolean();
        RawAnimation animation = NetworkUtil.readRawAnimationFromBuffer(buffer);
        return new StatelessEntityPlayAnimPacket(entityId, isReplacedEntity, animation);
    }

    public void receivePacket(Supplier<NetworkEvent.Context> context) {
        NetworkEvent.Context handler = context.get();
        handler.enqueueWork(() -> {
            GeoAnimatable entityAnimatable;
            GeoAnimatable animatable;
            Entity entity = ClientUtils.getLevel().m_6815_(this.entityId);
            if (entity == null) {
                return;
            }
            GeoAnimatable geoAnimatable = this.isReplacedEntity ? RenderUtils.getReplacedAnimatable(entity.m_6095_()) : (animatable = entity instanceof GeoAnimatable ? (entityAnimatable = (GeoAnimatable)entity) : null);
            if (animatable instanceof StatelessAnimatable) {
                StatelessAnimatable statelessAnimatable = (StatelessAnimatable)((Object)animatable);
                statelessAnimatable.handleClientAnimationPlay(animatable, this.entityId, this.animation);
            }
        });
    }
}

