/*
 * Decompiled with CFR 0.152.
 */
package software.bernie.geckolib.network.packet;

import java.util.function.Supplier;
import javax.annotation.Nullable;
import net.minecraft.core.BlockPos;
import net.minecraft.network.FriendlyByteBuf;
import net.minecraft.world.level.block.entity.BlockEntity;
import net.minecraftforge.network.NetworkEvent;
import software.bernie.geckolib.animatable.GeoBlockEntity;
import software.bernie.geckolib.util.ClientUtils;

public class StopTriggeredBlockEntityAnimPacket<D> {
    private final BlockPos pos;
    private final String controllerName;
    private final String animName;

    public StopTriggeredBlockEntityAnimPacket(BlockPos pos, @Nullable String controllerName, @Nullable String animName) {
        this.pos = pos;
        this.controllerName = controllerName == null ? "" : controllerName;
        this.animName = animName == null ? "" : animName;
    }

    public void encode(FriendlyByteBuf buffer) {
        buffer.m_130064_(this.pos);
        buffer.m_130070_(this.controllerName);
        buffer.m_130070_(this.animName);
    }

    public static <D> StopTriggeredBlockEntityAnimPacket<D> decode(FriendlyByteBuf buffer) {
        return new StopTriggeredBlockEntityAnimPacket<D>(buffer.m_130135_(), buffer.m_130277_(), buffer.m_130277_());
    }

    public void receivePacket(Supplier<NetworkEvent.Context> context) {
        NetworkEvent.Context handler = context.get();
        handler.enqueueWork(() -> {
            BlockEntity blockEntity = ClientUtils.getLevel().m_7702_(this.pos);
            if (blockEntity instanceof GeoBlockEntity) {
                GeoBlockEntity getBlockEntity = (GeoBlockEntity)blockEntity;
                getBlockEntity.stopTriggeredAnimation(this.controllerName.isEmpty() ? null : this.controllerName, this.animName.isEmpty() ? null : this.animName);
            }
        });
        handler.setPacketHandled(true);
    }
}

