/*
 * Decompiled with CFR 0.152.
 */
package guideme.internal.shaded.lucene.document;

import guideme.internal.shaded.lucene.document.ShapeField;
import guideme.internal.shaded.lucene.document.SpatialQuery;
import guideme.internal.shaded.lucene.geo.Component2D;
import guideme.internal.shaded.lucene.geo.GeoEncodingUtils;
import guideme.internal.shaded.lucene.geo.Geometry;
import guideme.internal.shaded.lucene.geo.LatLonGeometry;
import guideme.internal.shaded.lucene.geo.Rectangle;
import guideme.internal.shaded.lucene.index.PointValues;
import guideme.internal.shaded.lucene.util.ArrayUtil;
import guideme.internal.shaded.lucene.util.NumericUtils;
import java.util.function.Function;
import java.util.function.Predicate;

final class LatLonShapeBoundingBoxQuery
extends SpatialQuery {
    private final Rectangle rectangle;

    LatLonShapeBoundingBoxQuery(String field, ShapeField.QueryRelation queryRelation, Rectangle rectangle) {
        super(field, queryRelation, rectangle);
        this.rectangle = rectangle;
    }

    @Override
    protected Component2D createComponent2D(Geometry ... geometries) {
        return LatLonGeometry.create((Rectangle)geometries[0]);
    }

    @Override
    protected SpatialQuery.SpatialVisitor getSpatialVisitor() {
        final EncodedLatLonRectangle encodedRectangle = new EncodedLatLonRectangle(this.rectangle.minLat, this.rectangle.maxLat, this.rectangle.minLon, this.rectangle.maxLon);
        return new SpatialQuery.SpatialVisitor(){

            @Override
            protected PointValues.Relation relate(byte[] minTriangle, byte[] maxTriangle) {
                if (LatLonShapeBoundingBoxQuery.this.queryRelation == ShapeField.QueryRelation.INTERSECTS || LatLonShapeBoundingBoxQuery.this.queryRelation == ShapeField.QueryRelation.DISJOINT) {
                    return encodedRectangle.intersectRangeBBox(4, 0, minTriangle, 12, 8, maxTriangle);
                }
                return encodedRectangle.relateRangeBBox(4, 0, minTriangle, 12, 8, maxTriangle);
            }

            @Override
            protected Predicate<byte[]> intersects() {
                ShapeField.DecodedTriangle scratchTriangle = new ShapeField.DecodedTriangle();
                return triangle -> {
                    ShapeField.decodeTriangle(triangle, scratchTriangle);
                    switch (scratchTriangle.type) {
                        case POINT: {
                            return encodedRectangle.contains(scratchTriangle.aX, scratchTriangle.aY);
                        }
                        case LINE: {
                            int aY = scratchTriangle.aY;
                            int aX = scratchTriangle.aX;
                            int bY = scratchTriangle.bY;
                            int bX = scratchTriangle.bX;
                            return encodedRectangle.intersectsLine(aX, aY, bX, bY);
                        }
                        case TRIANGLE: {
                            int aY = scratchTriangle.aY;
                            int aX = scratchTriangle.aX;
                            int bY = scratchTriangle.bY;
                            int bX = scratchTriangle.bX;
                            int cY = scratchTriangle.cY;
                            int cX = scratchTriangle.cX;
                            return encodedRectangle.intersectsTriangle(aX, aY, bX, bY, cX, cY);
                        }
                    }
                    throw new IllegalArgumentException("Unsupported triangle type :[" + scratchTriangle.type + "]");
                };
            }

            @Override
            protected Predicate<byte[]> within() {
                ShapeField.DecodedTriangle scratchTriangle = new ShapeField.DecodedTriangle();
                return triangle -> {
                    ShapeField.decodeTriangle(triangle, scratchTriangle);
                    switch (scratchTriangle.type) {
                        case POINT: {
                            return encodedRectangle.contains(scratchTriangle.aX, scratchTriangle.aY);
                        }
                        case LINE: {
                            int aY = scratchTriangle.aY;
                            int aX = scratchTriangle.aX;
                            int bY = scratchTriangle.bY;
                            int bX = scratchTriangle.bX;
                            return encodedRectangle.containsLine(aX, aY, bX, bY);
                        }
                        case TRIANGLE: {
                            int aY = scratchTriangle.aY;
                            int aX = scratchTriangle.aX;
                            int bY = scratchTriangle.bY;
                            int bX = scratchTriangle.bX;
                            int cY = scratchTriangle.cY;
                            int cX = scratchTriangle.cX;
                            return encodedRectangle.containsTriangle(aX, aY, bX, bY, cX, cY);
                        }
                    }
                    throw new IllegalArgumentException("Unsupported triangle type :[" + scratchTriangle.type + "]");
                };
            }

            @Override
            protected Function<byte[], Component2D.WithinRelation> contains() {
                if (encodedRectangle.crossesDateline()) {
                    throw new IllegalArgumentException("withinTriangle is not supported for rectangles crossing the date line");
                }
                ShapeField.DecodedTriangle scratchTriangle = new ShapeField.DecodedTriangle();
                return triangle -> {
                    ShapeField.decodeTriangle(triangle, scratchTriangle);
                    switch (scratchTriangle.type) {
                        case POINT: {
                            return encodedRectangle.contains(scratchTriangle.aX, scratchTriangle.aY) ? Component2D.WithinRelation.NOTWITHIN : Component2D.WithinRelation.DISJOINT;
                        }
                        case LINE: {
                            return encodedRectangle.withinLine(scratchTriangle.aX, scratchTriangle.aY, scratchTriangle.ab, scratchTriangle.bX, scratchTriangle.bY);
                        }
                        case TRIANGLE: {
                            return encodedRectangle.withinTriangle(scratchTriangle.aX, scratchTriangle.aY, scratchTriangle.ab, scratchTriangle.bX, scratchTriangle.bY, scratchTriangle.bc, scratchTriangle.cX, scratchTriangle.cY, scratchTriangle.ca);
                        }
                    }
                    throw new IllegalArgumentException("Unsupported triangle type :[" + scratchTriangle.type + "]");
                };
            }
        };
    }

    @Override
    protected boolean equalsTo(Object o) {
        return super.equalsTo(o) && this.rectangle.equals(((LatLonShapeBoundingBoxQuery)o).rectangle);
    }

    @Override
    public int hashCode() {
        int hash = super.hashCode();
        hash = 31 * hash + this.rectangle.hashCode();
        return hash;
    }

    @Override
    public String toString(String field) {
        StringBuilder sb = new StringBuilder();
        sb.append(this.getClass().getSimpleName());
        sb.append(':');
        if (!this.field.equals(field)) {
            sb.append(" field=");
            sb.append(this.field);
            sb.append(':');
        }
        sb.append(this.rectangle.toString());
        return sb.toString();
    }

    private static class EncodedLatLonRectangle
    extends SpatialQuery.EncodedRectangle {
        protected final byte[] bbox = new byte[16];
        private final byte[] west;

        EncodedLatLonRectangle(double minLat, double maxLat, double minLon, double maxLon) {
            super(GeoEncodingUtils.encodeLongitudeCeil(EncodedLatLonRectangle.validateMinLon(minLon, maxLon)), GeoEncodingUtils.encodeLongitude(maxLon), GeoEncodingUtils.encodeLatitudeCeil(minLat), GeoEncodingUtils.encodeLatitude(maxLat), EncodedLatLonRectangle.validateMinLon(minLon, maxLon) > maxLon);
            if (this.wrapsCoordinateSystem) {
                this.west = new byte[16];
                EncodedLatLonRectangle.encode(GeoEncodingUtils.MIN_LON_ENCODED, this.maxX, this.minY, this.maxY, this.west);
                EncodedLatLonRectangle.encode(this.minX, GeoEncodingUtils.MAX_LON_ENCODED, this.minY, this.maxY, this.bbox);
            } else {
                this.west = null;
                EncodedLatLonRectangle.encode(this.minX, this.maxX, this.minY, this.maxY, this.bbox);
            }
        }

        private static double validateMinLon(double minLon, double maxLon) {
            if (minLon == 180.0 && minLon > maxLon) {
                return -180.0;
            }
            return minLon;
        }

        private static void encode(int minX, int maxX, int minY, int maxY, byte[] b) {
            if (b == null) {
                b = new byte[16];
            }
            NumericUtils.intToSortableBytes(minY, b, 0);
            NumericUtils.intToSortableBytes(minX, b, 4);
            NumericUtils.intToSortableBytes(maxY, b, 8);
            NumericUtils.intToSortableBytes(maxX, b, 12);
        }

        private boolean crossesDateline() {
            return this.wrapsCoordinateSystem;
        }

        PointValues.Relation relateRangeBBox(int minXOffset, int minYOffset, byte[] minTriangle, int maxXOffset, int maxYOffset, byte[] maxTriangle) {
            PointValues.Relation eastRelation = this.compareBBoxToRangeBBox(this.bbox, minXOffset, minYOffset, minTriangle, maxXOffset, maxYOffset, maxTriangle);
            if (this.crossesDateline() && eastRelation == PointValues.Relation.CELL_OUTSIDE_QUERY) {
                return this.compareBBoxToRangeBBox(this.west, minXOffset, minYOffset, minTriangle, maxXOffset, maxYOffset, maxTriangle);
            }
            return eastRelation;
        }

        PointValues.Relation intersectRangeBBox(int minXOffset, int minYOffset, byte[] minTriangle, int maxXOffset, int maxYOffset, byte[] maxTriangle) {
            PointValues.Relation eastRelation = this.intersectBBoxWithRangeBBox(this.bbox, minXOffset, minYOffset, minTriangle, maxXOffset, maxYOffset, maxTriangle);
            if (this.crossesDateline() && eastRelation == PointValues.Relation.CELL_OUTSIDE_QUERY) {
                return this.intersectBBoxWithRangeBBox(this.west, minXOffset, minYOffset, minTriangle, maxXOffset, maxYOffset, maxTriangle);
            }
            return eastRelation;
        }

        private PointValues.Relation compareBBoxToRangeBBox(byte[] bbox, int minXOffset, int minYOffset, byte[] minTriangle, int maxXOffset, int maxYOffset, byte[] maxTriangle) {
            if (this.disjoint(bbox, minXOffset, minYOffset, minTriangle, maxXOffset, maxYOffset, maxTriangle)) {
                return PointValues.Relation.CELL_OUTSIDE_QUERY;
            }
            if (ArrayUtil.compareUnsigned4(minTriangle, minXOffset, bbox, 4) >= 0 && ArrayUtil.compareUnsigned4(maxTriangle, maxXOffset, bbox, 12) <= 0 && ArrayUtil.compareUnsigned4(minTriangle, minYOffset, bbox, 0) >= 0 && ArrayUtil.compareUnsigned4(maxTriangle, maxYOffset, bbox, 8) <= 0) {
                return PointValues.Relation.CELL_INSIDE_QUERY;
            }
            return PointValues.Relation.CELL_CROSSES_QUERY;
        }

        private PointValues.Relation intersectBBoxWithRangeBBox(byte[] bbox, int minXOffset, int minYOffset, byte[] minTriangle, int maxXOffset, int maxYOffset, byte[] maxTriangle) {
            if (this.disjoint(bbox, minXOffset, minYOffset, minTriangle, maxXOffset, maxYOffset, maxTriangle)) {
                return PointValues.Relation.CELL_OUTSIDE_QUERY;
            }
            if (ArrayUtil.compareUnsigned4(minTriangle, minXOffset, bbox, 4) >= 0 && ArrayUtil.compareUnsigned4(minTriangle, minYOffset, bbox, 0) >= 0) {
                if (ArrayUtil.compareUnsigned4(maxTriangle, minXOffset, bbox, 12) <= 0 && ArrayUtil.compareUnsigned4(maxTriangle, maxYOffset, bbox, 8) <= 0) {
                    return PointValues.Relation.CELL_INSIDE_QUERY;
                }
                if (ArrayUtil.compareUnsigned4(maxTriangle, maxXOffset, bbox, 12) <= 0 && ArrayUtil.compareUnsigned4(maxTriangle, minYOffset, bbox, 8) <= 0) {
                    return PointValues.Relation.CELL_INSIDE_QUERY;
                }
            }
            if (ArrayUtil.compareUnsigned4(maxTriangle, maxXOffset, bbox, 12) <= 0 && ArrayUtil.compareUnsigned4(maxTriangle, maxYOffset, bbox, 8) <= 0) {
                if (ArrayUtil.compareUnsigned4(minTriangle, minXOffset, bbox, 4) >= 0 && ArrayUtil.compareUnsigned4(minTriangle, maxYOffset, bbox, 0) >= 0) {
                    return PointValues.Relation.CELL_INSIDE_QUERY;
                }
                if (ArrayUtil.compareUnsigned4(minTriangle, maxXOffset, bbox, 4) >= 0 && ArrayUtil.compareUnsigned4(minTriangle, minYOffset, bbox, 0) >= 0) {
                    return PointValues.Relation.CELL_INSIDE_QUERY;
                }
            }
            return PointValues.Relation.CELL_CROSSES_QUERY;
        }

        private boolean disjoint(byte[] bbox, int minXOffset, int minYOffset, byte[] minTriangle, int maxXOffset, int maxYOffset, byte[] maxTriangle) {
            return ArrayUtil.compareUnsigned4(minTriangle, minXOffset, bbox, 12) > 0 || ArrayUtil.compareUnsigned4(maxTriangle, maxXOffset, bbox, 4) < 0 || ArrayUtil.compareUnsigned4(minTriangle, minYOffset, bbox, 8) > 0 || ArrayUtil.compareUnsigned4(maxTriangle, maxYOffset, bbox, 0) < 0;
        }
    }
}

