/*
 * Decompiled with CFR 0.152.
 */
package guideme.scene.level;

import guideme.internal.GuideME;
import guideme.internal.util.Platform;
import guideme.scene.level.GuidebookChunkSource;
import it.unimi.dsi.fastutil.longs.LongOpenHashSet;
import it.unimi.dsi.fastutil.longs.LongSet;
import java.util.Arrays;
import java.util.Collections;
import java.util.IdentityHashMap;
import java.util.List;
import java.util.Objects;
import java.util.Set;
import java.util.stream.Collectors;
import java.util.stream.Stream;
import net.minecraft.Util;
import net.minecraft.client.Timer;
import net.minecraft.client.multiplayer.ClientLevel;
import net.minecraft.core.BlockPos;
import net.minecraft.core.Direction;
import net.minecraft.core.Holder;
import net.minecraft.core.RegistryAccess;
import net.minecraft.core.SectionPos;
import net.minecraft.core.registries.Registries;
import net.minecraft.resources.ResourceKey;
import net.minecraft.resources.ResourceLocation;
import net.minecraft.sounds.SoundEvent;
import net.minecraft.sounds.SoundSource;
import net.minecraft.util.profiling.InactiveProfiler;
import net.minecraft.world.Difficulty;
import net.minecraft.world.entity.Entity;
import net.minecraft.world.entity.player.Player;
import net.minecraft.world.flag.FeatureFlagSet;
import net.minecraft.world.flag.FeatureFlags;
import net.minecraft.world.item.crafting.RecipeManager;
import net.minecraft.world.level.ChunkPos;
import net.minecraft.world.level.Level;
import net.minecraft.world.level.LightLayer;
import net.minecraft.world.level.biome.Biome;
import net.minecraft.world.level.biome.Biomes;
import net.minecraft.world.level.block.Block;
import net.minecraft.world.level.block.entity.BlockEntity;
import net.minecraft.world.level.block.state.BlockState;
import net.minecraft.world.level.chunk.ChunkSource;
import net.minecraft.world.level.chunk.DataLayer;
import net.minecraft.world.level.dimension.BuiltinDimensionTypes;
import net.minecraft.world.level.entity.EntityAccess;
import net.minecraft.world.level.entity.LevelCallback;
import net.minecraft.world.level.entity.LevelEntityGetter;
import net.minecraft.world.level.entity.TransientEntitySectionManager;
import net.minecraft.world.level.gameevent.GameEvent;
import net.minecraft.world.level.lighting.LevelLightEngine;
import net.minecraft.world.level.material.Fluid;
import net.minecraft.world.level.saveddata.maps.MapItemSavedData;
import net.minecraft.world.level.storage.WritableLevelData;
import net.minecraft.world.phys.AABB;
import net.minecraft.world.phys.Vec3;
import net.minecraft.world.scores.Scoreboard;
import net.minecraft.world.ticks.BlackholeTickAccess;
import net.minecraft.world.ticks.LevelTickAccess;
import org.jetbrains.annotations.Nullable;

public class GuidebookLevel
extends Level {
    private static final ResourceKey<Level> LEVEL_ID = ResourceKey.m_135785_((ResourceKey)Registries.f_256858_, (ResourceLocation)GuideME.makeId("guidebook"));
    private final TransientEntitySectionManager<Entity> entityStorage = new TransientEntitySectionManager(Entity.class, (LevelCallback)new EntityCallbacks());
    private final ChunkSource chunkSource = new GuidebookChunkSource(this);
    private final Holder<Biome> biome;
    private final RegistryAccess registryAccess;
    private final LongSet filledBlocks = new LongOpenHashSet();
    private final LongSet litSections = new LongOpenHashSet();
    private final DataLayer defaultDataLayer;
    private final ClientLevel.ClientLevelData clientLevelData;
    private final Timer tracker = new Timer(20.0f, 0L);
    private float partialTick;

    public GuidebookLevel() {
        this(Platform.getClientRegistryAccess());
    }

    public GuidebookLevel(RegistryAccess registryAccess) {
        this(GuidebookLevel.createLevelData(), registryAccess);
    }

    private GuidebookLevel(ClientLevel.ClientLevelData levelData, RegistryAccess registryAccess) {
        super((WritableLevelData)GuidebookLevel.createLevelData(), LEVEL_ID, registryAccess, (Holder)registryAccess.m_175515_(Registries.f_256787_).m_246971_(BuiltinDimensionTypes.f_223538_), () -> InactiveProfiler.f_18554_, true, false, 0L, 1000000);
        this.clientLevelData = levelData;
        this.registryAccess = registryAccess;
        this.biome = registryAccess.m_175515_(Registries.f_256952_).m_246971_(Biomes.f_48202_);
        byte[] nibbles = new byte[2048];
        Arrays.fill(nibbles, (byte)-1);
        this.defaultDataLayer = new DataLayer(nibbles);
    }

    public Bounds getBounds() {
        if (this.filledBlocks.isEmpty()) {
            return new Bounds(BlockPos.f_121853_, BlockPos.f_121853_);
        }
        BlockPos.MutableBlockPos min = new BlockPos.MutableBlockPos(Integer.MAX_VALUE, Integer.MAX_VALUE, Integer.MAX_VALUE);
        BlockPos.MutableBlockPos max = new BlockPos.MutableBlockPos(Integer.MIN_VALUE, Integer.MIN_VALUE, Integer.MIN_VALUE);
        BlockPos.MutableBlockPos cur = new BlockPos.MutableBlockPos();
        this.filledBlocks.forEach(packedPos -> {
            cur.m_122188_(packedPos);
            min.m_142451_(Math.min(min.m_123341_(), cur.m_123341_()));
            min.m_142448_(Math.min(min.m_123342_(), cur.m_123342_()));
            min.m_142443_(Math.min(min.m_123343_(), cur.m_123343_()));
            max.m_142451_(Math.max(max.m_123341_(), cur.m_123341_() + 1));
            max.m_142448_(Math.max(max.m_123342_(), cur.m_123342_() + 1));
            max.m_142443_(Math.max(max.m_123343_(), cur.m_123343_() + 1));
        });
        for (Entity entity : this.getEntitiesForRendering()) {
            AABB bounds = entity.m_20191_();
            min.m_142451_(Math.min(min.m_123341_(), (int)bounds.f_82288_));
            min.m_142448_(Math.min(min.m_123342_(), (int)bounds.f_82289_));
            min.m_142443_(Math.min(min.m_123343_(), (int)bounds.f_82290_));
            max.m_142451_(Math.max(max.m_123341_(), (int)Math.ceil(bounds.f_82291_)));
            max.m_142448_(Math.max(max.m_123342_(), (int)Math.ceil(bounds.f_82292_)));
            max.m_142443_(Math.max(max.m_123343_(), (int)Math.ceil(bounds.f_82293_)));
        }
        return new Bounds((BlockPos)min, (BlockPos)max);
    }

    public boolean isFilledBlock(BlockPos blockPos) {
        return this.filledBlocks.contains(blockPos.m_121878_());
    }

    void removeFilledBlock(BlockPos pos) {
        this.filledBlocks.remove(pos.m_121878_());
    }

    void addFilledBlock(BlockPos pos) {
        this.filledBlocks.add(pos.m_121878_());
    }

    public void prepareLighting(BlockPos pos) {
        ChunkPos minChunk = new ChunkPos(pos.m_7918_(-1, -1, -1));
        ChunkPos maxChunk = new ChunkPos(pos.m_7918_(1, 1, 1));
        ChunkPos.m_45599_((ChunkPos)minChunk, (ChunkPos)maxChunk).forEach(chunkPos -> {
            if (this.litSections.add(chunkPos.m_45588_())) {
                LevelLightEngine lightEngine = this.m_5518_();
                for (int i = 0; i < this.m_151559_(); ++i) {
                    int y = this.m_151568_(i);
                    SectionPos sectionPos = SectionPos.m_123196_((ChunkPos)chunkPos, (int)y);
                    lightEngine.m_6191_(sectionPos, false);
                    lightEngine.m_284126_(LightLayer.BLOCK, sectionPos, this.defaultDataLayer);
                    lightEngine.m_284126_(LightLayer.SKY, sectionPos, this.defaultDataLayer);
                }
                lightEngine.m_9335_(chunkPos, true);
                lightEngine.m_142519_(chunkPos);
                lightEngine.m_6462_(chunkPos, false);
            }
        });
    }

    private static ClientLevel.ClientLevelData createLevelData() {
        ClientLevel.ClientLevelData levelData = new ClientLevel.ClientLevelData(Difficulty.PEACEFUL, false, false);
        levelData.m_104863_(6000L);
        return levelData;
    }

    public float getPartialTick() {
        return this.partialTick;
    }

    public void onRenderFrame() {
        int ticksElapsed = this.tracker.m_92525_(Util.m_137550_());
        if (ticksElapsed > 0) {
            this.clientLevelData.m_104849_(this.clientLevelData.m_6793_() + (long)ticksElapsed);
        }
        this.partialTick = this.tracker.f_92518_;
    }

    public boolean hasFilledBlocks() {
        return !this.filledBlocks.isEmpty();
    }

    public Stream<BlockPos> getFilledBlocks() {
        BlockPos.MutableBlockPos mutablePos = new BlockPos.MutableBlockPos();
        return this.filledBlocks.longStream().sequential().mapToObj(pos -> {
            mutablePos.m_122188_(pos);
            return mutablePos;
        });
    }

    public Set<BlockEntity> getBlockEntities() {
        return this.getFilledBlocks().map(arg_0 -> ((GuidebookLevel)this).m_7702_(arg_0)).filter(Objects::nonNull).collect(Collectors.toCollection(() -> Collections.newSetFromMap(new IdentityHashMap())));
    }

    protected LevelEntityGetter<Entity> m_142646_() {
        return this.entityStorage.m_157645_();
    }

    public Iterable<Entity> getEntitiesForRendering() {
        return this.entityStorage.m_157645_().m_142273_();
    }

    public void addEntity(Entity entity) {
        this.removeEntity(entity.m_19879_(), Entity.RemovalReason.DISCARDED);
        this.entityStorage.m_157653_((EntityAccess)entity);
        entity.onAddedToWorld();
        this.prepareLighting(entity.m_20097_());
    }

    public void removeEntity(int entityId, Entity.RemovalReason reason) {
        Entity entity = (Entity)this.m_142646_().m_142597_(entityId);
        if (entity != null) {
            entity.m_142467_(reason);
            entity.m_142036_();
        }
    }

    @Nullable
    public Entity m_6815_(int id) {
        return (Entity)this.m_142646_().m_142597_(id);
    }

    public void m_7260_(BlockPos pos, BlockState oldState, BlockState newState, int flags) {
    }

    public void m_262808_(@Nullable Player player, double d, double e, double f, Holder<SoundEvent> holder, SoundSource soundSource, float g, float h, long l) {
    }

    public void m_213890_(@Nullable Player player, Entity entity, Holder<SoundEvent> holder, SoundSource soundSource, float f, float g, long l) {
    }

    public String m_46464_() {
        return "";
    }

    @Nullable
    public MapItemSavedData m_7489_(String mapName) {
        return null;
    }

    public void m_142325_(String mapId, MapItemSavedData data) {
    }

    public int m_7354_() {
        return 0;
    }

    public void m_6801_(int breakerId, BlockPos pos, int progress) {
    }

    public Scoreboard m_6188_() {
        return new Scoreboard();
    }

    public RecipeManager m_7465_() {
        return Platform.getClientRecipeManager();
    }

    public LevelTickAccess<Block> m_183326_() {
        return BlackholeTickAccess.m_193145_();
    }

    public LevelTickAccess<Fluid> m_183324_() {
        return BlackholeTickAccess.m_193145_();
    }

    public ChunkSource m_7726_() {
        return this.chunkSource;
    }

    public void m_5898_(@Nullable Player player, int type, BlockPos pos, int data) {
    }

    public void m_214171_(GameEvent gameEvent, Vec3 vec3, GameEvent.Context context) {
    }

    public float m_7717_(Direction direction, boolean shade) {
        if (!shade) {
            return 1.0f;
        }
        return switch (direction) {
            case Direction.DOWN -> 0.5f;
            case Direction.NORTH, Direction.SOUTH -> 0.8f;
            case Direction.WEST, Direction.EAST -> 0.6f;
            default -> 1.0f;
        };
    }

    public List<? extends Player> m_6907_() {
        return List.of();
    }

    public Holder<Biome> m_203675_(int i, int j, int k) {
        return this.biome;
    }

    public RegistryAccess m_9598_() {
        return this.registryAccess;
    }

    public FeatureFlagSet m_246046_() {
        return FeatureFlags.f_244332_;
    }

    private static class EntityCallbacks
    implements LevelCallback<Entity> {
        private EntityCallbacks() {
        }

        public void onCreated(Entity entity) {
        }

        public void onDestroyed(Entity entity) {
        }

        public void onTickingStart(Entity entity) {
        }

        public void onTickingEnd(Entity entity) {
        }

        public void onTrackingStart(Entity entity) {
        }

        public void onTrackingEnd(Entity entity) {
        }

        public void onSectionChange(Entity object) {
        }
    }

    public record Bounds(BlockPos min, BlockPos max) {
    }
}

