/*
 * Decompiled with CFR 0.152.
 */
package insane96mcp.insanelib.data;

import com.google.gson.JsonDeserializationContext;
import com.google.gson.JsonDeserializer;
import com.google.gson.JsonElement;
import com.google.gson.JsonObject;
import com.google.gson.JsonParseException;
import com.google.gson.JsonSerializationContext;
import com.google.gson.JsonSerializer;
import com.google.gson.annotations.JsonAdapter;
import com.google.gson.reflect.TypeToken;
import insane96mcp.insanelib.data.IdTagMatcher;
import java.lang.reflect.Type;
import java.util.ArrayList;
import net.minecraft.resources.ResourceLocation;
import net.minecraft.util.GsonHelper;
import net.minecraft.world.item.Item;

@JsonAdapter(value=Serializer.class)
public class TwinIdTagMatcher {
    public IdTagMatcher idTagMatcherA;
    public IdTagMatcher idTagMatcherB;
    public static final Type LIST_TYPE = new TypeToken<ArrayList<TwinIdTagMatcher>>(){}.getType();

    public TwinIdTagMatcher(IdTagMatcher.Type typeA, String locationA, IdTagMatcher.Type typeB, String locationB) {
        this.idTagMatcherA = new IdTagMatcher(typeA, locationA);
        this.idTagMatcherB = new IdTagMatcher(typeB, locationB);
    }

    public boolean matchesItems(Item a, Item b) {
        return this.idTagMatcherA.matchesItem(a) && this.idTagMatcherB.matchesItem(b);
    }

    public static class Serializer
    implements JsonDeserializer<TwinIdTagMatcher>,
    JsonSerializer<TwinIdTagMatcher> {
        public TwinIdTagMatcher deserialize(JsonElement json, Type typeOfT, JsonDeserializationContext context) throws JsonParseException {
            String item1 = GsonHelper.m_13851_((JsonObject)json.getAsJsonObject(), (String)"item_1", (String)"");
            IdTagMatcher.Type type1 = IdTagMatcher.Type.ID;
            if (item1.startsWith("#")) {
                type1 = IdTagMatcher.Type.TAG;
                item1 = item1.substring(1);
            }
            if (!item1.isEmpty() && !ResourceLocation.m_135830_((String)item1)) {
                throw new JsonParseException("Invalid from: %s".formatted(item1));
            }
            String item2 = GsonHelper.m_13851_((JsonObject)json.getAsJsonObject(), (String)"item_2", (String)"");
            IdTagMatcher.Type type2 = IdTagMatcher.Type.ID;
            if (item2.startsWith("#")) {
                type2 = IdTagMatcher.Type.TAG;
                item2 = item2.substring(1);
            }
            if (!item2.isEmpty() && !ResourceLocation.m_135830_((String)item2)) {
                throw new JsonParseException("Invalid from: %s".formatted(item2));
            }
            return new TwinIdTagMatcher(type1, item1, type2, item2);
        }

        public JsonElement serialize(TwinIdTagMatcher src, Type typeOfSrc, JsonSerializationContext context) {
            JsonObject jsonObject = new JsonObject();
            if (src.idTagMatcherA.type == IdTagMatcher.Type.ID) {
                jsonObject.addProperty("item_1", src.idTagMatcherA.location.toString());
            } else {
                jsonObject.addProperty("item_1", "#" + src.idTagMatcherA.location.toString());
            }
            if (src.idTagMatcherB.type == IdTagMatcher.Type.ID) {
                jsonObject.addProperty("item_2", src.idTagMatcherB.location.toString());
            } else {
                jsonObject.addProperty("item_2", "#" + src.idTagMatcherB.location.toString());
            }
            return jsonObject;
        }
    }
}

