/*
 * Decompiled with CFR 0.152.
 */
package insane96mcp.insanelib.util;

import insane96mcp.insanelib.util.LogHelper;
import java.util.ArrayList;
import java.util.Collection;
import java.util.List;
import java.util.Map;
import java.util.UUID;
import javax.annotation.Nullable;
import net.minecraft.advancements.Advancement;
import net.minecraft.core.BlockPos;
import net.minecraft.nbt.CompoundTag;
import net.minecraft.nbt.ListTag;
import net.minecraft.nbt.Tag;
import net.minecraft.resources.ResourceLocation;
import net.minecraft.server.level.ServerPlayer;
import net.minecraft.util.Mth;
import net.minecraft.util.RandomSource;
import net.minecraft.world.damagesource.DamageSource;
import net.minecraft.world.effect.MobEffect;
import net.minecraft.world.effect.MobEffectCategory;
import net.minecraft.world.effect.MobEffectInstance;
import net.minecraft.world.entity.EntityType;
import net.minecraft.world.entity.EquipmentSlot;
import net.minecraft.world.entity.LivingEntity;
import net.minecraft.world.entity.ai.attributes.Attribute;
import net.minecraft.world.entity.ai.attributes.AttributeInstance;
import net.minecraft.world.entity.ai.attributes.AttributeModifier;
import net.minecraft.world.entity.ai.attributes.Attributes;
import net.minecraft.world.entity.player.Player;
import net.minecraft.world.food.FoodProperties;
import net.minecraft.world.item.ItemStack;
import net.minecraft.world.item.alchemy.PotionUtils;
import net.minecraft.world.level.Level;
import net.minecraftforge.registries.ForgeRegistries;
import org.apache.commons.lang3.math.NumberUtils;

public class MCUtils {
    public static double getMovementSpeedRatio(LivingEntity livingEntity) {
        double baseMS = 0.1;
        if (livingEntity.m_20142_()) {
            baseMS += (double)0.03f;
        }
        double entityMS = livingEntity.m_21133_(Attributes.f_22279_);
        return entityMS / baseMS;
    }

    public static void addAttributeModifierToItemStack(ItemStack itemStack, Attribute attribute, AttributeModifier modifier, EquipmentSlot modifierSlot) {
        if (itemStack.m_41782_() && !itemStack.m_41783_().m_128425_("AttributeModifiers", 9)) {
            for (Map.Entry entry : itemStack.m_41638_(modifierSlot).entries()) {
                itemStack.m_41643_((Attribute)entry.getKey(), (AttributeModifier)entry.getValue(), modifierSlot);
            }
        }
        itemStack.m_41643_(attribute, modifier, modifierSlot);
    }

    public static boolean applyModifier(LivingEntity entity, Attribute attribute, UUID uuid, String name, double amount, AttributeModifier.Operation operation, boolean permanent) {
        return MCUtils.applyModifier(entity, attribute, new AttributeModifier(uuid, name, amount, operation), permanent);
    }

    public static boolean applyModifier(LivingEntity entity, Attribute attribute, UUID uuid, String name, double amount, AttributeModifier.Operation operation) {
        return MCUtils.applyModifier(entity, attribute, new AttributeModifier(uuid, name, amount, operation), true);
    }

    public static boolean applyModifier(LivingEntity entity, Attribute attribute, AttributeModifier modifier, boolean permanent) {
        AttributeInstance attributeInstance = entity.m_21051_(attribute);
        if (attributeInstance != null) {
            float newMaxHealth;
            if (attributeInstance.m_22109_(modifier)) {
                return false;
            }
            float oldMaxHealth = entity.m_21233_();
            if (permanent) {
                attributeInstance.m_22125_(modifier);
            } else {
                attributeInstance.m_22118_(modifier);
            }
            if (attribute == Attributes.f_22276_ && (newMaxHealth = entity.m_21233_()) > oldMaxHealth) {
                entity.m_5634_(newMaxHealth - oldMaxHealth);
            }
            return true;
        }
        return false;
    }

    public static void removeModifier(LivingEntity entity, Attribute attribute, UUID uuid) {
        AttributeInstance attributeInstance = entity.m_21051_(attribute);
        if (attributeInstance != null) {
            attributeInstance.m_22120_(uuid);
        }
    }

    public static boolean setAttributeValue(LivingEntity entity, Attribute attribute, double value) {
        AttributeInstance attributeInstance = entity.m_21051_(attribute);
        if (attributeInstance != null) {
            attributeInstance.m_22100_(value);
            if (attribute == Attributes.f_22276_) {
                entity.m_21153_(entity.m_21233_());
            }
            return true;
        }
        return false;
    }

    public static boolean hurtIgnoreInvuln(LivingEntity hurtEntity, DamageSource source, float amount) {
        int hurtResistantTime = hurtEntity.f_19802_;
        hurtEntity.f_19802_ = 0;
        boolean attacked = hurtEntity.m_6469_(source, amount);
        hurtEntity.f_19802_ = hurtResistantTime;
        return attacked;
    }

    public static boolean compareNBT(CompoundTag nbt1, CompoundTag nbt2) {
        for (String key : nbt1.m_128431_()) {
            if (!nbt2.m_128441_(key)) {
                return false;
            }
            if (!(nbt1.m_128423_(key) instanceof CompoundTag && nbt2.m_128423_(key) instanceof CompoundTag ? !MCUtils.compareNBT(nbt1.m_128469_(key), nbt2.m_128469_(key)) : !nbt1.m_128423_(key).equals(nbt2.m_128423_(key)))) continue;
            return false;
        }
        return true;
    }

    public static boolean isAdvancementDone(ServerPlayer player, ResourceLocation advancementRL) {
        Advancement advancement = player.f_8924_.m_129889_().m_136041_(advancementRL);
        if (advancement == null) {
            return false;
        }
        return player.m_8960_().m_135996_(advancement).m_8193_();
    }

    public static ItemStack setCustomEffects(ItemStack itemStack, Collection<MobEffectInstance> mobEffectInstances) {
        if (!mobEffectInstances.isEmpty()) {
            CompoundTag compoundtag = itemStack.m_41784_();
            ListTag listtag = compoundtag.m_128437_("CustomPotionEffects", 9);
            for (MobEffectInstance mobeffectinstance : mobEffectInstances) {
                listtag.add((Object)mobeffectinstance.m_19555_(new CompoundTag()));
            }
            compoundtag.m_128405_("CustomPotionColor", PotionUtils.m_43564_(mobEffectInstances));
            compoundtag.m_128365_("CustomPotionEffects", (Tag)listtag);
        }
        return itemStack;
    }

    public static boolean hasNegativeEffect(LivingEntity entity) {
        for (MobEffectInstance mobEffectInstance : entity.m_21220_()) {
            if (!entity.m_21023_(mobEffectInstance.m_19544_()) || !mobEffectInstance.m_19544_().m_19483_().equals((Object)MobEffectCategory.HARMFUL)) continue;
            return true;
        }
        return false;
    }

    public static boolean hasLongNegativeEffect(LivingEntity entity) {
        for (MobEffectInstance mobEffectInstance : entity.m_21220_()) {
            if (!entity.m_21023_(mobEffectInstance.m_19544_()) || !mobEffectInstance.m_19544_().m_19483_().equals((Object)MobEffectCategory.HARMFUL) || mobEffectInstance.m_19557_() <= 150) continue;
            return true;
        }
        return false;
    }

    public static int getFittingY(EntityType<?> entityType, BlockPos pos, Level level, int minRelativeY) {
        int height = (int)Math.ceil(entityType.m_20679_());
        int fittingYPos = level.m_141937_() - 1;
        for (int y = pos.m_123342_(); y > pos.m_123342_() - minRelativeY; --y) {
            boolean viable = true;
            BlockPos p = new BlockPos(pos.m_123341_(), y, pos.m_123343_());
            for (int i = 0; i < height; ++i) {
                if (!level.m_8055_(p.m_6630_(i)).m_280555_()) continue;
                viable = false;
                break;
            }
            if (!viable) continue;
            fittingYPos = y;
            if (!level.m_8055_(p.m_7495_()).m_280555_()) continue;
            return y;
        }
        return fittingYPos;
    }

    public static int getEnchantmentLevel(ResourceLocation enchantmentId, ItemStack stack) {
        if (stack.m_41619_()) {
            return 0;
        }
        ListTag listTag = stack.m_41785_();
        for (int i = 0; i < listTag.size(); ++i) {
            CompoundTag compoundTag = listTag.m_128728_(i);
            ResourceLocation itemEnchantment = ResourceLocation.m_135820_((String)compoundTag.m_128461_("id"));
            if (itemEnchantment == null || !itemEnchantment.equals((Object)enchantmentId)) continue;
            return Mth.m_14045_((int)compoundTag.m_128451_("lvl"), (int)0, (int)255);
        }
        return 0;
    }

    public static MobEffectInstance createEffectInstance(MobEffect potion, int duration, int amplifier, boolean ambient, boolean showParticles, boolean showIcon, boolean canBeCured) {
        MobEffectInstance effectInstance = new MobEffectInstance(potion, duration, amplifier, ambient, showParticles, showIcon);
        if (!canBeCured) {
            effectInstance.setCurativeItems(new ArrayList());
        }
        return effectInstance;
    }

    public static ArrayList<MobEffectInstance> parseMobEffectsList(List<? extends String> list) {
        ArrayList<MobEffectInstance> mobEffectInstances = new ArrayList<MobEffectInstance>();
        for (String string : list) {
            MobEffectInstance mobEffectInstance = MCUtils.parseEffectInstance(string);
            if (mobEffectInstance == null) continue;
            mobEffectInstances.add(mobEffectInstance);
        }
        return mobEffectInstances;
    }

    @Nullable
    public static MobEffectInstance parseEffectInstance(String s) {
        String[] split = s.split(",");
        if (split.length != 3) {
            LogHelper.warn("Invalid Mob Effect \"%s\"", s);
            return null;
        }
        ResourceLocation effectRL = ResourceLocation.m_135820_((String)split[0]);
        if (effectRL == null) {
            LogHelper.warn("%s mob effect is not valid", split[0]);
            return null;
        }
        if (!ForgeRegistries.MOB_EFFECTS.containsKey(effectRL)) {
            LogHelper.warn("%s mob effect seems to not exist", split[0]);
            return null;
        }
        MobEffect effect = (MobEffect)ForgeRegistries.MOB_EFFECTS.getValue(effectRL);
        if (!NumberUtils.isParsable((String)split[1])) {
            LogHelper.warn(String.format("Invalid duration \"%s\" for Mob Effect", s), new Object[0]);
            return null;
        }
        int duration = Integer.parseInt(split[1]);
        if (!NumberUtils.isParsable((String)split[2])) {
            LogHelper.warn(String.format("Invalid amplifier \"%s\" for Mob Effect", s), new Object[0]);
            return null;
        }
        int amplifier = Integer.parseInt(split[2]);
        return new MobEffectInstance(effect, duration, amplifier);
    }

    public static CompoundTag getOrCreatePersistedData(Player player) {
        CompoundTag tag;
        if (!player.getPersistentData().m_128441_("PlayerPersisted")) {
            tag = new CompoundTag();
            player.getPersistentData().m_128365_("PlayerPersisted", (Tag)tag);
        } else {
            tag = player.getPersistentData().m_128469_("PlayerPersisted");
        }
        return tag;
    }

    public static float getFoodEffectiveness(FoodProperties foodProperties) {
        return (float)foodProperties.m_38744_() + MCUtils.getFoodSaturationRestored(foodProperties);
    }

    public static float getFoodSaturationRestored(FoodProperties foodProperties) {
        return (float)foodProperties.m_38744_() * foodProperties.m_38745_() * 2.0f;
    }

    public static RandomSource syncedRandom(Player player) {
        RandomSource random = player.m_217043_();
        if (player.m_9236_().f_46443_) {
            random.m_188584_(player.m_9236_().m_46467_() + 1L);
        } else {
            random.m_188584_(player.m_9236_().m_46467_());
        }
        random.m_188584_(random.m_188505_());
        random.m_188584_(random.m_188505_());
        return random;
    }
}

