/*
 * Decompiled with CFR 0.152.
 */
package com.codinglitch.lexiconfig;

import com.codinglitch.lexiconfig.LexiconfigApi;
import com.codinglitch.lexiconfig.classes.LexiconData;
import com.codinglitch.lexiconfig.events.CatalogEvent;
import com.codinglitch.lexiconfig.events.RevisionEvent;
import com.codinglitch.lexiconfig.platform.Services;
import java.nio.file.Path;
import java.util.ServiceLoader;

public class Lexiconfig
extends LexiconfigApi {
    public static final Lexiconfig API = new Lexiconfig();
    public static final String ID = "lexiconfig";

    public static <T> T loadService(Class<T> clazz) {
        T loadedService = ServiceLoader.load(clazz).findFirst().orElseThrow(() -> new NullPointerException("Failed to load service for " + clazz.getName()));
        Lexiconfig.debug("Loaded {} for service {}", loadedService, clazz);
        return loadedService;
    }

    @Override
    public Path getConfigPath(LexiconfigApi.Location location) {
        return Services.PLATFORM.getConfigPath();
    }

    public static void revise() {
        Lexiconfig.info("Starting lexicon revision!", new Object[0]);
        API.callEvent(LexiconfigApi.EventType.PRE_REVISION, new RevisionEvent());
        for (LexiconData lexicon : SHELVED_LEXICONS) {
            API.callEvent(LexiconfigApi.EventType.PRE_LEXICON_REVISION, new RevisionEvent.Lexicon(lexicon));
            Lexiconfig.debug("Revising lexicon {}..", lexicon.getName());
            lexicon.load();
            lexicon.save();
            API.callEvent(LexiconfigApi.EventType.POST_LEXICON_REVISION, new RevisionEvent.Lexicon(lexicon));
        }
        API.callEvent(LexiconfigApi.EventType.POST_REVISION, new RevisionEvent());
        Lexiconfig.info("Finished lexicon revision!", new Object[0]);
    }

    public static void publish() {
        Lexiconfig.info("Starting lexicon publishing!", new Object[0]);
        API.callEvent(LexiconfigApi.EventType.PRE_REVISION, new RevisionEvent());
        for (LexiconData lexicon : SHELVED_LEXICONS) {
            API.callEvent(LexiconfigApi.EventType.PRE_LEXICON_REVISION, new RevisionEvent.Lexicon(lexicon));
            Lexiconfig.debug("Publishing lexicon {}..", lexicon.getName());
            lexicon.save();
            lexicon.load();
            API.callEvent(LexiconfigApi.EventType.POST_LEXICON_REVISION, new RevisionEvent.Lexicon(lexicon));
        }
        API.callEvent(LexiconfigApi.EventType.POST_REVISION, new RevisionEvent());
        Lexiconfig.info("Finished lexicon publishing!", new Object[0]);
    }

    public static void initialize() {
    }

    public static void postInitialize() {
        API.callEvent(LexiconfigApi.EventType.PRE_CATALOG, new CatalogEvent());
        for (LexiconData lexicon : SHELVED_LEXICONS) {
            Lexiconfig.info("Cataloging lexicon {}!", lexicon);
            lexicon.catalog();
            lexicon.load();
            lexicon.save();
        }
        API.callEvent(LexiconfigApi.EventType.POST_CATALOG, new CatalogEvent());
        Lexiconfig.info("Lexiconfig cataloging completed!", new Object[0]);
    }

    static {
        Lexiconfig.info("Beginning lexicon shelving!", new Object[0]);
        Services.PLATFORM.shelveLexicons();
    }
}

