/*
 * Decompiled with CFR 0.152.
 */
package me.xjqsh.lesraisinsarmor.compat;

import me.xjqsh.lesraisinsarmor.LesRaisinsArmor;
import me.xjqsh.lesraisinsarmor.client.resource.ArmorRenderConfigManager;
import me.xjqsh.lesraisinsarmor.client.resource.data.ArmorPartRenderConfig;
import me.xjqsh.lesraisinsarmor.client.resource.data.ArmorRenderConfig;
import me.xjqsh.lesraisinsarmor.client.resource.data.PlayerModelPart;
import me.xjqsh.lesraisinsarmor.item.LrArmorItem;
import net.minecraft.resources.ResourceLocation;
import net.minecraft.world.entity.EquipmentSlot;
import net.minecraft.world.entity.LivingEntity;
import net.minecraft.world.item.Item;
import net.minecraftforge.common.MinecraftForge;
import net.minecraftforge.eventbus.api.SubscribeEvent;
import net.minecraftforge.fml.loading.FMLEnvironment;
import org.jetbrains.annotations.Nullable;
import yesman.epicfight.api.client.forgeevent.PrepareModelEvent;
import yesman.epicfight.api.client.model.AnimatedMesh;
import yesman.epicfight.client.mesh.HumanoidMesh;

public class EpicFightCompat {
    public static void init() {
        if (FMLEnvironment.dist.isClient()) {
            LesRaisinsArmor.LOGGER.info("Setup EpicFight Compat");
            MinecraftForge.EVENT_BUS.register((Object)new EpicFightCompat());
        }
    }

    @SubscribeEvent
    public void pre(PrepareModelEvent event) {
        AnimatedMesh animatedMesh = event.getMesh();
        if (animatedMesh instanceof HumanoidMesh) {
            HumanoidMesh mesh = (HumanoidMesh)animatedMesh;
            LivingEntity living = (LivingEntity)event.getEntityPatch().getOriginal();
            if (living != null) {
                EpicFightCompat.resolveVisibleParts(living, EquipmentSlot.HEAD, mesh);
                EpicFightCompat.resolveVisibleParts(living, EquipmentSlot.CHEST, mesh);
                EpicFightCompat.resolveVisibleParts(living, EquipmentSlot.LEGS, mesh);
                EpicFightCompat.resolveVisibleParts(living, EquipmentSlot.FEET, mesh);
            }
        }
    }

    private static void resolveVisibleParts(LivingEntity player, EquipmentSlot slot, HumanoidMesh model) {
        Item item = player.m_6844_(slot).m_41720_();
        if (item instanceof LrArmorItem) {
            LrArmorItem lrArmor = (LrArmorItem)item;
            ArmorRenderConfig config = EpicFightCompat.getConfig(lrArmor);
            if (config == null) {
                return;
            }
            switch (slot) {
                case HEAD: {
                    EpicFightCompat.setVisibility(config.helmet, model);
                    break;
                }
                case CHEST: {
                    EpicFightCompat.setVisibility(config.chestplate, model);
                    break;
                }
                case LEGS: {
                    EpicFightCompat.setVisibility(config.leggings, model);
                    break;
                }
                case FEET: {
                    EpicFightCompat.setVisibility(config.boots, model);
                }
            }
        }
    }

    private static void setVisibility(ArmorPartRenderConfig config, HumanoidMesh model) {
        if (config == null) {
            return;
        }
        for (PlayerModelPart part : config.hideParts) {
            switch (part) {
                case HEAD: {
                    EpicFightCompat.setHidden(model.head);
                    break;
                }
                case HAT: {
                    EpicFightCompat.setHidden(model.hat);
                    break;
                }
                case BODY: {
                    EpicFightCompat.setHidden(model.torso);
                    break;
                }
                case LEFT_ARM: {
                    EpicFightCompat.setHidden(model.leftArm);
                    break;
                }
                case RIGHT_ARM: {
                    EpicFightCompat.setHidden(model.rightArm);
                    break;
                }
                case LEFT_LEG: {
                    EpicFightCompat.setHidden(model.leftLeg);
                    break;
                }
                case RIGHT_LEG: {
                    EpicFightCompat.setHidden(model.rightLeg);
                    break;
                }
                case JACKET: {
                    EpicFightCompat.setHidden(model.jacket);
                    break;
                }
                case LEFT_SLEEVE: {
                    EpicFightCompat.setHidden(model.leftSleeve);
                    break;
                }
                case RIGHT_SLEEVE: {
                    EpicFightCompat.setHidden(model.rightSleeve);
                    break;
                }
                case LEFT_PANTS: {
                    EpicFightCompat.setHidden(model.leftPants);
                    break;
                }
                case RIGHT_PANTS: {
                    EpicFightCompat.setHidden(model.rightPants);
                }
            }
        }
    }

    private static void setHidden(@Nullable AnimatedMesh.AnimatedModelPart part) {
        if (part != null) {
            part.setHidden(true);
        }
    }

    private static ArmorRenderConfig getConfig(LrArmorItem lrArmor) {
        return ArmorRenderConfigManager.getInstance().getConfig(ResourceLocation.m_214293_((String)"lrarmor", (String)lrArmor.getSuitIdf()));
    }
}

