/*
 * Decompiled with CFR 0.152.
 */
package me.xjqsh.lrtactical.api.item;

import java.util.Objects;
import java.util.Optional;
import me.xjqsh.lrtactical.api.LrTacticalAPI;
import me.xjqsh.lrtactical.api.item.ICustomItem;
import me.xjqsh.lrtactical.item.index.ThrowableIndex;
import me.xjqsh.lrtactical.item.throwable.ThrowableData;
import net.minecraft.nbt.CompoundTag;
import net.minecraft.resources.ResourceLocation;
import net.minecraft.world.item.Item;
import net.minecraft.world.item.ItemStack;

public interface IThrowable
extends ICustomItem {
    public static final String ID_TAG = "ThrowableId";
    public static final String OVERRIDE_DISPLAY_ID = "DisplayId";
    public static final ResourceLocation EMPTY = new ResourceLocation("lrtactical", "empty");

    public static IThrowable of(ItemStack stack) {
        Item item = stack.m_41720_();
        if (item instanceof IThrowable) {
            IThrowable item2 = (IThrowable)item;
            return item2;
        }
        return null;
    }

    @Override
    default public ResourceLocation getId(ItemStack stack) {
        CompoundTag nbt = stack.m_41784_();
        if (nbt.m_128425_(ID_TAG, 8)) {
            ResourceLocation gunId = ResourceLocation.m_135820_((String)nbt.m_128461_(ID_TAG));
            return Objects.requireNonNullElse(gunId, EMPTY);
        }
        return EMPTY;
    }

    @Override
    default public ResourceLocation getDisplayId(ItemStack stack) {
        CompoundTag nbt = stack.m_41784_();
        if (nbt.m_128425_(OVERRIDE_DISPLAY_ID, 8)) {
            ResourceLocation rl = ResourceLocation.m_135820_((String)nbt.m_128461_(OVERRIDE_DISPLAY_ID));
            return Objects.requireNonNullElse(rl, EMPTY);
        }
        return this.getId(stack);
    }

    @Override
    default public void setId(ItemStack stack, ResourceLocation id) {
        stack.m_41784_().m_128359_(ID_TAG, id.toString());
    }

    @Override
    default public boolean isSame(ItemStack i, ItemStack j) {
        IThrowable iThrowable1 = IThrowable.of(i);
        IThrowable iThrowable2 = IThrowable.of(j);
        if (iThrowable1 != null && iThrowable2 != null) {
            return iThrowable1.getId(i).equals((Object)iThrowable2.getId(j));
        }
        if (i.m_41619_() || j.m_41619_()) {
            return i.m_41619_() && j.m_41619_();
        }
        return false;
    }

    @Override
    default public Optional<ResourceLocation> getCoolDownId(ItemStack stack) {
        return this.getThrowableIndex(stack).map(index -> ((ThrowableData)index.getData()).getCooldownCategory());
    }

    @Override
    default public int getMaxUsingTick(ItemStack stack) {
        return this.getThrowableIndex(stack).map(index -> ((ThrowableData)index.getData()).getPrepareTime()).orElse(0);
    }

    default public Optional<ThrowableIndex<?, ?>> getThrowableIndex(ItemStack stack) {
        return LrTacticalAPI.getThrowableIndex(stack);
    }
}

