/*
 * Decompiled with CFR 0.152.
 */
package com.jerry.generator_extras.common.network.to_server;

import com.jerry.generator_extras.common.ExtraGenLang;
import com.jerry.generator_extras.common.genregistry.ExtraGenContainerTypes;
import com.jerry.generator_extras.common.tile.reactor.TileEntityNaquadahReactorController;
import java.util.function.BiFunction;
import mekanism.api.text.ILangEntry;
import mekanism.common.network.IMekanismPacket;
import mekanism.common.tile.base.TileEntityMekanism;
import mekanism.common.util.WorldUtils;
import net.minecraft.core.BlockPos;
import net.minecraft.network.FriendlyByteBuf;
import net.minecraft.server.level.ServerPlayer;
import net.minecraft.world.MenuProvider;
import net.minecraft.world.level.BlockGetter;
import net.minecraftforge.network.NetworkEvent;
import net.minecraftforge.network.NetworkHooks;

public class ExtraPacketGeneratorsGuiButtonPress
implements IMekanismPacket {
    private final ExtraClickedGeneratorsTileButton tileButton;
    private final int extra;
    private final BlockPos tilePosition;

    public ExtraPacketGeneratorsGuiButtonPress(ExtraClickedGeneratorsTileButton buttonClicked, BlockPos tilePosition) {
        this(buttonClicked, tilePosition, 0);
    }

    public ExtraPacketGeneratorsGuiButtonPress(ExtraClickedGeneratorsTileButton buttonClicked, BlockPos tilePosition, int extra) {
        this.tileButton = buttonClicked;
        this.tilePosition = tilePosition;
        this.extra = extra;
    }

    public void handle(NetworkEvent.Context context) {
        MenuProvider provider;
        TileEntityMekanism tile;
        ServerPlayer player = context.getSender();
        if (player != null && (tile = (TileEntityMekanism)WorldUtils.getTileEntity(TileEntityMekanism.class, (BlockGetter)player.m_9236_(), (BlockPos)this.tilePosition)) != null && (provider = this.tileButton.getProvider(tile, this.extra)) != null) {
            NetworkHooks.openScreen((ServerPlayer)player, (MenuProvider)provider, buf -> {
                buf.m_130064_(this.tilePosition);
                buf.m_130130_(this.extra);
            });
        }
    }

    public void encode(FriendlyByteBuf buffer) {
        buffer.m_130068_((Enum)this.tileButton);
        buffer.m_130064_(this.tilePosition);
        buffer.m_130130_(this.extra);
    }

    public static ExtraPacketGeneratorsGuiButtonPress decode(FriendlyByteBuf buffer) {
        return new ExtraPacketGeneratorsGuiButtonPress((ExtraClickedGeneratorsTileButton)buffer.m_130066_(ExtraClickedGeneratorsTileButton.class), buffer.m_130135_(), buffer.m_130242_());
    }

    public static enum ExtraClickedGeneratorsTileButton {
        TAB_HEAT((tile, extra) -> ExtraGenContainerTypes.NAQUADAH_REACTOR_HEAT.getProvider((ILangEntry)ExtraGenLang.NAQUADAH_REACTOR, tile)),
        TAB_FUEL((tile, extra) -> ExtraGenContainerTypes.NAQUADAH_REACTOR_FUEL.getProvider((ILangEntry)ExtraGenLang.NAQUADAH_REACTOR, tile)),
        TAB_STATS((tile, extra) -> {
            if (tile instanceof TileEntityNaquadahReactorController) {
                return ExtraGenContainerTypes.NAQUADAH_REACTOR_STATS.getProvider((ILangEntry)ExtraGenLang.NAQUADAH_REACTOR, tile);
            }
            return null;
        });

        private final BiFunction<TileEntityMekanism, Integer, MenuProvider> providerFromTile;

        private ExtraClickedGeneratorsTileButton(BiFunction<TileEntityMekanism, Integer, MenuProvider> providerFromTile) {
            this.providerFromTile = providerFromTile;
        }

        public MenuProvider getProvider(TileEntityMekanism tile, int extra) {
            return this.providerFromTile.apply(tile, extra);
        }
    }
}

