/*
 * Decompiled with CFR 0.152.
 */
package dev.su5ed.mffs.network;

import dev.su5ed.mffs.render.CustomProjectorModeClientHandler;
import dev.su5ed.mffs.util.projector.CustomStructureSavedData;
import java.util.ArrayList;
import java.util.Collection;
import java.util.List;
import java.util.function.Supplier;
import net.minecraft.core.registries.Registries;
import net.minecraft.network.FriendlyByteBuf;
import net.minecraft.resources.ResourceKey;
import net.minecraft.world.level.Level;
import net.minecraft.world.phys.AABB;
import net.minecraft.world.phys.shapes.VoxelShape;
import net.minecraftforge.api.distmarker.Dist;
import net.minecraftforge.fml.DistExecutor;
import net.minecraftforge.network.NetworkEvent;

public record SetStructureShapePacket(ResourceKey<Level> level, String id, VoxelShape shape) {
    public void encode(FriendlyByteBuf buf) {
        buf.m_236858_(this.level);
        buf.m_130070_(this.id);
        buf.m_236821_((Object)this.shape, (b, s) -> b.m_236828_((Collection)s.m_83299_(), SetStructureShapePacket::encodeAABB));
    }

    public static SetStructureShapePacket decode(FriendlyByteBuf buf) {
        ResourceKey level = buf.m_236801_(Registries.f_256858_);
        String id = buf.m_130277_();
        VoxelShape shape = (VoxelShape)buf.m_236868_(b -> CustomStructureSavedData.shapeFromAABBs((List)b.m_236838_(ArrayList::new, SetStructureShapePacket::decodeAABB)));
        return new SetStructureShapePacket((ResourceKey<Level>)level, id, shape);
    }

    public void processClientPacket(Supplier<NetworkEvent.Context> ctx) {
        DistExecutor.unsafeRunWhenOn((Dist)Dist.CLIENT, () -> () -> CustomProjectorModeClientHandler.setShape(this.level, this.id, this.shape));
    }

    private static void encodeAABB(FriendlyByteBuf buf, AABB aabb) {
        buf.writeDouble(aabb.f_82288_);
        buf.writeDouble(aabb.f_82289_);
        buf.writeDouble(aabb.f_82290_);
        buf.writeDouble(aabb.f_82291_);
        buf.writeDouble(aabb.f_82292_);
        buf.writeDouble(aabb.f_82293_);
    }

    private static AABB decodeAABB(FriendlyByteBuf buf) {
        return new AABB(buf.readDouble(), buf.readDouble(), buf.readDouble(), buf.readDouble(), buf.readDouble(), buf.readDouble());
    }
}

