/*
 * Decompiled with CFR 0.152.
 */
package dev.su5ed.mffs.util.projector;

import com.mojang.datafixers.kinds.App;
import com.mojang.datafixers.kinds.Applicative;
import com.mojang.datafixers.util.Pair;
import com.mojang.serialization.Codec;
import com.mojang.serialization.DynamicOps;
import com.mojang.serialization.codecs.RecordCodecBuilder;
import dev.su5ed.mffs.network.Network;
import dev.su5ed.mffs.network.SetStructureShapePacket;
import dev.su5ed.mffs.util.ModUtil;
import java.util.Collection;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import net.minecraft.core.BlockPos;
import net.minecraft.core.Direction;
import net.minecraft.core.Vec3i;
import net.minecraft.nbt.CompoundTag;
import net.minecraft.nbt.NbtOps;
import net.minecraft.nbt.Tag;
import net.minecraft.resources.ResourceKey;
import net.minecraft.server.level.ServerPlayer;
import net.minecraft.world.level.Level;
import net.minecraft.world.level.block.state.BlockState;
import net.minecraft.world.level.saveddata.SavedData;
import net.minecraft.world.phys.AABB;
import net.minecraft.world.phys.Vec3;
import net.minecraft.world.phys.shapes.BooleanOp;
import net.minecraft.world.phys.shapes.Shapes;
import net.minecraft.world.phys.shapes.VoxelShape;
import net.minecraftforge.common.util.Lazy;
import net.minecraftforge.network.PacketDistributor;
import one.util.streamex.EntryStream;
import one.util.streamex.StreamEx;
import org.jetbrains.annotations.Nullable;

public class CustomStructureSavedData
extends SavedData {
    public static final String NAME = "mffs:custom_structures";
    public static final Codec<AABB> AABB_CODEC = RecordCodecBuilder.create(instance -> instance.group((App)Codec.DOUBLE.fieldOf("minX").forGetter(a -> a.f_82288_), (App)Codec.DOUBLE.fieldOf("minY").forGetter(a -> a.f_82289_), (App)Codec.DOUBLE.fieldOf("minZ").forGetter(a -> a.f_82290_), (App)Codec.DOUBLE.fieldOf("maxX").forGetter(a -> a.f_82291_), (App)Codec.DOUBLE.fieldOf("maxY").forGetter(a -> a.f_82292_), (App)Codec.DOUBLE.fieldOf("maxZ").forGetter(a -> a.f_82293_)).apply((Applicative)instance, AABB::new));
    public static final Codec<VoxelShape> VOXEL_SHAPE_CODEC = AABB_CODEC.listOf().xmap(CustomStructureSavedData::shapeFromAABBs, VoxelShape::m_83299_);
    public static final Codec<Map<String, Structure>> CODEC = Codec.unboundedMap((Codec)Codec.STRING, Structure.CODEC);
    private final Map<String, Structure> structures = new HashMap<String, Structure>();

    @Nullable
    public Structure get(String id) {
        return this.structures.get(id);
    }

    public void clear(Level level, ServerPlayer serverPlayer, String id) {
        this.structures.remove(id);
        CustomStructureSavedData.sendToClient((ResourceKey<Level>)level.m_46472_(), id, null, serverPlayer);
    }

    private Structure getOrCreate(String id) {
        return this.structures.computeIfAbsent(id, s -> new Structure());
    }

    public void join(String id, Level level, ServerPlayer serverPlayer, BlockPos min, BlockPos max, boolean add) {
        Structure structure = this.getOrCreate(id);
        BooleanOp op = add ? BooleanOp.f_82695_ : BooleanOp.f_82685_;
        BlockPos normalFrom = ModUtil.normalize(min, max);
        VoxelShape normalShape = Shapes.m_83148_((VoxelShape)structure.normalShape, (VoxelShape)Shapes.m_83064_((AABB)new AABB(normalFrom, ModUtil.normalize(max, normalFrom))), (BooleanOp)op);
        VoxelShape shape = Shapes.m_83148_((VoxelShape)structure.shape, (VoxelShape)Shapes.m_83064_((AABB)new AABB(min, CustomStructureSavedData.normalizeAxis(min, max))), (BooleanOp)op);
        AABB area = new AABB(min, max);
        int x = (int)area.f_82288_;
        while ((double)x <= area.f_82291_) {
            int y = (int)area.f_82289_;
            while ((double)y <= area.f_82292_) {
                int z = (int)area.f_82290_;
                while ((double)z <= area.f_82293_) {
                    BlockPos pos = new BlockPos(x, y, z);
                    BlockState state = level.m_8055_(pos);
                    if (!state.m_60795_()) {
                        if (add) {
                            structure.blocks.put(pos, state);
                        } else {
                            structure.blocks.remove(pos);
                        }
                    }
                    ++z;
                }
                ++y;
            }
            ++x;
        }
        Structure newStruct = new Structure(shape, normalShape, structure.blocks);
        this.structures.put(id, newStruct);
        this.m_77762_();
        CustomStructureSavedData.sendToClient((ResourceKey<Level>)level.m_46472_(), id, normalShape, serverPlayer);
    }

    private static void sendToClient(ResourceKey<Level> key, String id, VoxelShape shape, ServerPlayer player) {
        Network.INSTANCE.send(PacketDistributor.PLAYER.with(() -> player), (Object)new SetStructureShapePacket(key, id, shape));
    }

    private static BlockPos normalizeAxis(BlockPos min, BlockPos max) {
        if (min.m_123341_() == max.m_123341_()) {
            max = max.m_122029_();
        }
        if (min.m_123342_() == max.m_123342_()) {
            max = max.m_7494_();
        }
        if (min.m_123343_() == max.m_123343_()) {
            max = max.m_122019_();
        }
        return max;
    }

    public void remove(String id, BlockPos pos) {
        Structure structure = this.get(id);
        if (structure != null) {
            structure.blocks.remove(pos);
            this.m_77762_();
        }
    }

    public void load(CompoundTag tag) {
        Tag structuresTag = tag.m_128423_("structures");
        this.structures.putAll((Map)((Pair)CODEC.decode((DynamicOps)NbtOps.f_128958_, (Object)structuresTag).getOrThrow(false, s -> {})).getFirst());
    }

    public CompoundTag m_7176_(CompoundTag tag) {
        Tag structuresTag = (Tag)CODEC.encodeStart((DynamicOps)NbtOps.f_128958_, this.structures).getOrThrow(false, s -> {});
        tag.m_128365_("structures", structuresTag);
        return tag;
    }

    public static VoxelShape shapeFromAABBs(List<AABB> aabbs) {
        VoxelShape shape = Shapes.m_83040_();
        for (AABB area : aabbs) {
            VoxelShape partial = Shapes.m_83064_((AABB)area);
            shape = Shapes.m_83148_((VoxelShape)shape, (VoxelShape)partial, (BooleanOp)BooleanOp.f_82695_);
        }
        return shape;
    }

    public static class Structure {
        public static final Codec<Map<BlockPos, BlockState>> BLOCK_MAP_CODEC = Codec.pair((Codec)BlockPos.f_121852_.fieldOf("pos").codec(), (Codec)BlockState.f_61039_.fieldOf("state").codec()).listOf().xmap(pairs -> StreamEx.of((Collection)pairs).mapToEntry(Pair::getFirst, Pair::getSecond).toMap(), map -> EntryStream.of((Map)map).mapKeyValue(Pair::of).toList());
        public static final Codec<Structure> CODEC = RecordCodecBuilder.create(instance -> instance.group((App)VOXEL_SHAPE_CODEC.fieldOf("shape").forGetter(Structure::shape), (App)VOXEL_SHAPE_CODEC.fieldOf("normalShape").forGetter(Structure::normalShape), (App)BLOCK_MAP_CODEC.fieldOf("blocks").forGetter(Structure::blocks)).apply((Applicative)instance, Structure::new));
        private final VoxelShape shape;
        private final VoxelShape normalShape;
        private final Map<BlockPos, BlockState> blocks;
        private final Lazy<Map<BlockPos, BlockState>> relativeBlocks = Lazy.of(this::computeRelativeBlocks);
        @Nullable
        private Map<Vec3, BlockState> realBlocks;

        public Structure() {
            this(Shapes.m_83040_(), Shapes.m_83040_(), new HashMap<BlockPos, BlockState>());
        }

        public Structure(VoxelShape shape, VoxelShape normalShape, Map<BlockPos, BlockState> blocks) {
            this.shape = shape;
            this.normalShape = normalShape;
            this.blocks = blocks;
        }

        public VoxelShape shape() {
            return this.shape;
        }

        public VoxelShape normalShape() {
            return this.normalShape;
        }

        public Map<BlockPos, BlockState> blocks() {
            return this.blocks;
        }

        public Map<BlockPos, BlockState> getRelativeBlocks() {
            return (Map)this.relativeBlocks.get();
        }

        public Map<Vec3, BlockState> getRealBlocks() {
            if (this.realBlocks == null) {
                HashMap<Vec3, BlockState> map = new HashMap<Vec3, BlockState>();
                for (Map.Entry<BlockPos, BlockState> entry : this.getRelativeBlocks().entrySet()) {
                    map.put(Vec3.m_82528_((Vec3i)((Vec3i)entry.getKey())), entry.getValue());
                }
                this.realBlocks = map;
            }
            return this.realBlocks;
        }

        private Map<BlockPos, BlockState> computeRelativeBlocks() {
            BlockPos median = BlockPos.m_274561_((double)((this.shape.m_83288_(Direction.Axis.X) + this.shape.m_83297_(Direction.Axis.X)) / 2.0), (double)((this.shape.m_83288_(Direction.Axis.Y) + this.shape.m_83297_(Direction.Axis.Y)) / 2.0), (double)((this.shape.m_83288_(Direction.Axis.Z) + this.shape.m_83297_(Direction.Axis.Z)) / 2.0));
            HashMap<BlockPos, BlockState> map = new HashMap<BlockPos, BlockState>();
            for (Map.Entry<BlockPos, BlockState> entry : this.blocks.entrySet()) {
                map.put(entry.getKey().m_121996_((Vec3i)median), entry.getValue());
            }
            return map;
        }
    }
}

