/*
 * Decompiled with CFR 0.152.
 */
package dev.su5ed.mffs.util.projector;

import dev.su5ed.mffs.api.Projector;
import dev.su5ed.mffs.api.module.ProjectorMode;
import dev.su5ed.mffs.util.ModUtil;
import java.util.HashSet;
import java.util.Set;
import net.minecraft.core.BlockPos;
import net.minecraft.core.Vec3i;
import net.minecraft.world.phys.Vec3;

public class CylinderProjectorMode
implements ProjectorMode {
    public static final int RADIUS_EXPANSION = 0;

    @Override
    public Set<Vec3> getExteriorPoints(Projector projector) {
        HashSet<Vec3> fieldBlocks = new HashSet<Vec3>();
        BlockPos posScale = projector.getPositiveScale();
        BlockPos negScale = projector.getNegativeScale();
        int radius = (posScale.m_123341_() + negScale.m_123341_() + posScale.m_123343_() + negScale.m_123343_()) / 2;
        int height = posScale.m_123342_() + negScale.m_123342_();
        for (float x = (float)(-radius); x <= (float)radius; x += 1.0f) {
            for (float z = (float)(-radius); z <= (float)radius; z += 1.0f) {
                for (float y = 0.0f; y < (float)height; y += 1.0f) {
                    float area = x * x + z * z + 0.0f;
                    if (!(area <= (float)(radius * radius)) || y != 0.0f && y != (float)(height - 1) && !(area >= (float)((radius - 1) * (radius - 1)))) continue;
                    fieldBlocks.add(new Vec3((double)x, (double)y, (double)z));
                }
            }
        }
        return fieldBlocks;
    }

    @Override
    public Set<Vec3> getInteriorPoints(Projector projector) {
        HashSet<Vec3> fieldBlocks = new HashSet<Vec3>();
        BlockPos posScale = projector.getPositiveScale();
        BlockPos negScale = projector.getNegativeScale();
        BlockPos projectorPos = projector.be().m_58899_().m_121955_((Vec3i)projector.getTranslation());
        int radius = (posScale.m_123341_() + negScale.m_123341_() + posScale.m_123343_() + negScale.m_123343_()) / 2;
        int height = posScale.m_123342_() + negScale.m_123342_();
        for (int x = -radius; x <= radius; ++x) {
            for (int z = -radius; z <= radius; ++z) {
                for (int y = 0; y < height; ++y) {
                    Vec3 position = new Vec3((double)x, (double)y, (double)z);
                    if (!this.isInField(projector, position.m_82520_((double)projectorPos.m_123341_(), (double)projectorPos.m_123342_(), (double)projectorPos.m_123343_()))) continue;
                    fieldBlocks.add(position);
                }
            }
        }
        return fieldBlocks;
    }

    @Override
    public boolean isInField(Projector projector, Vec3 position) {
        BlockPos posScale = projector.getPositiveScale();
        BlockPos negScale = projector.getNegativeScale();
        int radius = (posScale.m_123341_() + negScale.m_123341_() + posScale.m_123343_() + negScale.m_123343_()) / 2;
        BlockPos projectorPos = projector.be().m_58899_().m_121955_((Vec3i)projector.getTranslation());
        Vec3 relativePosition = position.m_82492_((double)projectorPos.m_123341_(), (double)projectorPos.m_123342_(), (double)projectorPos.m_123343_());
        Vec3 relativeRotated = ModUtil.rotateByAngleExact(relativePosition, -projector.getRotationYaw(), -projector.getRotationPitch(), 0.0);
        return relativeRotated.m_7096_() * relativeRotated.m_7096_() + relativeRotated.m_7094_() * relativeRotated.m_7094_() + 0.0 <= (double)(radius * radius);
    }
}

