/*
 * Decompiled with CFR 0.152.
 */
package dev.xkmc.modulargolems.content.item.equipments;

import com.google.common.collect.ImmutableMultimap;
import dev.xkmc.modulargolems.content.entity.common.AbstractGolemEntity;
import dev.xkmc.modulargolems.content.item.equipments.MetalGolemArmorItem;
import dev.xkmc.modulargolems.content.item.equipments.TickEquipmentItem;
import dev.xkmc.modulargolems.init.data.MGLangData;
import java.util.List;
import java.util.UUID;
import net.minecraft.network.chat.Component;
import net.minecraft.network.chat.MutableComponent;
import net.minecraft.resources.ResourceLocation;
import net.minecraft.world.effect.MobEffect;
import net.minecraft.world.effect.MobEffectInstance;
import net.minecraft.world.effect.MobEffects;
import net.minecraft.world.entity.Entity;
import net.minecraft.world.entity.LivingEntity;
import net.minecraft.world.entity.ai.attributes.Attribute;
import net.minecraft.world.entity.ai.attributes.AttributeModifier;
import net.minecraft.world.entity.ai.attributes.Attributes;
import net.minecraft.world.item.ArmorItem;
import net.minecraft.world.item.Item;
import net.minecraft.world.item.ItemStack;
import net.minecraft.world.item.TooltipFlag;
import net.minecraft.world.level.Level;
import net.minecraft.world.phys.AABB;
import org.jetbrains.annotations.Nullable;

public class MetalGolemBeaconItem
extends MetalGolemArmorItem
implements TickEquipmentItem {
    private static Component effDesc(MobEffect eff, int amp) {
        MutableComponent lang = Component.m_237115_((String)eff.m_19481_());
        if (amp > 0) {
            lang = Component.m_237110_((String)"potion.withAmplifier", (Object[])new Object[]{lang, Component.m_237115_((String)("potion.potency." + amp))});
        }
        return lang.m_130940_(eff.m_19483_().m_19497_());
    }

    public MetalGolemBeaconItem(Item.Properties properties, int def, int tough, ResourceLocation model) {
        super(properties, ArmorItem.Type.BOOTS, def, tough, model);
    }

    @Override
    public void m_7373_(ItemStack stack, @Nullable Level level, List<Component> list, TooltipFlag flag) {
        list.add((Component)MGLangData.BEACON_BOOTS.get(MetalGolemBeaconItem.effDesc(MobEffects.f_19600_, 1), MetalGolemBeaconItem.effDesc(MobEffects.f_19606_, 1)));
        super.m_7373_(stack, level, list, flag);
    }

    @Override
    public void tick(ItemStack stack, Level level, Entity user) {
        if ((double)level.m_46467_() % 80.0 != 0.0) {
            return;
        }
        if (user instanceof AbstractGolemEntity) {
            AbstractGolemEntity golem = (AbstractGolemEntity)user;
            double range = 40.0;
            AABB aabb = golem.m_20191_().m_82400_(range).m_82363_(0.0, (double)level.m_141928_(), 0.0);
            for (LivingEntity e : level.m_6443_(LivingEntity.class, aabb, golem::m_7307_)) {
                e.m_7292_(new MobEffectInstance(MobEffects.f_19606_, 200, 1, true, true));
                e.m_7292_(new MobEffectInstance(MobEffects.f_19600_, 200, 1, true, true));
                e.m_5634_(2.0f);
            }
        }
    }

    @Override
    protected void addExtraModifiers(ImmutableMultimap.Builder<Attribute, AttributeModifier> builder) {
        super.addExtraModifiers(builder);
        UUID uuid = (UUID)UUID.get(this.getSlot());
        builder.put((Object)Attributes.f_22279_, (Object)new AttributeModifier(uuid, "Armor modifier", -0.5, AttributeModifier.Operation.MULTIPLY_TOTAL));
    }
}

