/*
 * Decompiled with CFR 0.152.
 */
package dev.xkmc.modulargolems.content.client.overlay;

import dev.xkmc.l2itemselector.select.item.ItemSelectionOverlay;
import dev.xkmc.l2library.base.overlay.OverlayUtil;
import dev.xkmc.l2library.util.Proxy;
import dev.xkmc.l2library.util.raytrace.IGlowingTarget;
import dev.xkmc.l2library.util.raytrace.RayTraceUtil;
import dev.xkmc.modulargolems.compat.materials.botania.BotUtils;
import dev.xkmc.modulargolems.content.capability.GolemConfigEntry;
import dev.xkmc.modulargolems.content.entity.common.AbstractGolemEntity;
import dev.xkmc.modulargolems.content.entity.common.GolemFlags;
import dev.xkmc.modulargolems.content.entity.dog.DogGolemEntity;
import dev.xkmc.modulargolems.content.entity.humanoid.HumanoidGolemEntity;
import dev.xkmc.modulargolems.content.item.wand.GolemInteractItem;
import dev.xkmc.modulargolems.init.data.MGLangData;
import java.util.ArrayList;
import java.util.List;
import javax.annotation.Nullable;
import net.minecraft.ChatFormatting;
import net.minecraft.client.Minecraft;
import net.minecraft.client.gui.Font;
import net.minecraft.client.gui.GuiGraphics;
import net.minecraft.client.gui.screens.inventory.tooltip.ClientTooltipComponent;
import net.minecraft.client.player.LocalPlayer;
import net.minecraft.client.renderer.texture.TextureAtlasSprite;
import net.minecraft.network.chat.Component;
import net.minecraft.resources.ResourceLocation;
import net.minecraft.world.entity.EquipmentSlot;
import net.minecraft.world.entity.LivingEntity;
import net.minecraft.world.entity.player.Player;
import net.minecraft.world.inventory.InventoryMenu;
import net.minecraft.world.item.Item;
import net.minecraft.world.item.ItemStack;
import net.minecraft.world.phys.EntityHitResult;
import net.minecraft.world.phys.HitResult;
import net.minecraftforge.client.gui.overlay.ForgeGui;
import net.minecraftforge.client.gui.overlay.IGuiOverlay;

public class GolemStatusOverlay
implements IGuiOverlay {
    public void render(ForgeGui gui, GuiGraphics g, float partialTick, int screenWidth, int screenHeight) {
        LivingEntity target;
        if (Minecraft.m_91087_().f_91080_ != null) {
            return;
        }
        boolean offset = ItemSelectionOverlay.INSTANCE.isRendering();
        LocalPlayer player = Proxy.getClientPlayer();
        if (player == null) {
            return;
        }
        Item item = player.m_21205_().m_41720_();
        if (!(item instanceof GolemInteractItem)) {
            return;
        }
        GolemInteractItem wand = (GolemInteractItem)item;
        if (wand instanceof IGlowingTarget) {
            target = RayTraceUtil.serverGetTarget((Player)player);
        } else {
            HitResult hit = Minecraft.m_91087_().f_91077_;
            if (!(hit instanceof EntityHitResult)) {
                return;
            }
            EntityHitResult entityHit = (EntityHitResult)hit;
            target = entityHit.m_82443_();
        }
        if (!(target instanceof AbstractGolemEntity)) {
            return;
        }
        AbstractGolemEntity golem = (AbstractGolemEntity)target;
        if (golem.isHostile()) {
            return;
        }
        ArrayList<Object> text = new ArrayList<Object>();
        text.add(golem.m_7755_());
        if (golem.hasFlag(GolemFlags.BOTANIA)) {
            text.add(BotUtils.getDesc((LivingEntity)golem));
        }
        text.add(golem.getMode().getDesc(golem));
        GolemConfigEntry config = golem.getConfigEntry((Component)MGLangData.LOADING.get(new Object[0]));
        if (config != null) {
            config.clientTick(player.m_9236_(), false);
            text.add(config.getDisplayName());
            if (config.locked) {
                text.add(MGLangData.CONFIG_LOCK.get(new Object[0]).m_130940_(ChatFormatting.RED));
            }
        }
        golem.getModifiers().forEach((k, v) -> text.add(k.getTooltip((int)v)));
        int textPos = offset ? Math.round((float)(screenWidth * 3) / 4.0f) : Math.round((float)screenWidth / 8.0f);
        new OverlayUtil(g, textPos, -1, -1).renderLongText(gui.m_93082_(), text);
        OverlayUtil util = new OverlayUtil(g, (int)((double)screenWidth * 0.6), -1, -1);
        util.bg = -3750202;
        List<GolemEquipmentTooltip> list = List.of(new GolemEquipmentTooltip(golem));
        util.renderTooltipInternal(gui.m_93082_(), list);
    }

    private record GolemEquipmentTooltip(AbstractGolemEntity<?, ?> golem) implements ClientTooltipComponent
    {
        public static final ResourceLocation TEXTURE_LOCATION = new ResourceLocation("textures/gui/container/bundle.png");

        public int m_142103_() {
            if (this.golem instanceof DogGolemEntity) {
                return 18;
            }
            return 72;
        }

        public int m_142069_(Font pFont) {
            if (this.golem instanceof DogGolemEntity) {
                return 18;
            }
            return 36;
        }

        public void m_183452_(Font font, int mx, int my, GuiGraphics g) {
            if (this.golem instanceof DogGolemEntity) {
                this.renderSlot(font, mx, my, g, this.golem.m_6844_(EquipmentSlot.HEAD), InventoryMenu.f_39693_);
                return;
            }
            this.renderSlot(font, mx + 18, my, g, this.golem.m_6844_(EquipmentSlot.HEAD), InventoryMenu.f_39693_);
            this.renderSlot(font, mx + 18, my + 18, g, this.golem.m_6844_(EquipmentSlot.CHEST), InventoryMenu.f_39694_);
            this.renderSlot(font, mx + 18, my + 36, g, this.golem.m_6844_(EquipmentSlot.LEGS), InventoryMenu.f_39695_);
            this.renderSlot(font, mx + 18, my + 54, g, this.golem.m_6844_(EquipmentSlot.FEET), InventoryMenu.f_39696_);
            AbstractGolemEntity<?, ?> abstractGolemEntity = this.golem;
            if (abstractGolemEntity instanceof HumanoidGolemEntity) {
                HumanoidGolemEntity h = (HumanoidGolemEntity)abstractGolemEntity;
                this.renderSlot(font, mx, my, g, this.golem.m_6844_(EquipmentSlot.MAINHAND), null);
                this.renderSlot(font, mx, my + 18, g, this.golem.m_6844_(EquipmentSlot.OFFHAND), InventoryMenu.f_39697_);
                this.renderSlot(font, mx, my + 36, g, h.getBackupHand().getItem(), null);
                this.renderSlot(font, mx, my + 54, g, h.getArrowSlot().getItem(), null);
            } else {
                this.renderSlot(font, mx, my + 18, g, this.golem.m_6844_(EquipmentSlot.MAINHAND), null);
                this.renderSlot(font, mx, my + 36, g, this.golem.m_6844_(EquipmentSlot.OFFHAND), InventoryMenu.f_39697_);
            }
        }

        private void renderSlot(Font font, int x, int y, GuiGraphics g, ItemStack stack, @Nullable ResourceLocation atlasID) {
            this.blit(g, x, y);
            if (stack.m_41619_()) {
                if (atlasID != null) {
                    TextureAtlasSprite atlas = (TextureAtlasSprite)Minecraft.m_91087_().m_91258_(InventoryMenu.f_39692_).apply(atlasID);
                    g.m_280159_(x + 1, y + 1, 100, 16, 16, atlas);
                }
                return;
            }
            g.m_280256_(stack, x + 1, y + 1, 0);
            g.m_280370_(font, stack, x + 1, y + 1);
        }

        private void blit(GuiGraphics g, int x, int y) {
            g.m_280398_(TEXTURE_LOCATION, x, y, 0, 0.0f, 0.0f, 18, 18, 128, 128);
        }
    }
}

