/*
 * Decompiled with CFR 0.152.
 */
package dev.xkmc.modulargolems.content.entity.common;

import dev.xkmc.l2serial.serialization.SerialClass;
import net.minecraft.server.level.ServerLevel;
import net.minecraft.server.level.ServerPlayer;
import net.minecraft.stats.Stats;
import net.minecraft.tags.DamageTypeTags;
import net.minecraft.world.damagesource.DamageSource;
import net.minecraft.world.entity.Entity;
import net.minecraft.world.entity.EntityType;
import net.minecraft.world.entity.LivingEntity;
import net.minecraft.world.entity.Pose;
import net.minecraft.world.entity.animal.AbstractGolem;
import net.minecraft.world.level.Level;
import net.minecraft.world.level.gameevent.GameEvent;
import net.minecraftforge.common.ForgeHooks;
import net.minecraftforge.event.ForgeEventFactory;
import org.jetbrains.annotations.MustBeInvokedByOverriders;

@SerialClass
public class GuardedEntity
extends AbstractGolem {
    private long antiHealDisableTimestamp;

    protected GuardedEntity(EntityType<? extends AbstractGolem> type, Level level) {
        super(type, level);
    }

    protected boolean isProtected() {
        return this.m_20147_();
    }

    protected boolean isEffectImmune() {
        return false;
    }

    protected void postHurt(DamageSource source) {
    }

    public boolean isInvulnerableToExtra(DamageSource damage) {
        return this.m_20147_() && !damage.m_269533_(DamageTypeTags.f_268738_);
    }

    protected final void m_6475_(DamageSource source, float amount) {
        if (this.m_6673_(source)) {
            return;
        }
        if (this.isInvulnerableToExtra(source)) {
            return;
        }
        if ((amount = ForgeHooks.onLivingHurt((LivingEntity)this, (DamageSource)source, (float)amount)) <= 0.0f) {
            return;
        }
        amount = this.m_21161_(source, amount);
        amount = this.m_6515_(source, amount);
        amount = ForgeHooks.onLivingDamage((LivingEntity)this, (DamageSource)source, (float)amount);
        this.hurtFinal(source, amount);
    }

    protected final void hurtFinal(DamageSource source, float amount) {
        Entity entity;
        if (!Float.isFinite(amount)) {
            return;
        }
        float abs = this.m_6103_();
        if (!Float.isFinite(abs)) {
            this.m_7911_(0.0f);
            return;
        }
        float actual = Math.max(amount - Math.max(0.0f, abs), 0.0f);
        float absorb = amount - actual;
        this.m_7911_(Math.max(0.0f, this.m_6103_() - absorb));
        if (absorb > 0.0f && absorb < 3.4028235E37f && (entity = source.m_7639_()) instanceof ServerPlayer) {
            ServerPlayer serverplayer = (ServerPlayer)entity;
            serverplayer.m_36222_(Stats.f_12929_, Math.round(absorb * 10.0f));
        }
        if (actual != 0.0f) {
            this.m_21231_().m_289194_(source, actual);
            this.hurtFinalImpl(source, actual);
            this.m_7911_(Math.max(0.0f, this.m_6103_() - actual));
            this.m_146850_(GameEvent.f_223706_);
        }
    }

    protected final void hurtFinalImpl(DamageSource source, float amount) {
        if (this.isInvulnerableToExtra(source)) {
            return;
        }
        if (source.m_269533_(DamageTypeTags.f_268738_)) {
            this.antiHealDisableTimestamp = this.m_9236_().m_46467_() + 100L;
            if (this.m_20147_()) {
                amount = Math.max(amount, Math.max(1.0f, this.m_21233_() * 0.01f));
            }
        }
        super.m_21153_(this.m_21223_() - amount);
        this.postHurt(source);
    }

    public final void validateData() {
        if (this.m_21223_() > 0.0f) {
            if (this.f_20919_ > 0) {
                this.f_20919_ = 0;
            }
            if (this.f_20890_) {
                this.f_20890_ = false;
            }
        }
    }

    public final void m_21153_(float amount) {
        if (!Float.isFinite(amount)) {
            return;
        }
        if (this.m_9236_().m_5776_()) {
            super.m_21153_(amount);
        }
        float health = this.m_21223_();
        if (this.f_19797_ > 5 && amount <= health) {
            return;
        }
        super.m_21153_(amount);
    }

    public final void m_5634_(float original) {
        float heal = ForgeEventFactory.onLivingHeal((LivingEntity)this, (float)original);
        if (this.isEffectImmune() && this.m_9236_().m_46467_() > this.antiHealDisableTimestamp && (heal = Math.max(original, heal)) <= 0.0f) {
            return;
        }
        float f = this.m_21223_();
        if (f > 0.0f) {
            this.m_21153_(f + heal);
        }
    }

    public void m_6667_(DamageSource source) {
        if (this.m_21223_() > 0.0f) {
            return;
        }
        if (ForgeHooks.onLivingDeath((LivingEntity)this, (DamageSource)source)) {
            return;
        }
        if (this.specialDeath(source)) {
            return;
        }
        if (this.m_213877_() || this.f_20890_) {
            return;
        }
        Entity entity = source.m_7639_();
        LivingEntity livingentity = this.m_21232_();
        if (this.f_20897_ >= 0 && livingentity != null) {
            livingentity.m_5993_((Entity)this, this.f_20897_, source);
        }
        if (this.m_5803_()) {
            this.m_5796_();
        }
        this.f_20890_ = true;
        this.m_21231_().m_19296_();
        Level level = this.m_9236_();
        if (level instanceof ServerLevel) {
            ServerLevel serverlevel = (ServerLevel)level;
            if (entity == null || entity.m_214076_(serverlevel, (LivingEntity)this)) {
                this.m_146850_(GameEvent.f_223707_);
                this.m_6668_(source);
                this.m_21268_(livingentity);
            }
            this.m_9236_().m_7605_((Entity)this, (byte)3);
        }
        this.m_20124_(Pose.DYING);
    }

    public boolean specialDeath(DamageSource source) {
        return false;
    }

    @MustBeInvokedByOverriders
    public void m_8119_() {
        double maxSpeed = 1.5;
        if (this.isProtected() && this.m_20184_().m_82553_() > maxSpeed) {
            this.m_20256_(this.m_20184_().m_82541_().m_82490_(maxSpeed));
        }
        this.validateData();
        super.m_8119_();
    }

    public void onRemove(Entity.RemovalReason reason) {
    }
}

