/*
 * Decompiled with CFR 0.152.
 */
package net.mehvahdjukaar.moonlight.core.set;

import java.io.IOException;
import java.nio.file.Files;
import java.nio.file.Path;
import java.nio.file.Paths;
import java.nio.file.StandardOpenOption;
import java.nio.file.attribute.FileAttribute;
import java.util.Map;
import java.util.TreeSet;
import net.mehvahdjukaar.moonlight.api.set.BlockSetAPI;
import net.mehvahdjukaar.moonlight.api.set.BlockType;
import net.mehvahdjukaar.moonlight.api.set.BlockTypeRegistry;
import net.mehvahdjukaar.moonlight.core.CommonConfigs;
import net.mehvahdjukaar.moonlight.core.Moonlight;
import net.minecraft.core.registries.BuiltInRegistries;
import net.minecraft.world.item.Item;

public class DebugBlockTypes {
    private static final Path debugDir = Paths.get("debug", "dynamic_registry_dump");

    public static void writeToFile() {
        try {
            Files.createDirectories(debugDir, new FileAttribute[0]);
            for (BlockTypeRegistry<?> reg : BlockSetAPI.getRegistries()) {
                String registryName = reg.typeName().replace(":", "_");
                Path filePath = debugDir.resolve(registryName + ".txt");
                StringBuilder builder = new StringBuilder();
                builder.append("\u2500\u2500\u2500\u2500\u2500\u2500\u2500\u2500\u2500\u2500\u2500\u2500\u2500\u2500\u2500\u2500\u2500\u2500\u2500\u2500\u2500\u2500\u2500\u2500\u2500\u2500\u2500\u2500\u2500\u2500\u2500 LIST \u2500\u2500\u2500\u2500\u2500\u2500\u2500\u2500\u2500\u2500\u2500\u2500\u2500\u2500\u2500\u2500\u2500\u2500\u2500\u2500\u2500\u2500\u2500\u2500\u2500\u2500\u2500\u2500\u2500\u2500\u2500\u2500").append(System.lineSeparator());
                for (BlockType entry : reg.getValues()) {
                    builder.append(entry.getId().toString()).append(System.lineSeparator());
                }
                if (CommonConfigs.EXTRA_CHILDREN_DEBUG.get().booleanValue()) {
                    builder.append(System.lineSeparator()).append("\u2500\u2500\u2500\u2500\u2500\u2500\u2500\u2500\u2500\u2500\u2500\u2500\u2500\u2500\u2500\u2500\u2500\u2500\u2500\u2500\u2500\u2500\u2500\u2500\u2500\u2500\u2500\u2500\u2500\u2500\u2500 LIST OF CHILDREN \u2500\u2500\u2500\u2500\u2500\u2500\u2500\u2500\u2500\u2500\u2500\u2500\u2500\u2500\u2500\u2500\u2500\u2500\u2500\u2500\u2500\u2500\u2500\u2500\u2500\u2500\u2500\u2500\u2500\u2500\u2500\u2500").append(System.lineSeparator());
                    TreeSet<String> allChildKeys = new TreeSet<String>();
                    for (BlockType entry : reg.getValues()) {
                        allChildKeys.addAll(entry.getChildren().stream().map(Map.Entry::getKey).toList());
                    }
                    for (BlockType entry : reg.getValues()) {
                        builder.append("[").append(entry.getId().toString()).append("]").append(System.lineSeparator());
                        if (allChildKeys.isEmpty()) {
                            builder.append("  (no children)").append(System.lineSeparator());
                        } else {
                            for (String key : allChildKeys) {
                                Object value = entry.getChild(key);
                                builder.append("  - ").append(key).append(" = ").append(value != null ? DebugBlockTypes.formatValue(value) : "MISSING").append(System.lineSeparator());
                            }
                        }
                        builder.append(System.lineSeparator());
                    }
                }
                Files.writeString(filePath, (CharSequence)builder.toString(), StandardOpenOption.CREATE, StandardOpenOption.TRUNCATE_EXISTING);
            }
        }
        catch (IOException e) {
            Moonlight.LOGGER.error("Failed to write registry debug dump: {}", (Object)e.toString());
        }
    }

    private static Object formatValue(Object child) {
        if (child instanceof Item) {
            Item i = (Item)child;
            return "Item{" + String.valueOf(BuiltInRegistries.f_257033_.m_7981_((Object)i)) + "}";
        }
        return child.toString();
    }
}

