/*
 * Decompiled with CFR 0.152.
 */
package commoble.morered.wires;

import com.mojang.math.OctahedralGroup;
import commoble.morered.MoreRed;
import commoble.morered.api.ChanneledPowerSupplier;
import commoble.morered.api.MoreRedAPI;
import commoble.morered.util.DirectionHelper;
import commoble.morered.wires.AbstractWireBlock;
import commoble.morered.wires.BundledCableBlock;
import it.unimi.dsi.fastutil.bytes.ByteArrayList;
import java.util.EnumMap;
import java.util.Map;
import javax.annotation.Nullable;
import net.minecraft.Util;
import net.minecraft.core.BlockPos;
import net.minecraft.core.Direction;
import net.minecraft.nbt.CompoundTag;
import net.minecraft.nbt.Tag;
import net.minecraft.world.level.Level;
import net.minecraft.world.level.block.Block;
import net.minecraft.world.level.block.entity.BlockEntity;
import net.minecraft.world.level.block.entity.BlockEntityType;
import net.minecraft.world.level.block.state.BlockState;
import net.minecraft.world.level.block.state.properties.Property;
import net.minecraftforge.common.capabilities.Capability;
import net.minecraftforge.common.util.LazyOptional;

public class BundledCableBlockEntity
extends BlockEntity {
    public static final String POWER = "power";
    public static final String CHANNEL_FLAGS = "channel_flags";
    public static final String POWER_BYTES = "power_bytes";
    protected byte[][] power = new byte[6][16];
    protected Map<Direction, LazyOptional<ChanneledPowerSupplier>> sidedPowerSuppliers = (Map)Util.m_137469_(new EnumMap(Direction.class), map -> {
        for (int i = 0; i < 6; ++i) {
            Direction dir = Direction.m_122376_((int)i);
            map.put(dir, LazyOptional.of(() -> new SidedPowerSupplier(dir)));
        }
    });

    public BundledCableBlockEntity(BlockEntityType<? extends BundledCableBlockEntity> type, BlockPos pos, BlockState state) {
        super(type, pos, state);
    }

    public BundledCableBlockEntity(BlockPos pos, BlockState state) {
        this((BlockEntityType<? extends BundledCableBlockEntity>)((BlockEntityType)MoreRed.get().bundledNetworkCableBeType.get()), pos, state);
    }

    public void invalidateCaps() {
        super.invalidateCaps();
        this.sidedPowerSuppliers.forEach((dir, holder) -> holder.invalidate());
    }

    public int getPower(int side, int channel) {
        return this.power[side][channel];
    }

    public byte[] getPowerChannels(int side) {
        return this.power[side];
    }

    public boolean setPower(int side, int channel, int newPower) {
        byte oldPower = this.power[side][channel];
        this.power[side][channel] = (byte)newPower;
        if (oldPower != newPower) {
            if (!this.f_58857_.f_46443_) {
                this.m_6596_();
            }
            return true;
        }
        return false;
    }

    public void setPowerRaw(byte[][] newPower) {
        this.power = newPower;
    }

    public <T> LazyOptional<T> getCapability(Capability<T> cap, Direction side) {
        if (cap == MoreRedAPI.CHANNELED_POWER_CAPABILITY && side != null) {
            return this.sidedPowerSuppliers.get(side);
        }
        return super.getCapability(cap, side);
    }

    public void m_183515_(CompoundTag compound) {
        super.m_183515_(compound);
        this.writeServerData(compound);
    }

    public void m_142466_(CompoundTag compound) {
        super.m_142466_(compound);
        this.readServerData(compound);
    }

    public CompoundTag writeServerData(CompoundTag compound) {
        this.writeAllPowerData(compound);
        return compound;
    }

    public void readServerData(CompoundTag compound) {
        this.readUpdatedPowerData(compound);
    }

    public CompoundTag writeAllPowerData(CompoundTag compound) {
        CompoundTag powerData = new CompoundTag();
        boolean wrotePower = false;
        for (int sideIndex = 0; sideIndex < 6; sideIndex = (int)((byte)(sideIndex + 1))) {
            OctahedralGroup normalizer = ((OctahedralGroup)this.m_58900_().m_61143_(AbstractWireBlock.TRANSFORM)).m_174944_();
            Direction denormalSide = Direction.m_122376_((int)sideIndex);
            Direction normalizedSide = normalizer.m_56528_(denormalSide);
            ByteArrayList bytes = new ByteArrayList();
            short channelFlags = 0;
            for (int channel = 0; channel < 16; channel = (int)((byte)(channel + 1))) {
                int powerValue = this.getPower(sideIndex, channel);
                if (powerValue <= 0) continue;
                bytes.add((byte)powerValue);
                channelFlags = (short)(channelFlags + (1 << channel));
            }
            if (bytes.size() <= 0) continue;
            CompoundTag sidedPower = new CompoundTag();
            sidedPower.m_128376_(CHANNEL_FLAGS, channelFlags);
            sidedPower.m_128382_(POWER_BYTES, bytes.toByteArray());
            powerData.m_128365_(normalizedSide.m_122433_(), (Tag)sidedPower);
            wrotePower = true;
        }
        if (wrotePower) {
            compound.m_128365_(POWER, (Tag)powerData);
        }
        return compound;
    }

    public void readUpdatedPowerData(CompoundTag compound) {
        CompoundTag powerData = compound.m_128469_(POWER);
        if (powerData == null) {
            return;
        }
        for (int sideIndex = 0; sideIndex < 6; ++sideIndex) {
            OctahedralGroup denormalizer = (OctahedralGroup)this.m_58900_().m_61143_(AbstractWireBlock.TRANSFORM);
            Direction normalSide = Direction.m_122376_((int)sideIndex);
            Direction denormalizedSide = denormalizer.m_56528_(normalSide);
            int denormalizedSideIndex = denormalizedSide.ordinal();
            CompoundTag sidedPower = powerData.m_128469_(normalSide.m_122433_());
            if (sidedPower == null) continue;
            short channels = sidedPower.m_128448_(CHANNEL_FLAGS);
            byte[] powerValues = sidedPower.m_128463_(POWER_BYTES);
            int powerByteCount = powerValues.length;
            int powerByteIndex = 0;
            for (int channel = 0; channel < 16 && powerByteIndex < powerByteCount; ++channel) {
                int channelFlag = 1 << channel;
                if ((channels & channelFlag) == 0) continue;
                this.power[denormalizedSideIndex][channel] = powerValues[powerByteIndex++];
            }
        }
    }

    protected class SidedPowerSupplier
    implements ChanneledPowerSupplier {
        private final Direction side;

        public SidedPowerSupplier(Direction side) {
            this.side = side;
        }

        @Override
        public int getPowerOnChannel(Level world, BlockPos wirePos, BlockState wireState, @Nullable Direction wireFace, int channel) {
            BundledCableBlockEntity cable = BundledCableBlockEntity.this;
            BlockState state = cable.m_58900_();
            Block block = state.m_60734_();
            if (!(block instanceof BundledCableBlock)) {
                return 0;
            }
            int sideIndex = this.side.ordinal();
            if (((Boolean)state.m_61143_((Property)AbstractWireBlock.INTERIOR_FACES[sideIndex])).booleanValue()) {
                return cable.getPower(sideIndex, channel);
            }
            if (wireFace != null) {
                return cable.getPower(wireFace.ordinal(), channel);
            }
            int output = 0;
            for (int subSide = 0; subSide < 4; ++subSide) {
                int actualSubSide = DirectionHelper.uncompressSecondSide(sideIndex, subSide);
                if (!((Boolean)state.m_61143_((Property)AbstractWireBlock.INTERIOR_FACES[actualSubSide])).booleanValue()) continue;
                output = Math.max(output, cable.power[actualSubSide][channel]);
            }
            return output;
        }
    }
}

