/*
 * Decompiled with CFR 0.152.
 */
package com.wuest.prefab.crafting;

import com.google.common.base.Strings;
import com.google.gson.JsonArray;
import com.google.gson.JsonElement;
import com.google.gson.JsonObject;
import com.google.gson.JsonParseException;
import com.wuest.prefab.ModRegistry;
import com.wuest.prefab.Prefab;
import com.wuest.prefab.crafting.ConditionedShapedRecipe;
import net.minecraft.core.NonNullList;
import net.minecraft.core.RegistryAccess;
import net.minecraft.network.FriendlyByteBuf;
import net.minecraft.resources.ResourceLocation;
import net.minecraft.util.GsonHelper;
import net.minecraft.world.entity.player.StackedContents;
import net.minecraft.world.inventory.CraftingContainer;
import net.minecraft.world.item.ItemStack;
import net.minecraft.world.item.crafting.CraftingBookCategory;
import net.minecraft.world.item.crafting.Ingredient;
import net.minecraft.world.item.crafting.Recipe;
import net.minecraft.world.item.crafting.RecipeSerializer;
import net.minecraft.world.item.crafting.ShapelessRecipe;
import net.minecraft.world.level.Level;

public class ConditionedShapelessRecipe
extends ShapelessRecipe {
    private final ResourceLocation resourceLocation;
    private final String group;
    CraftingBookCategory category;
    private final ItemStack output;
    private final NonNullList<Ingredient> ingredients;
    private final String configName;

    public ConditionedShapelessRecipe(ResourceLocation resourceLocation, String group, CraftingBookCategory craftingBookCategory, ItemStack output, NonNullList<Ingredient> ingredients, String configName) {
        super(resourceLocation, group, craftingBookCategory, output, ingredients);
        this.resourceLocation = resourceLocation;
        this.group = group;
        this.output = output;
        this.ingredients = ingredients;
        this.configName = configName;
        this.category = craftingBookCategory;
    }

    public RecipeSerializer<?> m_7707_() {
        return (RecipeSerializer)ModRegistry.ConditionedShapelessRecipeSeriaizer.get();
    }

    public String m_6076_() {
        return this.group;
    }

    public ItemStack m_8043_(RegistryAccess registryAccess) {
        return this.output;
    }

    public NonNullList<Ingredient> m_7527_() {
        return this.ingredients;
    }

    public boolean m_5818_(CraftingContainer craftingInventory, Level world) {
        StackedContents stackedContents = new StackedContents();
        int i = 0;
        for (int j = 0; j < craftingInventory.m_6643_(); ++j) {
            ItemStack itemStack = craftingInventory.m_8020_(j);
            if (itemStack.m_41619_()) continue;
            ++i;
            stackedContents.m_36468_(itemStack, 1);
        }
        return i == this.ingredients.size() && stackedContents.m_36475_((Recipe)this, null);
    }

    public ItemStack m_5874_(CraftingContainer craftingContainer, RegistryAccess registryAccess) {
        return this.output.m_41777_();
    }

    public boolean m_8004_(int width, int height) {
        return width * height >= this.ingredients.size();
    }

    public static class Serializer
    implements RecipeSerializer<ConditionedShapelessRecipe> {
        public ConditionedShapelessRecipe fromJson(ResourceLocation identifier, JsonObject jsonObject) {
            String groupName = GsonHelper.m_13851_((JsonObject)jsonObject, (String)"group", (String)"");
            String configName = GsonHelper.m_13851_((JsonObject)jsonObject, (String)"configName", (String)"");
            NonNullList<Ingredient> defaultedList = Serializer.itemsFromJson(GsonHelper.m_13933_((JsonObject)jsonObject, (String)"ingredients"));
            if (defaultedList.isEmpty()) {
                throw new JsonParseException("No ingredients for shapeless recipe");
            }
            if (defaultedList.size() > 9) {
                throw new JsonParseException("Too many ingredients for shapeless recipe");
            }
            ItemStack itemStack = Serializer.validateRecipeOutput(ConditionedShapedRecipe.m_151274_((JsonObject)GsonHelper.m_13930_((JsonObject)jsonObject, (String)"result")), configName);
            return new ConditionedShapelessRecipe(identifier, groupName, CraftingBookCategory.MISC, itemStack, defaultedList, configName);
        }

        private static NonNullList<Ingredient> itemsFromJson(JsonArray json) {
            NonNullList defaultedList = NonNullList.m_122779_();
            for (int i = 0; i < json.size(); ++i) {
                Ingredient ingredient = Ingredient.m_43917_((JsonElement)json.get(i));
                if (ingredient.m_43947_()) continue;
                defaultedList.add((Object)ingredient);
            }
            return defaultedList;
        }

        public ConditionedShapelessRecipe fromNetwork(ResourceLocation identifier, FriendlyByteBuf packetByteBuf) {
            String groupName = packetByteBuf.m_130277_();
            String configName = packetByteBuf.m_130277_();
            int i = packetByteBuf.m_130242_();
            NonNullList defaultedList = NonNullList.m_122780_((int)i, (Object)Ingredient.f_43901_);
            defaultedList.replaceAll(ignored -> Ingredient.m_43940_((FriendlyByteBuf)packetByteBuf));
            ItemStack itemStack = Serializer.validateRecipeOutput(packetByteBuf.m_130267_(), configName);
            return new ConditionedShapelessRecipe(identifier, groupName, CraftingBookCategory.MISC, itemStack, (NonNullList<Ingredient>)defaultedList, configName);
        }

        public void toNetwork(FriendlyByteBuf packetByteBuf, ConditionedShapelessRecipe shapelessRecipe) {
            packetByteBuf.m_130070_(shapelessRecipe.group);
            packetByteBuf.m_130070_(shapelessRecipe.configName);
            packetByteBuf.m_130130_(shapelessRecipe.ingredients.size());
            for (Ingredient ingredient : shapelessRecipe.ingredients) {
                ingredient.m_43923_(packetByteBuf);
            }
            packetByteBuf.m_130055_(shapelessRecipe.output);
        }

        public static ItemStack validateRecipeOutput(ItemStack originalOutput, String configName) {
            if (originalOutput == ItemStack.f_41583_) {
                return ItemStack.f_41583_;
            }
            if (!Strings.isNullOrEmpty((String)configName) && Prefab.proxy.getServerConfiguration().recipeConfiguration.containsKey(configName) && !Prefab.proxy.getServerConfiguration().recipeConfiguration.get(configName).booleanValue()) {
                return ItemStack.f_41583_;
            }
            return originalOutput;
        }
    }
}

