/*
 * Decompiled with CFR 0.152.
 */
package com.wuest.prefab.gui;

import com.wuest.prefab.Tuple;
import com.wuest.prefab.Utils;
import com.wuest.prefab.blocks.FullDyeColor;
import com.wuest.prefab.gui.GuiLangKeys;
import com.wuest.prefab.gui.GuiUtils;
import com.wuest.prefab.gui.controls.CustomButton;
import com.wuest.prefab.gui.controls.ExtendedButton;
import com.wuest.prefab.gui.controls.GuiCheckBox;
import com.wuest.prefab.gui.controls.GuiSlider;
import java.awt.Color;
import java.util.List;
import net.minecraft.client.Minecraft;
import net.minecraft.client.gui.Font;
import net.minecraft.client.gui.GuiGraphics;
import net.minecraft.client.gui.components.AbstractButton;
import net.minecraft.client.gui.components.AbstractWidget;
import net.minecraft.client.gui.components.events.GuiEventListener;
import net.minecraft.client.gui.screens.Screen;
import net.minecraft.network.chat.CommonComponents;
import net.minecraft.network.chat.Component;
import net.minecraft.network.chat.FormattedText;
import net.minecraft.resources.ResourceLocation;
import net.minecraft.util.FormattedCharSequence;
import net.minecraft.world.item.DyeColor;
import org.jetbrains.annotations.NotNull;

public abstract class GuiBase
extends Screen {
    private final ResourceLocation backgroundTextures = new ResourceLocation("prefab", "textures/gui/default_background.png");
    private final ResourceLocation narrowPanelTexture = new ResourceLocation("prefab", "textures/gui/custom_background.png");
    private final ResourceLocation leftPanelTexture = new ResourceLocation("prefab", "textures/gui/custom_left_panel.png");
    private final ResourceLocation middlePanelTexture = new ResourceLocation("prefab", "textures/gui/custom_middle_panel.png");
    private final ResourceLocation rightPanelTexture = new ResourceLocation("prefab", "textures/gui/custom_right_panel.png");
    protected int modifiedInitialXAxis = 213;
    protected int modifiedInitialYAxis = 83;
    protected int imagePanelWidth = 0;
    protected int imagePanelHeight = 0;
    protected int shownImageHeight = 0;
    protected int shownImageWidth = 0;
    protected int textColor = Color.DARK_GRAY.getRGB();

    public GuiBase(String title) {
        super((Component)Utils.createTextComponent(title));
    }

    public void m_7856_() {
        this.Initialize();
    }

    protected void Initialize() {
        this.modifiedInitialXAxis = 160;
        this.modifiedInitialYAxis = 120;
        this.imagePanelWidth = 325;
        this.imagePanelHeight = 300;
        this.shownImageHeight = 150;
        this.shownImageWidth = 268;
    }

    protected int getCenteredXAxis() {
        return this.f_96543_ / 2;
    }

    protected int getCenteredYAxis() {
        return this.f_96544_ / 2;
    }

    public void m_88315_(GuiGraphics guiGraphics, int x, int y, float f) {
        Tuple<Integer, Integer> adjustedXYValue = this.getAdjustedXYValue();
        this.preButtonRender(guiGraphics, adjustedXYValue.getFirst(), adjustedXYValue.getSecond(), x, y, f);
        this.renderButtons(guiGraphics, x, y);
        this.postButtonRender(guiGraphics, adjustedXYValue.getFirst(), adjustedXYValue.getSecond(), x, y, f);
    }

    public ExtendedButton createAndAddButton(int x, int y, int width, int height, String text, String label) {
        return this.createAndAddButton(x, y, width, height, text, true, label);
    }

    public ExtendedButton createAndAddButton(int x, int y, int width, int height, String text) {
        return this.createAndAddButton(x, y, width, height, text, true);
    }

    public ExtendedButton createAndAddButton(int x, int y, int width, int height, String text, boolean translate, String label) {
        ExtendedButton returnValue = new ExtendedButton(x, y, width, height, (Component)(translate ? GuiLangKeys.translateToComponent(text) : Utils.createTextComponent(text)), this::buttonClicked, label);
        return (ExtendedButton)this.m_142416_((GuiEventListener)returnValue);
    }

    public ExtendedButton createAndAddButton(int x, int y, int width, int height, String text, boolean translate) {
        ExtendedButton returnValue = new ExtendedButton(x, y, width, height, (Component)(translate ? GuiLangKeys.translateToComponent(text) : Utils.createTextComponent(text)), this::buttonClicked, null);
        return (ExtendedButton)this.m_142416_((GuiEventListener)returnValue);
    }

    public CustomButton createAndAddCustomButton(int x, int y, int width, int height, String text) {
        return this.createAndAddCustomButton(x, y, width, height, text, true);
    }

    public CustomButton createAndAddCustomButton(int x, int y, int width, int height, String text, boolean translate) {
        CustomButton returnValue = new CustomButton(x, y, width, height, (Component)(translate ? GuiLangKeys.translateToComponent(text) : Utils.createTextComponent(text)), this::buttonClicked);
        return (CustomButton)this.m_142416_((GuiEventListener)returnValue);
    }

    public ExtendedButton createAndAddDyeButton(int x, int y, int width, int height, DyeColor color, String label) {
        ExtendedButton returnValue = new ExtendedButton(x, y, width, height, (Component)Utils.createTextComponent(GuiLangKeys.translateDye(color)), this::buttonClicked, label);
        this.m_142416_((GuiEventListener)returnValue);
        return returnValue;
    }

    public ExtendedButton createAndAddFullDyeButton(int x, int y, int width, int height, FullDyeColor color, String label) {
        ExtendedButton returnValue = new ExtendedButton(x, y, width, height, (Component)Utils.createTextComponent(GuiLangKeys.translateFullDye(color)), this::buttonClicked, label);
        this.m_142416_((GuiEventListener)returnValue);
        return returnValue;
    }

    public GuiCheckBox createAndAddCheckBox(int xPos, int yPos, String displayString, boolean isChecked, GuiCheckBox.IPressable handler) {
        GuiCheckBox checkBox = new GuiCheckBox(xPos, yPos, GuiLangKeys.translateString(displayString), isChecked, handler);
        this.m_142416_((GuiEventListener)checkBox);
        return checkBox;
    }

    public GuiSlider createAndAddSlider(int xPos, int yPos, int width, int height, double minVal, double maxVal, double currentVal) {
        GuiSlider slider = new GuiSlider(xPos, yPos, width, height, CommonComponents.f_237098_, minVal, maxVal, currentVal);
        this.m_142416_((GuiEventListener)slider);
        return slider;
    }

    protected void drawControlBackground(GuiGraphics guiGraphics, int grayBoxX, int grayBoxY, int width, int height) {
        GuiUtils.bindAndDrawScaledTexture(this.backgroundTextures, guiGraphics, grayBoxX, grayBoxY, width, height, width, height, width, height);
    }

    protected void drawControlLeftPanel(GuiGraphics guiGraphics, int grayBoxX, int grayBoxY, int width, int height) {
        GuiUtils.drawContinuousTexturedBox(this.leftPanelTexture, grayBoxX, grayBoxY, 0, 0, width, height, 89, 233, 2, 2, 4, 4, 0.0f);
    }

    protected void drawControlMiddlePanel(GuiGraphics guiGraphics, int grayBoxX, int grayBoxY, int width, int height) {
        GuiUtils.drawContinuousTexturedBox(this.middlePanelTexture, grayBoxX, grayBoxY, 0, 0, width, height, 89, 233, 2, 2, 4, 4, 0.0f);
    }

    protected void drawControlRightPanel(GuiGraphics guiGraphics, int grayBoxX, int grayBoxY, int width, int height) {
        GuiUtils.drawContinuousTexturedBox(this.rightPanelTexture, grayBoxX, grayBoxY, 0, 0, width, height, 89, 233, 2, 2, 4, 4, 0.0f);
    }

    protected void drawStandardControlBoxAndImage(GuiGraphics guiGraphics, ResourceLocation imageLocation, int x, int y, int mouseX, int mouseY, float partialTicks) {
        this.m_280273_(guiGraphics);
        this.drawControlBackground(guiGraphics, x, y, this.imagePanelWidth, this.imagePanelHeight);
        if (imageLocation != null) {
            int imagePanelMiddle = this.imagePanelWidth / 2;
            int middleOfImage = this.shownImageWidth / 2;
            int imagePos = x + (imagePanelMiddle - middleOfImage - 5);
            GuiUtils.bindAndDrawTexture(imageLocation, guiGraphics, imagePos, y + 10, 1, this.shownImageWidth, this.shownImageHeight, this.shownImageWidth, this.shownImageHeight);
        }
    }

    protected void renderButtons(GuiGraphics guiGraphics, int mouseX, int mouseY) {
        for (GuiEventListener widget : this.m_6702_()) {
            if (!(widget instanceof AbstractWidget)) continue;
            AbstractWidget currentButton = (AbstractWidget)widget;
            if (!currentButton.f_93624_) continue;
            currentButton.m_88315_(guiGraphics, mouseX, mouseY, this.getMinecraft().m_91296_());
        }
    }

    protected Tuple<Integer, Integer> getAdjustedXYValue() {
        return new Tuple<Integer, Integer>(this.getCenteredXAxis() - this.modifiedInitialXAxis, this.getCenteredYAxis() - this.modifiedInitialYAxis);
    }

    public int drawString(GuiGraphics guiGraphics, String text, float x, float y, int color) {
        guiGraphics.m_280554_(this.f_96547_, (FormattedText)Utils.createTextComponent(text), (int)x, (int)y, 9999, color);
        return 0;
    }

    public void drawSplitString(GuiGraphics guiGraphics, String str, int x, int y, int wrapWidth) {
        guiGraphics.m_280554_(this.f_96547_, (FormattedText)Utils.createTextComponent(str), x, y, wrapWidth, this.textColor);
    }

    public List<FormattedCharSequence> getSplitString(String str, int wrapWidth) {
        return this.getFontRenderer().m_92923_((FormattedText)Utils.createTextComponent(str), wrapWidth);
    }

    public List<FormattedCharSequence> getSplitString(FormattedText str, int wrapWidth) {
        return this.getFontRenderer().m_92923_(str, wrapWidth);
    }

    public void closeScreen() {
        this.getMinecraft().m_91152_(null);
    }

    @NotNull
    public Minecraft getMinecraft() {
        assert (this.f_96541_ != null);
        return this.f_96541_;
    }

    public Font getFontRenderer() {
        return this.getMinecraft().f_91062_;
    }

    public abstract void buttonClicked(AbstractButton var1);

    protected abstract void preButtonRender(GuiGraphics var1, int var2, int var3, int var4, int var5, float var6);

    protected abstract void postButtonRender(GuiGraphics var1, int var2, int var3, int var4, int var5, float var6);
}

