/*
 * Decompiled with CFR 0.152.
 */
package com.wuest.prefab.structures.base;

import com.wuest.prefab.ModRegistry;
import com.wuest.prefab.Triple;
import com.wuest.prefab.Tuple;
import com.wuest.prefab.blocks.FullDyeColor;
import com.wuest.prefab.config.ModConfiguration;
import com.wuest.prefab.proxy.CommonProxy;
import java.util.ArrayList;
import java.util.Collection;
import net.minecraft.core.BlockPos;
import net.minecraft.core.Direction;
import net.minecraft.network.protocol.Packet;
import net.minecraft.resources.ResourceKey;
import net.minecraft.server.level.ServerLevel;
import net.minecraft.world.entity.Entity;
import net.minecraft.world.entity.player.Player;
import net.minecraft.world.item.DyeColor;
import net.minecraft.world.item.Item;
import net.minecraft.world.item.ItemStack;
import net.minecraft.world.item.Items;
import net.minecraft.world.level.BlockGetter;
import net.minecraft.world.level.ItemLike;
import net.minecraft.world.level.Level;
import net.minecraft.world.level.LevelAccessor;
import net.minecraft.world.level.block.BedBlock;
import net.minecraft.world.level.block.Block;
import net.minecraft.world.level.block.Blocks;
import net.minecraft.world.level.block.ChestBlock;
import net.minecraft.world.level.block.LadderBlock;
import net.minecraft.world.level.block.LiquidBlock;
import net.minecraft.world.level.block.entity.BlockEntity;
import net.minecraft.world.level.block.entity.ChestBlockEntity;
import net.minecraft.world.level.block.entity.FurnaceBlockEntity;
import net.minecraft.world.level.block.entity.RandomizableContainerBlockEntity;
import net.minecraft.world.level.block.state.BlockState;
import net.minecraft.world.level.block.state.properties.BedPart;
import net.minecraft.world.level.block.state.properties.Property;
import net.minecraftforge.common.MinecraftForge;
import net.minecraftforge.common.util.BlockSnapshot;
import net.minecraftforge.event.level.BlockEvent;
import net.minecraftforge.eventbus.api.Event;

public class BuildingMethods {
    public static ArrayList<ItemStack> ConsolidateDrops(ServerLevel world, BlockPos pos, BlockState state, ArrayList<ItemStack> originalStacks, ArrayList<Item> itemsToNotAdd) {
        for (ItemStack stack : Block.m_49869_((BlockState)state, (ServerLevel)world, (BlockPos)pos, null)) {
            if (itemsToNotAdd != null && itemsToNotAdd.contains(stack.m_41720_())) continue;
            boolean foundStack = false;
            for (ItemStack existingStack : originalStacks) {
                if (!ItemStack.m_41656_((ItemStack)existingStack, (ItemStack)stack) || existingStack.m_41613_() + stack.m_41613_() > stack.m_41741_()) continue;
                existingStack.m_41764_(existingStack.m_41613_() + stack.m_41613_());
                foundStack = true;
                break;
            }
            if (foundStack) continue;
            originalStacks.add(stack);
        }
        return originalStacks;
    }

    public static ArrayList<ItemStack> CreateWall(ServerLevel world, int height, int length, Direction direction, BlockPos startingPosition, Block replacementBlock, ArrayList<Item> itemsToNotAdd) {
        ArrayList<ItemStack> itemsDropped = new ArrayList<ItemStack>();
        for (int i = 0; i < height; ++i) {
            BlockPos wallPos = startingPosition.m_6630_(i);
            for (int j = 0; j < length; ++j) {
                BlockState currentBlockPosState = world.m_8055_(wallPos);
                for (ItemStack stack : Block.m_49869_((BlockState)currentBlockPosState, (ServerLevel)world, (BlockPos)wallPos, null)) {
                    if (itemsToNotAdd != null && itemsToNotAdd.contains(stack.m_41720_())) continue;
                    itemsDropped.add(stack);
                }
                BuildingMethods.ReplaceBlock((Level)world, wallPos, replacementBlock);
                wallPos = wallPos.m_121945_(direction);
            }
        }
        return itemsDropped;
    }

    public static ArrayList<ItemStack> SetFloor(ServerLevel world, BlockPos pos, Block block, int width, int depth, ArrayList<ItemStack> originalStack, Direction facing, ArrayList<Item> itemsToNotAdd) {
        for (int i = 0; i < width; ++i) {
            originalStack.addAll(BuildingMethods.CreateWall(world, 1, depth, facing, pos, block, itemsToNotAdd));
            pos = pos.m_121945_(facing.m_122427_());
        }
        return originalStack;
    }

    public static void ReplaceBlock(Level world, BlockPos pos, Block replacementBlock) {
        BuildingMethods.ReplaceBlock(world, pos, replacementBlock.m_49966_(), 3);
    }

    public static void ReplaceBlockNoAir(Level world, BlockPos pos, Block replacementBlock) {
        BuildingMethods.ReplaceBlockNoAir(world, pos, replacementBlock.m_49966_(), 3);
    }

    public static void ReplaceBlock(Level world, BlockPos pos, BlockState replacementBlockState) {
        BuildingMethods.ReplaceBlock(world, pos, replacementBlockState, 3);
    }

    public static void ReplaceBlock(Level world, BlockPos pos, BlockState replacementBlockState, int flags) {
        world.m_7471_(pos, false);
        world.m_7731_(pos, replacementBlockState, flags);
    }

    public static void ReplaceBlockNoAir(Level world, BlockPos pos, BlockState replacementBlockState, int flags) {
        world.m_7731_(pos, replacementBlockState, flags);
    }

    public static Triple<Boolean, BlockState, BlockPos> CheckBuildSpaceForAllowedBlockReplacement(ServerLevel world, BlockPos startBlockPos, BlockPos endBlockPos, Player player) {
        if (!world.m_5776_()) {
            for (BlockPos currentPos : BlockPos.m_121940_((BlockPos)startBlockPos, (BlockPos)endBlockPos)) {
                BlockEvent.BreakEvent breakEvent;
                BlockState blockState = world.m_8055_(currentPos);
                if (world.m_7654_().m_7762_(world, currentPos, player)) {
                    return new Triple<Boolean, BlockState, BlockPos>(false, blockState, currentPos);
                }
                if (!world.m_46859_(currentPos) && MinecraftForge.EVENT_BUS.post((Event)(breakEvent = new BlockEvent.BreakEvent((Level)world, currentPos, world.m_8055_(currentPos), player)))) {
                    return new Triple<Boolean, BlockState, BlockPos>(false, blockState, currentPos);
                }
                BlockEvent.EntityPlaceEvent placeEvent = new BlockEvent.EntityPlaceEvent(BlockSnapshot.create((ResourceKey)world.m_46472_(), (LevelAccessor)world, (BlockPos)currentPos), Blocks.f_50016_.m_49966_(), (Entity)player);
                if (MinecraftForge.EVENT_BUS.post((Event)placeEvent)) {
                    return new Triple<Boolean, BlockState, BlockPos>(false, blockState, currentPos);
                }
                if (!(blockState.m_60800_((BlockGetter)world, currentPos) < 0.0f)) continue;
                return new Triple<Boolean, BlockState, BlockPos>(false, blockState, currentPos);
            }
        }
        return new Triple<Boolean, Object, Object>(true, null, null);
    }

    public static void PlaceColoredBed(Level world, BlockPos bedHeadPos, BlockPos bedFootPos, DyeColor bedColor) {
        Tuple<BlockState, BlockState> bedStates = BuildingMethods.getBedState(bedHeadPos, bedFootPos, bedColor);
        BuildingMethods.ReplaceBlock(world, bedHeadPos, bedStates.getFirst());
        BuildingMethods.ReplaceBlock(world, bedFootPos, bedStates.getSecond());
    }

    public static Tuple<BlockState, BlockState> getBedState(BlockPos bedHeadPos, BlockPos bedFootPos, DyeColor bedColor) {
        BlockState bedHead = null;
        BlockState bedFoot = null;
        switch (bedColor) {
            case BLACK: {
                bedHead = (BlockState)Blocks.f_50029_.m_49966_().m_61124_((Property)BedBlock.f_49440_, (Comparable)BedPart.HEAD);
                bedFoot = Blocks.f_50029_.m_49966_();
                break;
            }
            case BLUE: {
                bedHead = (BlockState)Blocks.f_50025_.m_49966_().m_61124_((Property)BedBlock.f_49440_, (Comparable)BedPart.HEAD);
                bedFoot = Blocks.f_50025_.m_49966_();
                break;
            }
            case BROWN: {
                bedHead = (BlockState)Blocks.f_50026_.m_49966_().m_61124_((Property)BedBlock.f_49440_, (Comparable)BedPart.HEAD);
                bedFoot = Blocks.f_50026_.m_49966_();
                break;
            }
            case CYAN: {
                bedHead = (BlockState)Blocks.f_50023_.m_49966_().m_61124_((Property)BedBlock.f_49440_, (Comparable)BedPart.HEAD);
                bedFoot = Blocks.f_50023_.m_49966_();
                break;
            }
            case GRAY: {
                bedHead = (BlockState)Blocks.f_50021_.m_49966_().m_61124_((Property)BedBlock.f_49440_, (Comparable)BedPart.HEAD);
                bedFoot = Blocks.f_50021_.m_49966_();
                break;
            }
            case GREEN: {
                bedHead = (BlockState)Blocks.f_50027_.m_49966_().m_61124_((Property)BedBlock.f_49440_, (Comparable)BedPart.HEAD);
                bedFoot = Blocks.f_50027_.m_49966_();
                break;
            }
            case LIGHT_BLUE: {
                bedHead = (BlockState)Blocks.f_50017_.m_49966_().m_61124_((Property)BedBlock.f_49440_, (Comparable)BedPart.HEAD);
                bedFoot = Blocks.f_50017_.m_49966_();
                break;
            }
            case LIGHT_GRAY: {
                bedHead = (BlockState)Blocks.f_50022_.m_49966_().m_61124_((Property)BedBlock.f_49440_, (Comparable)BedPart.HEAD);
                bedFoot = Blocks.f_50022_.m_49966_();
                break;
            }
            case LIME: {
                bedHead = (BlockState)Blocks.f_50019_.m_49966_().m_61124_((Property)BedBlock.f_49440_, (Comparable)BedPart.HEAD);
                bedFoot = Blocks.f_50019_.m_49966_();
                break;
            }
            case MAGENTA: {
                bedHead = (BlockState)Blocks.f_50068_.m_49966_().m_61124_((Property)BedBlock.f_49440_, (Comparable)BedPart.HEAD);
                bedFoot = Blocks.f_50068_.m_49966_();
                break;
            }
            case ORANGE: {
                bedHead = (BlockState)Blocks.f_50067_.m_49966_().m_61124_((Property)BedBlock.f_49440_, (Comparable)BedPart.HEAD);
                bedFoot = Blocks.f_50067_.m_49966_();
                break;
            }
            case PINK: {
                bedHead = (BlockState)Blocks.f_50020_.m_49966_().m_61124_((Property)BedBlock.f_49440_, (Comparable)BedPart.HEAD);
                bedFoot = Blocks.f_50020_.m_49966_();
                break;
            }
            case PURPLE: {
                bedHead = (BlockState)Blocks.f_50024_.m_49966_().m_61124_((Property)BedBlock.f_49440_, (Comparable)BedPart.HEAD);
                bedFoot = Blocks.f_50024_.m_49966_();
                break;
            }
            case RED: {
                bedHead = (BlockState)Blocks.f_50028_.m_49966_().m_61124_((Property)BedBlock.f_49440_, (Comparable)BedPart.HEAD);
                bedFoot = Blocks.f_50028_.m_49966_();
                break;
            }
            case WHITE: {
                bedHead = (BlockState)Blocks.f_50066_.m_49966_().m_61124_((Property)BedBlock.f_49440_, (Comparable)BedPart.HEAD);
                bedFoot = Blocks.f_50066_.m_49966_();
                break;
            }
            case YELLOW: {
                bedHead = (BlockState)Blocks.f_50018_.m_49966_().m_61124_((Property)BedBlock.f_49440_, (Comparable)BedPart.HEAD);
                bedFoot = Blocks.f_50018_.m_49966_();
            }
        }
        Direction direction = Direction.NORTH;
        BlockPos tempPos = bedHeadPos.m_121945_(Direction.NORTH);
        while (tempPos.m_123341_() != bedFootPos.m_123341_() || tempPos.m_123343_() != bedFootPos.m_123343_()) {
            direction = direction.m_122427_();
            tempPos = bedHeadPos.m_121945_(direction);
        }
        bedHead = (BlockState)bedHead.m_61124_((Property)BedBlock.f_54117_, (Comparable)direction.m_122424_());
        bedFoot = (BlockState)bedFoot.m_61124_((Property)BedBlock.f_54117_, (Comparable)direction.m_122424_());
        return new Tuple<BlockState, BlockState>(bedHead, bedFoot);
    }

    public static void FillChest(Level world, BlockPos itemPosition) {
        BlockEntity tileEntity = world.m_7702_(itemPosition);
        if (tileEntity instanceof RandomizableContainerBlockEntity) {
            RandomizableContainerBlockEntity chestTile = (RandomizableContainerBlockEntity)tileEntity;
            int itemSlot = 0;
            if (CommonProxy.proxyConfiguration.serverConfiguration.addAxe) {
                chestTile.m_6836_(itemSlot++, new ItemStack((ItemLike)Items.f_42428_));
            }
            if (CommonProxy.proxyConfiguration.serverConfiguration.addHoe) {
                chestTile.m_6836_(itemSlot++, new ItemStack((ItemLike)Items.f_42429_));
            }
            if (CommonProxy.proxyConfiguration.serverConfiguration.addPickAxe) {
                chestTile.m_6836_(itemSlot++, new ItemStack((ItemLike)Items.f_42427_));
            }
            if (CommonProxy.proxyConfiguration.serverConfiguration.addShovel) {
                chestTile.m_6836_(itemSlot++, new ItemStack((ItemLike)Items.f_42426_));
            }
            if (CommonProxy.proxyConfiguration.serverConfiguration.addSword) {
                Item sword = (Item)ModRegistry.SwiftBladeStone.get();
                if (!CommonProxy.proxyConfiguration.serverConfiguration.recipeConfiguration.get(ModConfiguration.SwiftBladeKey).booleanValue()) {
                    sword = Items.f_42425_;
                }
                chestTile.m_6836_(itemSlot++, new ItemStack((ItemLike)sword));
            }
            if (CommonProxy.proxyConfiguration.serverConfiguration.addArmor) {
                chestTile.m_6836_(itemSlot++, new ItemStack((ItemLike)Items.f_42463_));
                chestTile.m_6836_(itemSlot++, new ItemStack((ItemLike)Items.f_42408_));
                chestTile.m_6836_(itemSlot++, new ItemStack((ItemLike)Items.f_42407_));
                chestTile.m_6836_(itemSlot++, new ItemStack((ItemLike)Items.f_42462_));
            }
            if (CommonProxy.proxyConfiguration.serverConfiguration.addFood) {
                chestTile.m_6836_(itemSlot++, new ItemStack((ItemLike)Items.f_42406_, 20));
            }
            if (CommonProxy.proxyConfiguration.serverConfiguration.addCrops) {
                chestTile.m_6836_(itemSlot++, new ItemStack((ItemLike)Items.f_42620_, 3));
                chestTile.m_6836_(itemSlot++, new ItemStack((ItemLike)Items.f_42619_, 3));
                chestTile.m_6836_(itemSlot++, new ItemStack((ItemLike)Items.f_42404_, 3));
            }
            if (CommonProxy.proxyConfiguration.serverConfiguration.addCobble) {
                chestTile.m_6836_(itemSlot++, new ItemStack((ItemLike)Item.m_41439_((Block)Blocks.f_50652_), 64));
            }
            if (CommonProxy.proxyConfiguration.serverConfiguration.addDirt) {
                chestTile.m_6836_(itemSlot++, new ItemStack((ItemLike)Item.m_41439_((Block)Blocks.f_50493_), 64));
            }
            if (CommonProxy.proxyConfiguration.serverConfiguration.addSaplings) {
                chestTile.m_6836_(itemSlot++, new ItemStack((ItemLike)Item.m_41439_((Block)Blocks.f_50746_), 3));
            }
            if (CommonProxy.proxyConfiguration.serverConfiguration.addTorches) {
                chestTile.m_6836_(itemSlot, new ItemStack((ItemLike)Item.m_41439_((Block)Blocks.f_50081_), 20));
            }
            chestTile.m_6596_();
            Packet packet = chestTile.m_58483_();
            if (packet != null) {
                world.m_7654_().m_6846_().m_11268_(packet);
            }
        }
    }

    public static void FillFurnaces(Level world, ArrayList<BlockPos> furnacePositions) {
        if (furnacePositions != null && furnacePositions.size() > 0) {
            for (BlockPos furnacePos : furnacePositions) {
                BlockEntity tileEntity = world.m_7702_(furnacePos);
                if (!(tileEntity instanceof FurnaceBlockEntity)) continue;
                FurnaceBlockEntity furnaceTile = (FurnaceBlockEntity)tileEntity;
                furnaceTile.m_6836_(1, new ItemStack((ItemLike)Items.f_42413_, 20));
            }
        }
    }

    public static void PlaceMineShaft(ServerLevel world, BlockPos pos, Direction facing, boolean onlyGatherOres) {
        ArrayList<ItemStack> stacks = new ArrayList<ItemStack>();
        ArrayList<Item> blocksToNotAdd = new ArrayList<Item>();
        if (onlyGatherOres) {
            blocksToNotAdd.add(Item.m_41439_((Block)Blocks.f_49992_));
            blocksToNotAdd.add(Item.m_41439_((Block)Blocks.f_50062_));
            blocksToNotAdd.add(Item.m_41439_((Block)Blocks.f_50652_));
            blocksToNotAdd.add(Item.m_41439_((Block)Blocks.f_50069_));
            blocksToNotAdd.add(Item.m_41439_((Block)Blocks.f_50493_));
            blocksToNotAdd.add(Item.m_41439_((Block)Blocks.f_50122_));
            blocksToNotAdd.add(Item.m_41439_((Block)Blocks.f_50334_));
            blocksToNotAdd.add(Item.m_41439_((Block)Blocks.f_50228_));
            blocksToNotAdd.add(Item.m_41439_((Block)Blocks.f_49993_));
            blocksToNotAdd.add(Item.m_41439_((Block)Blocks.f_50394_));
            blocksToNotAdd.add(Item.m_41439_((Block)Blocks.f_50079_));
            blocksToNotAdd.add(Item.m_41439_((Block)Blocks.f_50223_));
        }
        int minimumHeightForMineshaft = world.m_141937_() + 21;
        Triple<ArrayList<ItemStack>, ArrayList<BlockPos>, ArrayList<BlockPos>> ladderShaftResults = BuildingMethods.CreateLadderShaft(world, pos, stacks, facing, blocksToNotAdd, minimumHeightForMineshaft);
        ArrayList<BlockPos> blockPositions = new ArrayList<BlockPos>((Collection)ladderShaftResults.getThird());
        stacks = ladderShaftResults.getFirst();
        ArrayList<BlockPos> torchPositions = ladderShaftResults.getSecond();
        pos = pos.m_6625_(pos.m_123342_() - minimumHeightForMineshaft);
        ArrayList<ItemStack> tempStacks = new ArrayList<ItemStack>();
        BlockPos ceilingLevel = pos.m_6630_(4);
        BuildingMethods.SetFloor(world, ceilingLevel.m_5484_(facing, 2).m_5484_(facing.m_122427_(), 2).m_121945_(facing.m_122424_()), Blocks.f_50069_, 4, 4, tempStacks, facing.m_122424_(), blocksToNotAdd);
        BuildingMethods.ReplaceBlock((Level)world, ceilingLevel, (BlockState)Blocks.f_50155_.m_49966_().m_61124_((Property)LadderBlock.f_54337_, (Comparable)facing), 2);
        blockPositions.add(ceilingLevel);
        BlockState torchState = Blocks.f_50081_.m_49966_();
        for (BlockPos torchPos : torchPositions) {
            BlockState surroundingState = world.m_8055_(torchPos);
            Block surroundingBlock = surroundingState.m_60734_();
            BuildingMethods.ConsolidateDrops(world, torchPos, surroundingState, tempStacks, blocksToNotAdd);
            BuildingMethods.ReplaceBlock((Level)world, torchPos, torchState, 2);
            blockPositions.add(torchPos);
        }
        tempStacks.addAll(BuildingMethods.SetFloor(world, pos.m_121945_(facing).m_121945_(facing.m_122427_()), Blocks.f_50069_, 3, 4, tempStacks, facing.m_122424_(), blocksToNotAdd));
        for (int i = 0; i < tempStacks.size(); ++i) {
            ItemStack stack = tempStacks.get(i);
            if (stack.m_41720_() != Item.m_41439_((Block)Blocks.f_50155_)) continue;
            tempStacks.remove(i);
            --i;
        }
        pos = pos.m_7494_();
        tempStacks.addAll(BuildingMethods.CreateWall(world, 3, 3, facing.m_122427_(), pos.m_5484_(facing.m_122424_(), 2).m_121945_(facing.m_122428_()), Blocks.f_50016_, blocksToNotAdd));
        tempStacks.addAll(BuildingMethods.CreateWall(world, 3, 3, facing.m_122427_(), pos.m_5484_(facing.m_122424_(), 3).m_121945_(facing.m_122428_()), Blocks.f_50069_, blocksToNotAdd));
        tempStacks.addAll(BuildingMethods.CreateWall(world, 3, 4, facing, pos.m_5484_(facing.m_122424_(), 2).m_121945_(facing.m_122427_()), Blocks.f_50016_, blocksToNotAdd));
        tempStacks.addAll(BuildingMethods.CreateWall(world, 3, 4, facing, pos.m_5484_(facing.m_122424_(), 2).m_5484_(facing.m_122427_(), 2), Blocks.f_50069_, blocksToNotAdd));
        tempStacks.addAll(BuildingMethods.CreateWall(world, 3, 3, facing.m_122428_(), pos.m_121945_(facing).m_121945_(facing.m_122427_()), Blocks.f_50016_, blocksToNotAdd));
        tempStacks.addAll(BuildingMethods.CreateWall(world, 3, 3, facing.m_122428_(), pos.m_5484_(facing, 2).m_121945_(facing.m_122427_()), Blocks.f_50069_, blocksToNotAdd));
        tempStacks.addAll(BuildingMethods.CreateWall(world, 3, 4, facing.m_122424_(), pos.m_121945_(facing).m_121945_(facing.m_122428_()), Blocks.f_50016_, blocksToNotAdd));
        tempStacks.addAll(BuildingMethods.CreateWall(world, 3, 4, facing.m_122424_(), pos.m_5484_(facing, 1).m_5484_(facing.m_122428_(), 2), Blocks.f_50069_, blocksToNotAdd));
        for (ItemStack tempStack : tempStacks) {
            boolean foundStack = false;
            for (ItemStack existingStack : stacks) {
                if (!ItemStack.m_41656_((ItemStack)existingStack, (ItemStack)tempStack) || existingStack.m_41613_() + tempStack.m_41613_() > tempStack.m_41741_()) continue;
                existingStack.m_41764_(existingStack.m_41613_() + tempStack.m_41613_());
                foundStack = true;
                break;
            }
            if (foundStack) continue;
            stacks.add(tempStack);
        }
        BlockState blockState = Blocks.f_50081_.m_49966_();
        BuildingMethods.ReplaceBlock((Level)world, pos.m_121945_(facing.m_122428_()), blockState);
        if (CommonProxy.proxyConfiguration.serverConfiguration.includeMineshaftChest) {
            BlockState chestState = (BlockState)Blocks.f_50087_.m_49966_().m_61124_((Property)ChestBlock.f_51478_, (Comparable)facing);
            BuildingMethods.ReplaceBlock((Level)world, pos.m_121945_(facing.m_122427_()), chestState, 2);
            blockPositions.add(pos.m_121945_(facing.m_122427_()));
            if (stacks.size() > 27) {
                BuildingMethods.ReplaceBlock((Level)world, pos.m_121945_(facing.m_122427_()).m_121945_(facing.m_122424_()), chestState, 2);
                blockPositions.add(pos.m_121945_(facing.m_122427_()).m_121945_(facing.m_122424_()));
            }
            BlockEntity tileEntity = world.m_7702_(pos.m_121945_(facing.m_122427_()));
            BlockEntity tileEntity2 = world.m_7702_(pos.m_121945_(facing.m_122427_()).m_121945_(facing.m_122424_()));
            if (tileEntity instanceof ChestBlockEntity) {
                ChestBlockEntity chestTile = (ChestBlockEntity)tileEntity;
                ChestBlockEntity chestTile2 = (ChestBlockEntity)tileEntity2;
                int i = 0;
                boolean fillSecond = false;
                for (ItemStack stack : stacks) {
                    if (i == 27 && !fillSecond) {
                        fillSecond = true;
                        i = 0;
                        chestTile = chestTile2;
                    }
                    if (i >= 27 && fillSecond) break;
                    chestTile.m_6836_(i, stack);
                    ++i;
                }
            }
        }
        for (BlockPos currentPos : blockPositions) {
            Block block = world.m_8055_(pos).m_60734_();
            world.m_6289_(pos, block);
        }
    }

    private static Triple<ArrayList<ItemStack>, ArrayList<BlockPos>, ArrayList<BlockPos>> CreateLadderShaft(ServerLevel world, BlockPos pos, ArrayList<ItemStack> originalStacks, Direction houseFacing, ArrayList<Item> blocksToNotAdd, int minimumHeightForMineshaft) {
        int torchCounter = 0;
        Direction westWall = houseFacing.m_122428_();
        BlockState ladderState = (BlockState)Blocks.f_50155_.m_49966_().m_61124_((Property)LadderBlock.f_54337_, (Comparable)houseFacing);
        BuildingMethods.ReplaceBlock((Level)world, pos, Blocks.f_50016_);
        ArrayList<BlockPos> torchPositions = new ArrayList<BlockPos>();
        ArrayList<BlockPos> allBlockPositions = new ArrayList<BlockPos>();
        int lastHeightForTorch = minimumHeightForMineshaft + 6;
        while (pos.m_123342_() > minimumHeightForMineshaft) {
            BlockState state = world.m_8055_(pos);
            Block block = state.m_60734_();
            ++torchCounter;
            for (int i = 0; i < 4; ++i) {
                Direction facing = switch (i) {
                    case 1 -> houseFacing.m_122427_();
                    case 2 -> houseFacing.m_122424_();
                    case 3 -> houseFacing.m_122428_();
                    default -> houseFacing;
                };
                if (facing == westWall && torchCounter == 6 && pos.m_123342_() > lastHeightForTorch) {
                    for (int j = 0; j <= 2; ++j) {
                        Block surroundingBlock;
                        BlockState surroundingState;
                        BlockPos tempPos;
                        if (j == 0) {
                            tempPos = pos.m_5484_(facing, 2);
                            surroundingState = world.m_8055_(tempPos);
                            surroundingBlock = surroundingState.m_60734_();
                        } else if (j == 1) {
                            tempPos = pos.m_121945_(facing).m_121945_(facing.m_122427_());
                            surroundingState = world.m_8055_(tempPos);
                            surroundingBlock = surroundingState.m_60734_();
                        } else {
                            tempPos = pos.m_121945_(facing).m_121945_(facing.m_122428_());
                            surroundingState = world.m_8055_(tempPos);
                            surroundingBlock = surroundingState.m_60734_();
                        }
                        if (surroundingBlock == Blocks.f_50069_ || surroundingBlock == Blocks.f_50334_ || surroundingBlock == Blocks.f_50228_ || surroundingBlock == Blocks.f_50122_) continue;
                        originalStacks = BuildingMethods.ConsolidateDrops(world, tempPos, surroundingState, originalStacks, blocksToNotAdd);
                        BuildingMethods.ReplaceBlock((Level)world, tempPos, Blocks.f_50069_.m_49966_(), 2);
                        allBlockPositions.add(tempPos);
                    }
                    torchPositions.add(pos.m_121945_(facing));
                    torchCounter = 0;
                    continue;
                }
                BlockPos tempPos = pos.m_121945_(facing);
                BlockState surroundingState = world.m_8055_(tempPos);
                Block surroundingBlock = surroundingState.m_60734_();
                if (surroundingState.m_60796_((BlockGetter)world, tempPos) && !(surroundingBlock instanceof LiquidBlock)) continue;
                originalStacks = BuildingMethods.ConsolidateDrops(world, tempPos, surroundingState, originalStacks, blocksToNotAdd);
                BuildingMethods.ReplaceBlock((Level)world, tempPos, Blocks.f_50069_.m_49966_(), 2);
                allBlockPositions.add(tempPos);
            }
            originalStacks = BuildingMethods.ConsolidateDrops(world, pos, state, originalStacks, blocksToNotAdd);
            if (pos.m_123342_() >= minimumHeightForMineshaft) {
                BuildingMethods.ReplaceBlock((Level)world, pos, ladderState, 2);
                allBlockPositions.add(pos);
            }
            pos = pos.m_7495_();
        }
        return new Triple<ArrayList<ItemStack>, ArrayList<BlockPos>, ArrayList<BlockPos>>(originalStacks, torchPositions, allBlockPositions);
    }

    public static BlockState getStainedGlassBlock(FullDyeColor color) {
        switch (color) {
            case BLACK: {
                return Blocks.f_50215_.m_49966_();
            }
            case BLUE: {
                return Blocks.f_50211_.m_49966_();
            }
            case BROWN: {
                return Blocks.f_50212_.m_49966_();
            }
            case GRAY: {
                return Blocks.f_50207_.m_49966_();
            }
            case GREEN: {
                return Blocks.f_50213_.m_49966_();
            }
            case LIGHT_BLUE: {
                return Blocks.f_50203_.m_49966_();
            }
            case LIGHT_GRAY: {
                return Blocks.f_50208_.m_49966_();
            }
            case LIME: {
                return Blocks.f_50205_.m_49966_();
            }
            case MAGENTA: {
                return Blocks.f_50202_.m_49966_();
            }
            case ORANGE: {
                return Blocks.f_50148_.m_49966_();
            }
            case PINK: {
                return Blocks.f_50206_.m_49966_();
            }
            case PURPLE: {
                return Blocks.f_50210_.m_49966_();
            }
            case RED: {
                return Blocks.f_50214_.m_49966_();
            }
            case WHITE: {
                return Blocks.f_50147_.m_49966_();
            }
            case YELLOW: {
                return Blocks.f_50204_.m_49966_();
            }
            case CLEAR: {
                return Blocks.f_50058_.m_49966_();
            }
        }
        return Blocks.f_50209_.m_49966_();
    }

    public static BlockState getStainedGlassPaneBlock(FullDyeColor color) {
        switch (color) {
            case BLACK: {
                return Blocks.f_50371_.m_49966_();
            }
            case BLUE: {
                return Blocks.f_50367_.m_49966_();
            }
            case BROWN: {
                return Blocks.f_50368_.m_49966_();
            }
            case GRAY: {
                return Blocks.f_50363_.m_49966_();
            }
            case GREEN: {
                return Blocks.f_50369_.m_49966_();
            }
            case LIGHT_BLUE: {
                return Blocks.f_50306_.m_49966_();
            }
            case LIGHT_GRAY: {
                return Blocks.f_50364_.m_49966_();
            }
            case LIME: {
                return Blocks.f_50361_.m_49966_();
            }
            case MAGENTA: {
                return Blocks.f_50305_.m_49966_();
            }
            case ORANGE: {
                return Blocks.f_50304_.m_49966_();
            }
            case PINK: {
                return Blocks.f_50362_.m_49966_();
            }
            case PURPLE: {
                return Blocks.f_50366_.m_49966_();
            }
            case RED: {
                return Blocks.f_50370_.m_49966_();
            }
            case WHITE: {
                return Blocks.f_50303_.m_49966_();
            }
            case YELLOW: {
                return Blocks.f_50307_.m_49966_();
            }
            case CLEAR: {
                return Blocks.f_50185_.m_49966_();
            }
        }
        return Blocks.f_50365_.m_49966_();
    }
}

