/*
 * Decompiled with CFR 0.152.
 */
package com.wuest.prefab.structures.items;

import com.wuest.prefab.ModRegistry;
import com.wuest.prefab.Prefab;
import com.wuest.prefab.gui.GuiLangKeys;
import com.wuest.prefab.structures.gui.GuiBulldozer;
import com.wuest.prefab.structures.items.StructureItem;
import java.util.List;
import javax.annotation.Nullable;
import net.minecraft.client.gui.screens.Screen;
import net.minecraft.core.Direction;
import net.minecraft.nbt.CompoundTag;
import net.minecraft.nbt.Tag;
import net.minecraft.network.chat.Component;
import net.minecraft.world.InteractionHand;
import net.minecraft.world.InteractionResult;
import net.minecraft.world.entity.player.Player;
import net.minecraft.world.item.Item;
import net.minecraft.world.item.ItemStack;
import net.minecraft.world.item.TooltipFlag;
import net.minecraft.world.item.context.UseOnContext;
import net.minecraft.world.level.Level;
import net.minecraftforge.api.distmarker.Dist;
import net.minecraftforge.api.distmarker.OnlyIn;

public class ItemBulldozer
extends StructureItem {
    private boolean creativePowered = false;

    public ItemBulldozer() {
        super(new Item.Properties().m_41503_(4));
    }

    public ItemBulldozer(boolean creativePowered) {
        super(new Item.Properties());
        this.creativePowered = creativePowered;
    }

    @Override
    protected void Initialize() {
        ModRegistry.guiRegistrations.add(x -> this.RegisterGui(GuiBulldozer.class));
    }

    @Override
    public InteractionResult m_6225_(UseOnContext context) {
        if (context.m_43725_().m_5776_() && context.m_43719_() == Direction.UP && this.getPoweredValue(context.m_43723_(), context.m_43724_())) {
            Prefab.proxy.openGuiForItem(context);
            return InteractionResult.PASS;
        }
        return InteractionResult.FAIL;
    }

    @OnlyIn(value=Dist.CLIENT)
    public void m_7373_(ItemStack stack, @Nullable Level worldIn, List<Component> tooltip, TooltipFlag flagIn) {
        super.m_7373_(stack, worldIn, tooltip, flagIn);
        boolean advancedKeyDown = Screen.m_96638_();
        if (!advancedKeyDown) {
            tooltip.add((Component)GuiLangKeys.translateToComponent("prefab.gui.tooltip.shift"));
        } else if (this.getPoweredValue(stack)) {
            tooltip.add((Component)GuiLangKeys.translateToComponent("prefab.gui.tooltip.bulldozer_powered"));
        } else {
            tooltip.add((Component)GuiLangKeys.translateToComponent("prefab.gui.tooltip.bulldozer_unpowered"));
        }
    }

    @OnlyIn(value=Dist.CLIENT)
    public boolean m_5812_(ItemStack stack) {
        return this.getPoweredValue(stack) || super.m_5812_(stack);
    }

    private boolean getPoweredValue(Player player, InteractionHand hand) {
        ItemStack stack = player.m_21120_(hand);
        return this.getPoweredValue(stack);
    }

    private boolean getPoweredValue(ItemStack stack) {
        if (this.creativePowered) {
            return true;
        }
        if (stack.m_41720_() == ModRegistry.Bulldozer.get()) {
            if (stack.m_41783_() == null || stack.m_41783_().m_128456_()) {
                CompoundTag baseTag = new CompoundTag();
                CompoundTag prefabTag = new CompoundTag();
                baseTag.m_128365_("prefab", (Tag)prefabTag);
                prefabTag.m_128379_("powered", false);
                stack.m_41751_(baseTag);
            } else {
                CompoundTag customData = stack.m_41783_();
                if (customData != null) {
                    CompoundTag tag = customData.m_6426_();
                    if (tag.m_128441_("prefab")) {
                        CompoundTag prefabTag = tag.m_128469_("prefab");
                        if (prefabTag.m_128441_("powered")) {
                            return prefabTag.m_128471_("powered");
                        }
                    } else {
                        CompoundTag prefabTag = new CompoundTag();
                        tag.m_128365_("prefab", (Tag)prefabTag);
                        prefabTag.m_128379_("powered", false);
                        stack.m_41751_(tag);
                    }
                }
            }
        }
        return false;
    }

    public void setPoweredValue(ItemStack stack, boolean value) {
        CompoundTag baseTag = new CompoundTag();
        CompoundTag prefabTag = new CompoundTag();
        prefabTag.m_128379_("powered", value);
        baseTag.m_128365_("prefab", (Tag)prefabTag);
        stack.m_41751_(baseTag);
    }
}

