/*
 * Decompiled with CFR 0.152.
 */
package insane96mcp.progressivebosses.loot;

import com.google.gson.JsonDeserializationContext;
import com.google.gson.JsonObject;
import com.google.gson.JsonSerializationContext;
import insane96mcp.progressivebosses.module.dragon.DragonFeature;
import insane96mcp.progressivebosses.module.elderguardian.ElderGuardianFeature;
import insane96mcp.progressivebosses.module.wither.entity.PBWither;
import insane96mcp.progressivebosses.setup.PBLoot;
import net.minecraft.util.GsonHelper;
import net.minecraft.world.entity.Entity;
import net.minecraft.world.entity.boss.enderdragon.EnderDragon;
import net.minecraft.world.entity.monster.ElderGuardian;
import net.minecraft.world.level.storage.loot.IntRange;
import net.minecraft.world.level.storage.loot.LootContext;
import net.minecraft.world.level.storage.loot.predicates.LootItemCondition;
import net.minecraft.world.level.storage.loot.predicates.LootItemConditionType;

public class LvlCondition
implements LootItemCondition {
    final LootContext.EntityTarget entityTarget;
    final IntRange lvl;

    LvlCondition(LootContext.EntityTarget entityTarget, IntRange lvl) {
        this.entityTarget = entityTarget;
        this.lvl = lvl;
    }

    public LootItemConditionType m_7940_() {
        return (LootItemConditionType)PBLoot.LVL.get();
    }

    public boolean test(LootContext lootContext) {
        Entity entity = (Entity)lootContext.m_78953_(this.entityTarget.m_79003_());
        int lvl = -1;
        if (entity instanceof PBWither) {
            PBWither wither = (PBWither)entity;
            lvl = wither.getLvl();
        } else if (entity instanceof EnderDragon) {
            EnderDragon dragon = (EnderDragon)entity;
            lvl = DragonFeature.getDragonLvl(dragon);
        } else if (entity instanceof ElderGuardian) {
            ElderGuardian elderGuardian = (ElderGuardian)entity;
            lvl = ElderGuardianFeature.getGuardianLvl(elderGuardian);
        }
        if (lvl == -1) {
            return false;
        }
        return this.lvl.m_165028_(lootContext, lvl);
    }

    public static LootItemCondition.Builder withLvl(LootContext.EntityTarget entityTarget, IntRange lvl) {
        return () -> new LvlCondition(entityTarget, lvl);
    }

    public static class Serializer
    implements net.minecraft.world.level.storage.loot.Serializer<LvlCondition> {
        public void serialize(JsonObject jsonObject, LvlCondition lvlCondition, JsonSerializationContext jsonSerializationContext) {
            jsonObject.add("entity", jsonSerializationContext.serialize((Object)lvlCondition.entityTarget));
            jsonObject.add("lvl", jsonSerializationContext.serialize((Object)lvlCondition.lvl));
        }

        public LvlCondition deserialize(JsonObject jsonObject, JsonDeserializationContext jsonDeserializationContext) {
            IntRange intRange = (IntRange)GsonHelper.m_13836_((JsonObject)jsonObject, (String)"lvl", (JsonDeserializationContext)jsonDeserializationContext, IntRange.class);
            return new LvlCondition((LootContext.EntityTarget)GsonHelper.m_13836_((JsonObject)jsonObject, (String)"entity", (JsonDeserializationContext)jsonDeserializationContext, LootContext.EntityTarget.class), intRange);
        }
    }
}

