/*
 * Decompiled with CFR 0.152.
 */
package insane96mcp.progressivebosses.module.dragon;

import insane96mcp.insanelib.base.Feature;
import insane96mcp.insanelib.base.LoadFeature;
import insane96mcp.insanelib.base.Module;
import insane96mcp.insanelib.base.config.Config;
import insane96mcp.insanelib.util.MCUtils;
import insane96mcp.insanelib.util.ModNBTData;
import insane96mcp.progressivebosses.ProgressiveBosses;
import insane96mcp.progressivebosses.event.DragonPhaseEvent;
import insane96mcp.progressivebosses.module.dragon.corruptedendcrystal.CorruptedEndCrystal;
import insane96mcp.progressivebosses.module.dragon.data.AngerComponent;
import insane96mcp.progressivebosses.module.dragon.data.CrystalRespawnComponent;
import insane96mcp.progressivebosses.module.dragon.data.DragonDefinition;
import insane96mcp.progressivebosses.module.dragon.data.DragonDefinitionReloadListener;
import insane96mcp.progressivebosses.module.dragon.data.LootComponent;
import insane96mcp.progressivebosses.module.dragon.data.MinionComponent;
import insane96mcp.progressivebosses.module.dragon.data.PhaseChanger;
import insane96mcp.progressivebosses.module.dragon.phase.PBDragonHoldingPatternPhase;
import insane96mcp.progressivebosses.network.SyncDragonAnger;
import insane96mcp.progressivebosses.utils.LogHelper;
import java.util.List;
import java.util.Optional;
import java.util.UUID;
import javax.annotation.Nullable;
import net.minecraft.Util;
import net.minecraft.network.chat.Component;
import net.minecraft.resources.ResourceLocation;
import net.minecraft.server.level.ServerLevel;
import net.minecraft.server.level.ServerPlayer;
import net.minecraft.tags.ItemTags;
import net.minecraft.tags.TagKey;
import net.minecraft.util.Mth;
import net.minecraft.util.RandomSource;
import net.minecraft.world.damagesource.DamageSource;
import net.minecraft.world.entity.Entity;
import net.minecraft.world.entity.LivingEntity;
import net.minecraft.world.entity.ai.attributes.Attribute;
import net.minecraft.world.entity.ai.attributes.AttributeModifier;
import net.minecraft.world.entity.ai.attributes.Attributes;
import net.minecraft.world.entity.boss.enderdragon.EndCrystal;
import net.minecraft.world.entity.boss.enderdragon.EnderDragon;
import net.minecraft.world.entity.boss.enderdragon.phases.EnderDragonPhase;
import net.minecraft.world.entity.monster.Shulker;
import net.minecraft.world.entity.player.Player;
import net.minecraft.world.entity.projectile.ShulkerBullet;
import net.minecraft.world.item.Item;
import net.minecraft.world.item.Items;
import net.minecraft.world.level.Level;
import net.minecraft.world.level.dimension.end.EndDragonFight;
import net.minecraft.world.phys.AABB;
import net.minecraftforge.api.distmarker.Dist;
import net.minecraftforge.api.distmarker.OnlyIn;
import net.minecraftforge.event.TickEvent;
import net.minecraftforge.event.entity.EntityJoinLevelEvent;
import net.minecraftforge.event.entity.EntityLeaveLevelEvent;
import net.minecraftforge.event.entity.living.LivingEvent;
import net.minecraftforge.event.entity.living.LivingExperienceDropEvent;
import net.minecraftforge.event.entity.living.LivingHurtEvent;
import net.minecraftforge.event.entity.player.ItemTooltipEvent;
import net.minecraftforge.eventbus.api.SubscribeEvent;
import net.minecraftforge.fml.ModList;
import net.minecraftforge.registries.ForgeRegistries;

@LoadFeature(module="progressivebosses:ender_dragon")
public class DragonFeature
extends Feature {
    public static final TagKey<Item> DRAGON_INVULNERABLE = ItemTags.create((ResourceLocation)ResourceLocation.fromNamespaceAndPath((String)"progressivebosses", (String)"dragon_invulnerable"));
    public static ResourceLocation LEVEL;
    public static ResourceLocation PROCESSED;
    public static final UUID KNOCKBACK_REDUCTION_UUID;
    @Config(description="Crystals can no longer be destroyed by other explosions.")
    public static Boolean explosionImmuneCrystals;
    @Config(description="Enable some fixes for the Ender Dragon:\n - Small spikes with cages now generate with obsidian on the corners to prevent cheesing.\n - Dragon Head and Neck have been repositioned/resized correctly.\n - Dragon will now play the growl sound only 4 times/second when respawning and when sitting instead of 20/second (so your ears shouldn't blow up anymore)\n - When the crystals that respawn the dragon in the center are destroyed, the fire is extinguished\n - Ender Dragon can now rise and fall faster (somewhere around 1.14 the multiplier for the y speed was reduced to 0.01 instead of 0.1 https://bugs.mojang.com/browse/MC-272431)\n - Dragon is moved exactly at the center of the well when landed\n - Fixes players accumulating knockback when hit by the dragon and then launching like a rocket\n - Sets a portal cooldown to 4 years so she no longer goes through end gates")
    public static Boolean enableFixes;
    @Config(description="Adds a tooltip on the dragon egg to hint that it drops multiple times.")
    public static Boolean eggTooltip;
    public static byte dragonLvl;
    public static boolean spawnDragon;
    public static boolean preventAdvancement;

    public void init(Module module, boolean enabledByDefault, boolean canBeDisabled) {
        super.init(module, enabledByDefault, canBeDisabled);
        ProgressiveBosses.addClientPack("endergetic_integration", "Endergetic Expansion integration", () -> ModList.get().isLoaded("endergetic"));
        LEVEL = this.createDataKey("level");
        PROCESSED = this.createDataKey("processed");
    }

    public static boolean areFixesEnabled() {
        return Feature.isEnabled(DragonFeature.class) && enableFixes != false;
    }

    @SubscribeEvent
    public void levelTick(TickEvent.LevelTickEvent event) {
        if (!spawnDragon || event.level.f_46443_) {
            return;
        }
        ServerLevel level = (ServerLevel)event.level;
        if (level.m_8586_() == null || level.m_8586_().f_64072_ == null) {
            return;
        }
        if (level.m_46467_() % 40L == 16L) {
            List closePlayers = level.m_45976_(Player.class, new AABB(level.m_8586_().f_64072_).m_82377_(48.0, 32.0, 48.0));
            if (closePlayers.isEmpty()) {
                return;
            }
            level.m_8586_().m_64100_();
            spawnDragon = false;
            preventAdvancement = true;
        }
    }

    @Nullable
    public static Player getRandomPlayer(EnderDragon dragon, Level level, int range) {
        List players = level.m_45976_(Player.class, dragon.m_20191_().m_82400_((double)range));
        if (players.isEmpty()) {
            return null;
        }
        return (Player)players.get(Mth.m_216271_((RandomSource)level.f_46441_, (int)0, (int)(players.size() - 1)));
    }

    @SubscribeEvent
    public void onEntityJoinLevel(EntityJoinLevelEvent event) {
        if (!this.isEnabled() || event.getLevel().f_46443_) {
            return;
        }
        this.onDragonJoinLevel(event);
        Entity entity = event.getEntity();
        if (entity instanceof EnderDragon) {
            EnderDragon dragon2 = (EnderDragon)entity;
            ((ServerLevel)dragon2.m_9236_()).m_6907_().forEach(player -> SyncDragonAnger.sync(player, dragon2));
        } else {
            entity = event.getEntity();
            if (entity instanceof ServerPlayer) {
                ServerPlayer player2 = (ServerPlayer)entity;
                ((ServerLevel)player2.m_9236_()).m_8857_().forEach(dragon -> SyncDragonAnger.sync(player2, dragon));
            }
        }
    }

    public void onDragonJoinLevel(EntityJoinLevelEvent event) {
        EnderDragon dragon;
        Entity entity = event.getEntity();
        if (!(entity instanceof EnderDragon) || ((Boolean)ModNBTData.get((Entity)(dragon = (EnderDragon)entity), (ResourceLocation)PROCESSED, Boolean.class)).booleanValue()) {
            return;
        }
        if (enableFixes.booleanValue()) {
            dragon.m_287199_(Integer.MAX_VALUE);
            MCUtils.applyModifier((LivingEntity)dragon, (Attribute)Attributes.f_22278_, (UUID)KNOCKBACK_REDUCTION_UUID, (String)"Dragon no knockback", (double)1.0, (AttributeModifier.Operation)AttributeModifier.Operation.ADDITION, (boolean)true);
        }
        if (!ModNBTData.contains((Entity)dragon, (ResourceLocation)LEVEL)) {
            ModNBTData.put((Entity)dragon, (ResourceLocation)LEVEL, (Object)dragonLvl);
        } else {
            dragonLvl = (Byte)ModNBTData.get((Entity)dragon, (ResourceLocation)LEVEL, Byte.class);
        }
        DragonDefinition stats = DragonFeature.getDragonDefinition(dragon).orElse(null);
        if (stats == null) {
            LogHelper.warn("Failed to get Dragon Stats for level %s", dragonLvl);
            return;
        }
        stats.apply(dragon);
        dragon.m_6593_((Component)Component.m_237115_((String)(Util.m_137492_((String)"entity", (ResourceLocation)ForgeRegistries.ENTITY_TYPES.getKey((Object)dragon.m_6095_())) + "." + dragonLvl)));
        ModNBTData.put((Entity)dragon, (ResourceLocation)PROCESSED, (Object)true);
    }

    @SubscribeEvent
    public void onExpDrop(LivingExperienceDropEvent event) {
        EnderDragon dragon;
        block3: {
            block2: {
                LivingEntity livingEntity;
                if (!this.isEnabled() || !((livingEntity = event.getEntity()) instanceof EnderDragon)) break block2;
                dragon = (EnderDragon)livingEntity;
                if (event.getDroppedExperience() != 0) break block3;
            }
            return;
        }
        DragonFeature.getDragonDefinition(dragon).flatMap(definition -> definition.getComponent(LootComponent.class)).map(lootComponent -> lootComponent.xpDropped).ifPresent(xpDropped -> {
            if (event.getDroppedExperience() == Mth.m_14143_((float)960.0f) || event.getDroppedExperience() == Mth.m_14143_((float)40.0f)) {
                event.setDroppedExperience(Mth.m_14143_((float)((float)xpDropped.intValue() * 0.08f)));
            } else if (event.getDroppedExperience() == Mth.m_14143_((float)2400.0f) || event.getDroppedExperience() == Mth.m_14143_((float)100.0f)) {
                event.setDroppedExperience(Mth.m_14143_((float)((float)xpDropped.intValue() * 0.2f)));
            }
        });
    }

    @SubscribeEvent
    public void onEntityLeaveLevel(EntityLeaveLevelEvent event) {
        EnderDragon dragon;
        Entity entity;
        if (!(this.isEnabled() && (entity = event.getEntity()) instanceof EnderDragon && (dragon = (EnderDragon)entity).m_21224_())) {
            return;
        }
        List bullets = dragon.m_9236_().m_45976_(ShulkerBullet.class, dragon.m_20191_().m_82400_(128.0));
        bullets.forEach(Entity::m_146870_);
        List minions = dragon.m_9236_().m_6443_(Shulker.class, dragon.m_20191_().m_82400_(128.0), shulker -> shulker.getPersistentData().m_128441_("progressivebosses:dragon_minion"));
        minions.forEach(Entity::m_146870_);
    }

    @SubscribeEvent
    public void onUpdate(LivingEvent.LivingTickEvent event) {
        LivingEntity livingEntity;
        CrystalRespawnComponent.tickCrystalPhantom(event);
        if (!this.isEnabled() || !((livingEntity = event.getEntity()) instanceof EnderDragon)) {
            return;
        }
        EnderDragon dragon = (EnderDragon)livingEntity;
        DragonDefinition definition = DragonFeature.getDragonDefinition(dragon).orElse(null);
        if (definition == null) {
            return;
        }
        definition.tick(dragon);
        if (dragon.m_9236_().f_46443_) {
            AngerComponent.tickClient(dragon);
        }
    }

    @SubscribeEvent
    public void onSetPhase(DragonPhaseEvent.Change event) {
        if (!this.isEnabled()) {
            return;
        }
        EnderDragon dragon = event.getDragon();
        DragonDefinition definition = DragonFeature.getDragonDefinition(dragon).orElse(null);
        if (definition == null) {
            return;
        }
        definition.components.forEach(component -> component.onPhaseChange(event, dragon));
        if (event.getNewPhase() == EnderDragonPhase.f_31386_) {
            return;
        }
        if (event.getNewPhase() == EnderDragonPhase.f_31377_) {
            event.setNewPhase(PBDragonHoldingPatternPhase.getPhaseType());
        }
    }

    @SubscribeEvent
    public void onPhaseBegin(DragonPhaseEvent.Begin event) {
        if (!this.isEnabled()) {
            return;
        }
        DragonDefinition definition = DragonFeature.getDragonDefinition(event.getDragon()).orElse(null);
        if (definition == null) {
            return;
        }
        definition.components.forEach(component -> {
            if (component instanceof PhaseChanger) {
                PhaseChanger phaseChanger = (PhaseChanger)((Object)component);
                phaseChanger.onPhaseBegin(event, event.getDragon());
            }
        });
    }

    public static void onCrystalDestroyed(EndDragonFight fight, EndCrystal crystal, DamageSource damageSource) {
        ServerLevel serverLevel;
        block5: {
            block4: {
                Level level = crystal.m_9236_();
                if (!(level instanceof ServerLevel)) break block4;
                serverLevel = (ServerLevel)level;
                if (fight.m_288211_() != null) break block5;
            }
            return;
        }
        EnderDragon dragon = (EnderDragon)serverLevel.m_8791_(fight.m_288211_());
        if (dragon == null) {
            return;
        }
        DragonFeature.getDragonDefinition(dragon).ifPresent(dragonDefinition -> dragonDefinition.components.forEach(component -> component.onCrystalDestroyed(dragon, crystal, fight.m_64098_())));
    }

    @SubscribeEvent
    public void onLivingHurt(LivingHurtEvent event) {
        if (!this.isEnabled()) {
            return;
        }
        MinionComponent.onMinionHurt(event);
        CrystalRespawnComponent.onPhantomHurt(event);
        LivingEntity livingEntity = event.getEntity();
        if (!(livingEntity instanceof EnderDragon)) {
            return;
        }
        EnderDragon dragon = (EnderDragon)livingEntity;
        DragonFeature.getDragonDefinition(dragon).ifPresent(dragonDefinition -> dragonDefinition.components.forEach(component -> component.onLivingHurt(event, dragon)));
    }

    public void onDragonHurt(LivingHurtEvent event) {
    }

    public static Optional<DragonDefinition> getDragonDefinition(EnderDragon dragon) {
        return DragonFeature.getDragonDefinition(DragonFeature.getDragonLvl(dragon));
    }

    public static Optional<DragonDefinition> getDragonDefinition(byte lvl) {
        return Optional.ofNullable(DragonDefinitionReloadListener.STATS_MAP.get(lvl));
    }

    public static byte getDragonLvl(EnderDragon dragon) {
        return (Byte)ModNBTData.get((Entity)dragon, (ResourceLocation)LEVEL, Byte.class);
    }

    public static byte getDragonLvl(List<EndCrystal> respawningCrystals) {
        byte corrupted = 0;
        for (EndCrystal crystal : respawningCrystals) {
            if (!(crystal instanceof CorruptedEndCrystal)) continue;
            corrupted = (byte)(corrupted + 1);
        }
        return corrupted;
    }

    public static float neckOffsetXZ() {
        return 3.8f;
    }

    public static float tailOffsetY() {
        return 0.0f;
    }

    public static float headOffsetXZ() {
        return 6.0f;
    }

    public static float headOffsetSittingY() {
        return 0.0f;
    }

    public static float headOffsetY(float original) {
        return original + 1.5f;
    }

    @OnlyIn(value=Dist.CLIENT)
    @SubscribeEvent
    public void onTooltip(ItemTooltipEvent event) {
        if (!(this.isEnabled() && eggTooltip.booleanValue() && event.getItemStack().m_41720_().equals(Items.f_42104_))) {
            return;
        }
        event.getToolTip().add(Component.m_237115_((String)"tooltip.progressivebosses.dragon_egg"));
    }

    static {
        KNOCKBACK_REDUCTION_UUID = UUID.fromString("db8b06d6-791d-4f3b-867d-35e384af9eab");
        explosionImmuneCrystals = true;
        enableFixes = true;
        eggTooltip = true;
        dragonLvl = 0;
        spawnDragon = false;
        preventAdvancement = false;
    }
}

