/*
 * Decompiled with CFR 0.152.
 */
package insane96mcp.progressivebosses.module.dragon.data;

import insane96mcp.progressivebosses.event.DragonPhaseEvent;
import insane96mcp.progressivebosses.module.dragon.DragonFeature;
import insane96mcp.progressivebosses.module.dragon.data.BlastAttackComponent;
import insane96mcp.progressivebosses.module.dragon.data.DragonComponent;
import insane96mcp.progressivebosses.module.dragon.data.DragonDefinition;
import java.util.ArrayList;
import java.util.List;
import java.util.stream.Collectors;
import net.minecraft.world.entity.boss.enderdragon.EnderDragon;
import net.minecraft.world.entity.boss.enderdragon.phases.EnderDragonPhase;
import org.jetbrains.annotations.Nullable;

public interface PhaseChanger {
    public int getPriority();

    public EnderDragonPhase<?> getPhase();

    public boolean shouldExecute(EnderDragon var1);

    public void execute(EnderDragon var1, boolean var2);

    default public void onPhaseBegin(DragonPhaseEvent.Begin event, EnderDragon dragon) {
    }

    @Nullable
    public static PhaseChanger getPhaseChanger(EnderDragon dragon) {
        DragonDefinition definition = DragonFeature.getDragonDefinition(dragon).orElse(null);
        if (definition == null) {
            return null;
        }
        List<Object> phases = new ArrayList<PhaseChanger>();
        for (DragonComponent component : definition.components) {
            PhaseChanger phaseChanger;
            if (!(component instanceof PhaseChanger) || !(phaseChanger = (PhaseChanger)((Object)component)).shouldExecute(dragon)) continue;
            phases.add(phaseChanger);
        }
        if (phases.isEmpty()) {
            return null;
        }
        int maxPriority = phases.stream().mapToInt(PhaseChanger::getPriority).max().getAsInt();
        phases = phases.stream().filter(phase -> phase.getPriority() == maxPriority).collect(Collectors.toList());
        return (PhaseChanger)phases.get(dragon.m_217043_().m_188503_(phases.size()));
    }

    public static boolean trySetNewPhase(EnderDragon dragon, DragonDefinition definition, EnderDragonPhase<?> currentPhase) {
        if (BlastAttackComponent.isForcedToBlast(dragon)) {
            return false;
        }
        PhaseChanger phaseChanger = PhaseChanger.getPhaseChanger(dragon);
        if (phaseChanger != null) {
            phaseChanger.execute(dragon, currentPhase == phaseChanger.getPhase());
            return true;
        }
        return false;
    }
}

