/*
 * Decompiled with CFR 0.152.
 */
package insane96mcp.progressivebosses.module.dragon.data;

import com.google.gson.JsonDeserializationContext;
import com.google.gson.JsonDeserializer;
import com.google.gson.JsonElement;
import com.google.gson.JsonObject;
import com.google.gson.JsonParseException;
import com.google.gson.annotations.JsonAdapter;
import insane96mcp.insanelib.base.Feature;
import insane96mcp.progressivebosses.module.dragon.DragonFeature;
import insane96mcp.progressivebosses.module.dragon.data.DragonComponent;
import insane96mcp.progressivebosses.setup.PBEntities;
import java.lang.reflect.Type;
import java.util.ArrayList;
import java.util.Collections;
import java.util.stream.Stream;
import net.minecraft.core.BlockPos;
import net.minecraft.resources.ResourceLocation;
import net.minecraft.server.level.ServerLevel;
import net.minecraft.tags.DamageTypeTags;
import net.minecraft.util.GsonHelper;
import net.minecraft.world.damagesource.DamageSource;
import net.minecraft.world.entity.Entity;
import net.minecraft.world.entity.EntityType;
import net.minecraft.world.entity.boss.enderdragon.EndCrystal;
import net.minecraft.world.entity.boss.enderdragon.EnderDragon;
import net.minecraft.world.level.Level;
import net.minecraft.world.level.WorldGenLevel;
import net.minecraft.world.level.block.Block;
import net.minecraft.world.level.block.Blocks;
import net.minecraft.world.level.block.state.BlockState;
import net.minecraft.world.level.levelgen.Heightmap;
import net.minecraft.world.level.levelgen.feature.EndPodiumFeature;
import net.minecraft.world.level.levelgen.feature.SpikeFeature;
import net.minecraftforge.fml.ModList;
import net.minecraftforge.registries.ForgeRegistries;

@JsonAdapter(value=Serializer.class)
public class SpikesComponent
implements DragonComponent {
    public int cages;
    public float corruptedChance;
    public int crystalsInside;
    public float insideCorruptedChance;
    private static final ResourceLocation ENDERGETIC_CRYSTAL_LOCATION = new ResourceLocation("endergetic:crystal_holder");

    public static boolean onCrystalDamagedByExplosion(DamageSource source) {
        if (!Feature.isEnabled(DragonFeature.class) || !DragonFeature.explosionImmuneCrystals.booleanValue()) {
            return false;
        }
        return source.m_269533_(DamageTypeTags.f_268415_);
    }

    @Override
    public void apply(EnderDragon dragon) {
        if (this.crystalsInside <= 0) {
            return;
        }
        ArrayList crystals = new ArrayList();
        ArrayList spikes = new ArrayList(SpikeFeature.m_66858_((WorldGenLevel)((ServerLevel)dragon.m_9236_())));
        Collections.shuffle(spikes);
        for (SpikeFeature.EndSpike spike : spikes) {
            crystals.addAll(dragon.m_9236_().m_6443_(EndCrystal.class, spike.m_66905_(), EndCrystal::m_31065_));
        }
        int crystalSpawned = 0;
        for (EndCrystal crystal : crystals) {
            this.generateCrystalInTower(dragon.m_9236_(), crystal.m_146903_(), crystal.m_146904_(), crystal.m_146907_());
            if (++crystalSpawned < this.crystalsInside) continue;
            break;
        }
    }

    public void generateCrystalInTower(Level level, int x, int y, int z) {
        BlockPos centerPodium = level.m_5452_(Heightmap.Types.MOTION_BLOCKING_NO_LEAVES, EndPodiumFeature.f_65714_);
        while (!level.m_8055_(centerPodium).m_60713_(Blocks.f_50752_) && centerPodium.m_123342_() > level.m_5736_()) {
            centerPodium = centerPodium.m_7495_();
        }
        int spawnY = y - 16;
        if (spawnY < centerPodium.m_123342_()) {
            spawnY = centerPodium.m_123342_();
        }
        BlockPos crystalPos = new BlockPos(x, spawnY, z);
        Stream blocks = BlockPos.m_121990_((BlockPos)crystalPos.m_7918_(-1, -1, -1), (BlockPos)crystalPos.m_7918_(1, 1, 1));
        blocks.forEach(pos -> level.m_46597_(pos, Blocks.f_50016_.m_49966_()));
        BlockState baseBlockState = Blocks.f_50752_.m_49966_();
        if (ModList.get().isLoaded("endergetic")) {
            baseBlockState = ((Block)ForgeRegistries.BLOCKS.getValue(ENDERGETIC_CRYSTAL_LOCATION)).m_49966_();
        }
        level.m_46597_(crystalPos.m_7918_(0, -1, 0), baseBlockState);
        EndCrystal crystal = level.f_46441_.m_188501_() < this.insideCorruptedChance ? (EndCrystal)((EntityType)PBEntities.CORRUPTED_END_CRYSTAL.get()).m_20615_(level) : (EndCrystal)EntityType.f_20564_.m_20615_(level);
        crystal.m_6034_((double)crystalPos.m_123341_() + 0.5, (double)crystalPos.m_123342_(), (double)crystalPos.m_123343_() + 0.5);
        crystal.m_31056_(true);
        level.m_7967_((Entity)crystal);
    }

    public static class Serializer
    implements JsonDeserializer<SpikesComponent> {
        public SpikesComponent deserialize(JsonElement json, Type typeOfT, JsonDeserializationContext context) throws JsonParseException {
            SpikesComponent component = new SpikesComponent();
            JsonObject jObject = json.getAsJsonObject();
            component.cages = GsonHelper.m_13927_((JsonObject)jObject, (String)"cages");
            component.corruptedChance = GsonHelper.m_13915_((JsonObject)jObject, (String)"corrupted_chance");
            component.crystalsInside = GsonHelper.m_13927_((JsonObject)jObject, (String)"crystals_inside");
            component.insideCorruptedChance = GsonHelper.m_13915_((JsonObject)jObject, (String)"inside_corrupted_chance");
            return component;
        }
    }
}

