/*
 * Decompiled with CFR 0.152.
 */
package insane96mcp.progressivebosses.module.wither.data;

import com.google.gson.JsonDeserializationContext;
import com.google.gson.JsonDeserializer;
import com.google.gson.JsonElement;
import com.google.gson.JsonObject;
import com.google.gson.JsonParseException;
import com.google.gson.JsonSerializationContext;
import com.google.gson.JsonSerializer;
import com.google.gson.annotations.JsonAdapter;
import com.google.gson.reflect.TypeToken;
import insane96mcp.insanelib.data.SerializableAttributeModifier;
import insane96mcp.insanelib.util.MCUtils;
import insane96mcp.progressivebosses.module.wither.data.PoweredAttributeModifiers;
import insane96mcp.progressivebosses.module.wither.data.WitherAttack;
import insane96mcp.progressivebosses.module.wither.data.WitherDeath;
import insane96mcp.progressivebosses.module.wither.data.WitherHealth;
import insane96mcp.progressivebosses.module.wither.data.WitherMinionStats;
import insane96mcp.progressivebosses.module.wither.data.WitherMiscStats;
import insane96mcp.progressivebosses.module.wither.entity.PBWither;
import java.lang.reflect.Type;
import java.util.ArrayList;
import java.util.List;
import javax.annotation.Nullable;
import net.minecraft.resources.ResourceLocation;
import net.minecraft.util.GsonHelper;
import net.minecraft.world.entity.LivingEntity;
import net.minecraft.world.entity.ai.attributes.Attribute;
import net.minecraft.world.entity.ai.attributes.AttributeModifier;
import net.minecraft.world.entity.ai.attributes.Attributes;

@JsonAdapter(value=Serializer.class)
public class WitherStats {
    private static final ResourceLocation VANILLA_LOOT_TABLE = new ResourceLocation("entities/wither");
    public int level;
    public WitherAttack attack;
    public WitherHealth health;
    @Nullable
    public PoweredAttributeModifiers attributeModifiers;
    @Nullable
    public WitherMinionStats minion;
    public WitherDeath death;
    public WitherMiscStats misc;
    public int xpDropped;
    public ResourceLocation lootTable;
    public static final Type LIST_TYPE = new TypeToken<ArrayList<WitherStats>>(){}.getType();

    public WitherStats(int level, WitherAttack attack, WitherHealth health, @Nullable PoweredAttributeModifiers attributeModifiers, @Nullable WitherMinionStats minion, WitherDeath death, WitherMiscStats misc, int xpDropped, ResourceLocation lootTable) {
        this.level = level;
        this.attack = attack;
        this.health = health;
        this.attributeModifiers = attributeModifiers;
        this.minion = minion;
        this.death = death;
        this.misc = misc;
        this.xpDropped = xpDropped;
        this.lootTable = lootTable;
    }

    public void apply(PBWither wither) {
        wither.m_21051_(Attributes.f_22276_).m_22100_((double)this.health.health);
        if (this.attributeModifiers != null) {
            List<SerializableAttributeModifier> listToAdd = wither.m_7090_() ? this.attributeModifiers.belowHalfHealth : this.attributeModifiers.aboveHalfHealth;
            for (SerializableAttributeModifier modifier : listToAdd) {
                MCUtils.applyModifier((LivingEntity)wither, (Attribute)((Attribute)modifier.attribute().get()), (AttributeModifier)modifier.getModifier(), (boolean)true);
            }
        }
        if (this.minion != null) {
            this.minion.setCooldown(wither, 2.0f);
        }
        wither.f_21355_ = this.lootTable;
        wither.f_21364_ = this.xpDropped;
    }

    public void finalizeSpawn(PBWither wither) {
        wither.m_21153_(wither.m_21233_());
    }

    public static class Serializer
    implements JsonSerializer<WitherStats>,
    JsonDeserializer<WitherStats> {
        public WitherStats deserialize(JsonElement json, Type typeOfT, JsonDeserializationContext context) throws JsonParseException {
            String sLootTable = GsonHelper.m_13851_((JsonObject)json.getAsJsonObject(), (String)"loot_table", (String)VANILLA_LOOT_TABLE.m_135815_());
            ResourceLocation lootTable = ResourceLocation.m_135820_((String)sLootTable);
            PoweredAttributeModifiers resistances = json.getAsJsonObject().has("attribute_modifiers") ? (PoweredAttributeModifiers)context.deserialize(json.getAsJsonObject().get("attribute_modifiers"), PoweredAttributeModifiers.class) : null;
            WitherMinionStats witherMinionStats = json.getAsJsonObject().has("minion") ? (WitherMinionStats)context.deserialize(json.getAsJsonObject().get("minion"), WitherMinionStats.class) : null;
            return new WitherStats(GsonHelper.m_13927_((JsonObject)json.getAsJsonObject(), (String)"level"), (WitherAttack)context.deserialize(json.getAsJsonObject().get("attack"), WitherAttack.class), (WitherHealth)context.deserialize(json.getAsJsonObject().get("health"), WitherHealth.class), resistances, witherMinionStats, (WitherDeath)context.deserialize(json.getAsJsonObject().get("death"), WitherDeath.class), (WitherMiscStats)context.deserialize(json.getAsJsonObject().get("misc"), WitherMiscStats.class), GsonHelper.m_13927_((JsonObject)json.getAsJsonObject(), (String)"xp_dropped"), lootTable);
        }

        public JsonElement serialize(WitherStats src, Type typeOfSrc, JsonSerializationContext context) {
            JsonObject jsonObject = new JsonObject();
            jsonObject.addProperty("level", (Number)src.level);
            jsonObject.add("attack", context.serialize((Object)src.attack));
            jsonObject.add("health", context.serialize((Object)src.health));
            if (src.attributeModifiers != null) {
                jsonObject.add("attribute_modifiers", context.serialize((Object)src.attributeModifiers));
            }
            if (src.minion != null) {
                jsonObject.add("minion", context.serialize((Object)src.minion));
            }
            jsonObject.add("death", context.serialize((Object)src.death));
            jsonObject.add("misc", context.serialize((Object)src.misc));
            jsonObject.addProperty("xp_dropped", (Number)src.xpDropped);
            if (!src.lootTable.equals((Object)VANILLA_LOOT_TABLE)) {
                jsonObject.addProperty("loot_table", src.lootTable.toString());
            }
            return jsonObject;
        }
    }
}

