/*
 * Decompiled with CFR 0.152.
 */
package insane96mcp.progressivebosses.module.wither.entity.minion;

import insane96mcp.insanelib.ai.ILNearestAttackableTargetGoal;
import insane96mcp.insanelib.util.MCUtils;
import insane96mcp.insanelib.util.MathHelper;
import insane96mcp.progressivebosses.module.ILvl;
import insane96mcp.progressivebosses.module.wither.ai.RangedMinionAttackGoal;
import insane96mcp.progressivebosses.module.wither.data.WitherMinionStats;
import insane96mcp.progressivebosses.module.wither.data.WitherStatsReloadListener;
import insane96mcp.progressivebosses.module.wither.entity.PBWither;
import insane96mcp.progressivebosses.setup.PBEntities;
import insane96mcp.progressivebosses.setup.Strings;
import insane96mcp.progressivebosses.utils.LogHelper;
import java.util.EnumSet;
import java.util.UUID;
import java.util.function.Predicate;
import javax.annotation.Nullable;
import net.minecraft.nbt.CompoundTag;
import net.minecraft.sounds.SoundEvent;
import net.minecraft.sounds.SoundEvents;
import net.minecraft.util.RandomSource;
import net.minecraft.world.DifficultyInstance;
import net.minecraft.world.damagesource.DamageSource;
import net.minecraft.world.damagesource.DamageTypes;
import net.minecraft.world.effect.MobEffectInstance;
import net.minecraft.world.effect.MobEffects;
import net.minecraft.world.entity.Entity;
import net.minecraft.world.entity.EntityDimensions;
import net.minecraft.world.entity.EntityType;
import net.minecraft.world.entity.EquipmentSlot;
import net.minecraft.world.entity.LivingEntity;
import net.minecraft.world.entity.Mob;
import net.minecraft.world.entity.MobSpawnType;
import net.minecraft.world.entity.MobType;
import net.minecraft.world.entity.PathfinderMob;
import net.minecraft.world.entity.Pose;
import net.minecraft.world.entity.SpawnGroupData;
import net.minecraft.world.entity.ai.attributes.Attribute;
import net.minecraft.world.entity.ai.attributes.AttributeInstance;
import net.minecraft.world.entity.ai.attributes.AttributeModifier;
import net.minecraft.world.entity.ai.attributes.AttributeSupplier;
import net.minecraft.world.entity.ai.attributes.Attributes;
import net.minecraft.world.entity.ai.goal.FloatGoal;
import net.minecraft.world.entity.ai.goal.Goal;
import net.minecraft.world.entity.ai.goal.LookAtPlayerGoal;
import net.minecraft.world.entity.ai.goal.RandomLookAroundGoal;
import net.minecraft.world.entity.ai.goal.WaterAvoidingRandomStrollGoal;
import net.minecraft.world.entity.ai.goal.target.HurtByTargetGoal;
import net.minecraft.world.entity.ai.goal.target.NearestAttackableTargetGoal;
import net.minecraft.world.entity.boss.wither.WitherBoss;
import net.minecraft.world.entity.monster.AbstractSkeleton;
import net.minecraft.world.entity.player.Player;
import net.minecraft.world.entity.projectile.ProjectileUtil;
import net.minecraft.world.item.BowItem;
import net.minecraft.world.item.ItemStack;
import net.minecraft.world.item.Items;
import net.minecraft.world.item.enchantment.Enchantments;
import net.minecraft.world.level.ItemLike;
import net.minecraft.world.level.Level;
import net.minecraft.world.level.ServerLevelAccessor;
import net.minecraft.world.level.pathfinder.Path;
import net.minecraft.world.phys.Vec3;
import net.minecraftforge.common.ForgeMod;

public class WitherMinion
extends AbstractSkeleton
implements ILvl {
    protected final RangedMinionAttackGoal minionBowGoal = new RangedMinionAttackGoal(this, 1.0, 40, 15.0f);
    private static final Predicate<LivingEntity> NOT_UNDEAD = livingEntity -> livingEntity != null && livingEntity.m_6336_() != MobType.f_21641_ && livingEntity.m_5789_();
    WitherMinionStats stats;
    int lvl;
    boolean summonedByPoweredWither;
    @Nullable
    PBWither owner;

    public WitherMinion(EntityType<? extends AbstractSkeleton> type, Level worldIn) {
        super(type, worldIn);
        this.reassesMinionWeapon();
        this.f_21364_ = 2;
    }

    @Nullable
    public static WitherMinion create(Vec3 pos, PBWither wither) {
        return WitherMinion.create(wither.m_9236_(), pos, wither, wither.getLvl(), wither.m_7090_());
    }

    @Nullable
    public static WitherMinion create(Level level, Vec3 pos, PBWither wither, int lvl, boolean isPowered) {
        WitherMinion minion = (WitherMinion)((EntityType)PBEntities.WITHER_MINION.get()).m_20615_(level);
        if (minion == null) {
            return null;
        }
        CompoundTag minionTags = minion.getPersistentData();
        minionTags.m_128379_("mobspropertiesrandomness:processed", true);
        minion.m_146884_(pos);
        minion.summonedByPoweredWither = isPowered;
        minion.setLvl(lvl);
        minion.m_21409_(EquipmentSlot.MAINHAND, -2.0f);
        minion.m_21553_(false);
        minion.m_21530_();
        minion.owner = wither;
        AttributeInstance maxHealth = minion.m_21051_(Attributes.f_22276_);
        if (maxHealth != null) {
            maxHealth.m_22100_((double)minion.stats.health.getValue(isPowered));
            minion.m_21153_((float)maxHealth.m_22135_());
        }
        MCUtils.applyModifier((LivingEntity)minion, (Attribute)Attributes.f_22279_, (UUID)Strings.AttributeModifiers.MOVEMENT_SPEED_BONUS_UUID, (String)"progressivebosses:movement_speed_bonus", (double)minion.stats.bonusMovementSpeed.getValue(isPowered), (AttributeModifier.Operation)AttributeModifier.Operation.MULTIPLY_BASE);
        level.m_7967_((Entity)minion);
        return minion;
    }

    public void m_7380_(CompoundTag tag) {
        super.m_7380_(tag);
        tag.m_128405_("lvl", this.getLvl());
    }

    public void m_7378_(CompoundTag tag) {
        super.m_7378_(tag);
        this.setLvl(tag.m_128451_("lvl"));
    }

    private void setEquipment() {
        ItemStack item;
        this.m_21409_(EquipmentSlot.MAINHAND, -2.0f);
        float bowChance = this.stats.bowChance.getValue(this.summonedByPoweredWither);
        if (this.f_19796_.m_188501_() < bowChance) {
            int punchLevel;
            item = new ItemStack((ItemLike)Items.f_42411_);
            int powerLevel = MathHelper.getAmountWithDecimalChance((RandomSource)this.m_217043_(), (float)this.stats.powerChance);
            if (powerLevel > 0) {
                item.m_41663_(Enchantments.f_44988_, powerLevel);
            }
            if ((punchLevel = MathHelper.getAmountWithDecimalChance((RandomSource)this.m_217043_(), (float)this.stats.punchChance)) > 0) {
                item.m_41663_(Enchantments.f_44989_, punchLevel);
            }
        } else {
            int knockbackLevel;
            item = new ItemStack((ItemLike)Items.f_42425_);
            int sharpnessLevel = MathHelper.getAmountWithDecimalChance((RandomSource)this.m_217043_(), (float)this.stats.sharpnessChance);
            if (sharpnessLevel > 0) {
                item.m_41663_(Enchantments.f_44977_, sharpnessLevel);
            }
            if ((knockbackLevel = MathHelper.getAmountWithDecimalChance((RandomSource)this.m_217043_(), (float)this.stats.knockbackChance)) > 0) {
                item.m_41663_(Enchantments.f_44980_, knockbackLevel);
            }
        }
        this.m_8061_(EquipmentSlot.MAINHAND, item);
    }

    @Override
    public int getLvl() {
        return this.lvl;
    }

    @Override
    public void setLvl(int lvl) {
        this.lvl = lvl;
        if (!WitherStatsReloadListener.STATS_MAP.containsKey(lvl) && !WitherStatsReloadListener.STATS_MAP.containsKey(lvl = 0)) {
            this.m_146870_();
            LogHelper.warn("Failed to load wither stats, wither minion discarded", new Object[0]);
            return;
        }
        this.stats = WitherStatsReloadListener.STATS_MAP.get((Object)Integer.valueOf((int)lvl)).minion;
        if (this.stats == null) {
            this.m_146870_();
        } else {
            this.setEquipment();
        }
    }

    protected SoundEvent m_7878_() {
        return SoundEvents.f_12562_;
    }

    protected void m_8099_() {
        this.f_21345_.m_25352_(1, (Goal)new FloatGoal((Mob)this));
        this.f_21345_.m_25352_(1, (Goal)new HelpWitherGoal(this));
        this.f_21345_.m_25352_(5, (Goal)new WaterAvoidingRandomStrollGoal((PathfinderMob)this, 1.0));
        this.f_21345_.m_25352_(6, (Goal)new LookAtPlayerGoal((Mob)this, Player.class, 8.0f));
        this.f_21345_.m_25352_(6, (Goal)new RandomLookAroundGoal((Mob)this));
        this.f_21346_.m_25352_(1, (Goal)new HurtByTargetGoal((PathfinderMob)this, new Class[]{PBWither.class, WitherBoss.class, WitherMinion.class}));
        this.f_21346_.m_25352_(2, (Goal)new ILNearestAttackableTargetGoal((Mob)this, Player.class, true).setIgnoreLineOfSight());
        this.f_21346_.m_25352_(3, (Goal)new NearestAttackableTargetGoal((Mob)this, Mob.class, 0, false, false, NOT_UNDEAD));
    }

    protected SoundEvent m_7515_() {
        return SoundEvents.f_12559_;
    }

    protected SoundEvent m_7975_(DamageSource damageSourceIn) {
        return SoundEvents.f_12561_;
    }

    protected SoundEvent m_5592_() {
        return SoundEvents.f_12560_;
    }

    protected float m_6431_(Pose poseIn, EntityDimensions sizeIn) {
        return 1.3f;
    }

    public float m_6100_() {
        return (this.f_19796_.m_188501_() - this.f_19796_.m_188501_()) * 0.2f + 1.33f;
    }

    @Nullable
    public SpawnGroupData m_6518_(ServerLevelAccessor worldIn, DifficultyInstance difficultyIn, MobSpawnType reason, @Nullable SpawnGroupData spawnDataIn, @Nullable CompoundTag dataTag) {
        SpawnGroupData spawnGroupData = super.m_6518_(worldIn, difficultyIn, reason, spawnDataIn, dataTag);
        this.m_32164_();
        return spawnGroupData;
    }

    public void m_32164_() {
        super.m_32164_();
        if (this.minionBowGoal != null) {
            this.reassesMinionWeapon();
        }
    }

    private void reassesMinionWeapon() {
        if (!this.m_9236_().f_46443_) {
            this.f_21345_.m_25363_((Goal)this.f_32131_);
            this.f_21345_.m_25363_((Goal)this.f_32130_);
            this.f_21345_.m_25363_((Goal)this.minionBowGoal);
            ItemStack itemstack = this.m_21120_(ProjectileUtil.getWeaponHoldingHand((LivingEntity)this, item -> item instanceof BowItem));
            if (itemstack.m_150930_(Items.f_42411_)) {
                this.f_21345_.m_25352_(4, (Goal)this.minionBowGoal);
            } else {
                this.f_21345_.m_25352_(4, (Goal)this.f_32131_);
            }
        }
    }

    public boolean m_7327_(Entity entityIn) {
        if (!super.m_7327_(entityIn)) {
            return false;
        }
        if (entityIn instanceof LivingEntity) {
            ((LivingEntity)entityIn).m_7292_(new MobEffectInstance(MobEffects.f_19615_, 200));
        }
        return true;
    }

    @Nullable
    public PBWither getOwner() {
        return this.owner;
    }

    public void m_6475_(DamageSource source, float amount) {
        if (source.m_276093_(DamageTypes.f_268671_)) {
            return;
        }
        if (source.m_276093_(DamageTypes.f_268515_) || source.m_276093_(DamageTypes.f_268530_)) {
            amount *= 1.5f;
        }
        if (source.m_7640_() != null && source.m_7640_().m_6095_() == PBEntities.WITHER_SKULL.get()) {
            amount *= 2.0f;
        }
        super.m_6475_(source, amount);
    }

    public boolean m_7301_(MobEffectInstance potioneffectIn) {
        return potioneffectIn.m_19544_() != MobEffects.f_19615_ && super.m_7301_(potioneffectIn);
    }

    protected void m_21268_(@Nullable LivingEntity entitySource) {
    }

    public static AttributeSupplier.Builder prepareAttributes() {
        return LivingEntity.m_21183_().m_22268_(Attributes.f_22281_, 3.0).m_22268_(Attributes.f_22276_, 15.0).m_22268_(Attributes.f_22277_, 64.0).m_22268_(Attributes.f_22279_, 0.25).m_22268_(Attributes.f_22282_, 1.0).m_22268_((Attribute)ForgeMod.SWIM_SPEED.get(), 3.0);
    }

    public static class HelpWitherGoal
    extends Goal {
        WitherMinion minion;
        Path path = null;

        public HelpWitherGoal(WitherMinion minion) {
            this.minion = minion;
            this.m_7021_(EnumSet.of(Goal.Flag.MOVE, Goal.Flag.TARGET));
        }

        public boolean m_8036_() {
            if (this.minion.getOwner() == null || !this.minion.getOwner().needsHealing() || this.minion.getOwner().m_21224_() || this.minion.getOwner().m_213877_()) {
                return false;
            }
            this.path = this.minion.m_21573_().m_6570_((Entity)this.minion.getOwner(), 2);
            return this.path != null;
        }

        public boolean m_8045_() {
            return this.minion.getOwner() != null && (double)this.minion.m_20270_((Entity)this.minion.getOwner()) > 4.0 && !this.minion.getOwner().m_21224_() && !this.minion.getOwner().m_213877_();
        }

        public void m_8056_() {
            this.minion.m_21573_().m_26536_(this.path, 1.25);
        }

        public void m_8041_() {
            this.path = null;
        }
    }
}

