/*
 * Decompiled with CFR 0.152.
 */
package com.talhanation.recruits;

import com.talhanation.recruits.Main;
import com.talhanation.recruits.TeamEvents;
import com.talhanation.recruits.compat.IWeapon;
import com.talhanation.recruits.config.RecruitsServerConfig;
import com.talhanation.recruits.entities.AbstractRecruitEntity;
import com.talhanation.recruits.entities.ICompanion;
import com.talhanation.recruits.entities.MessengerEntity;
import com.talhanation.recruits.entities.ai.horse.HorseRiddenByRecruitGoal;
import com.talhanation.recruits.init.ModEntityTypes;
import com.talhanation.recruits.inventory.PromoteContainer;
import com.talhanation.recruits.network.MessageOpenPromoteScreen;
import com.talhanation.recruits.world.PillagerPatrolSpawn;
import com.talhanation.recruits.world.RecruitsDiplomacyManager;
import com.talhanation.recruits.world.RecruitsPatrolSpawn;
import com.talhanation.recruits.world.RecruitsPlayerUnitManager;
import java.util.ArrayList;
import java.util.HashMap;
import java.util.HashSet;
import java.util.Iterator;
import java.util.List;
import java.util.Map;
import java.util.Objects;
import java.util.Set;
import java.util.UUID;
import net.minecraft.core.BlockPos;
import net.minecraft.nbt.CompoundTag;
import net.minecraft.nbt.Tag;
import net.minecraft.network.chat.Component;
import net.minecraft.network.chat.MutableComponent;
import net.minecraft.server.MinecraftServer;
import net.minecraft.server.level.ServerLevel;
import net.minecraft.server.level.ServerPlayer;
import net.minecraft.tags.BlockTags;
import net.minecraft.world.Container;
import net.minecraft.world.MenuProvider;
import net.minecraft.world.entity.Entity;
import net.minecraft.world.entity.EntityType;
import net.minecraft.world.entity.LivingEntity;
import net.minecraft.world.entity.ai.goal.Goal;
import net.minecraft.world.entity.animal.Animal;
import net.minecraft.world.entity.animal.horse.AbstractChestedHorse;
import net.minecraft.world.entity.animal.horse.AbstractHorse;
import net.minecraft.world.entity.monster.AbstractIllager;
import net.minecraft.world.entity.player.Inventory;
import net.minecraft.world.entity.player.Player;
import net.minecraft.world.entity.projectile.AbstractArrow;
import net.minecraft.world.entity.projectile.Projectile;
import net.minecraft.world.inventory.AbstractContainerMenu;
import net.minecraft.world.level.Level;
import net.minecraft.world.level.block.entity.BlockEntity;
import net.minecraft.world.level.block.state.BlockState;
import net.minecraft.world.phys.EntityHitResult;
import net.minecraft.world.phys.HitResult;
import net.minecraft.world.scores.Team;
import net.minecraftforge.event.TickEvent;
import net.minecraftforge.event.entity.EntityJoinLevelEvent;
import net.minecraftforge.event.entity.EntityLeaveLevelEvent;
import net.minecraftforge.event.entity.EntityTeleportEvent;
import net.minecraftforge.event.entity.ProjectileImpactEvent;
import net.minecraftforge.event.entity.living.LivingAttackEvent;
import net.minecraftforge.event.entity.living.LivingDeathEvent;
import net.minecraftforge.event.entity.living.LivingHurtEvent;
import net.minecraftforge.event.entity.player.PlayerInteractEvent;
import net.minecraftforge.event.level.BlockEvent;
import net.minecraftforge.event.level.LevelEvent;
import net.minecraftforge.event.server.ServerStartingEvent;
import net.minecraftforge.event.server.ServerStoppingEvent;
import net.minecraftforge.eventbus.api.SubscribeEvent;
import net.minecraftforge.network.NetworkHooks;
import org.jetbrains.annotations.NotNull;

public class RecruitEvents {
    private static final Map<ServerLevel, RecruitsPatrolSpawn> RECRUIT_PATROL = new HashMap<ServerLevel, RecruitsPatrolSpawn>();
    private static final Map<ServerLevel, PillagerPatrolSpawn> PILLAGER_PATROL = new HashMap<ServerLevel, PillagerPatrolSpawn>();
    public static RecruitsPlayerUnitManager recruitsPlayerUnitManager;
    public static MinecraftServer server;
    static HashMap<Integer, EntityType<? extends AbstractRecruitEntity>> entitiesByProfession;
    private static final Set<Projectile> canceledProjectiles;
    private static final double DAMAGE_THRESHOLD_PERCENTAGE = 0.75;
    private final List<AbstractArrow> trackedArrows = new ArrayList<AbstractArrow>();
    private int tickCounter = 0;

    public static void promoteRecruit(AbstractRecruitEntity recruit, int profession, String name, ServerPlayer player) {
        EntityType<? extends AbstractRecruitEntity> companionType = entitiesByProfession.get(profession);
        AbstractRecruitEntity abstractRecruit = (AbstractRecruitEntity)companionType.m_20615_(recruit.m_20193_());
        if (abstractRecruit instanceof ICompanion) {
            ICompanion companion = (ICompanion)((Object)abstractRecruit);
            abstractRecruit.m_6593_((Component)Component.m_237113_((String)name));
            abstractRecruit.m_20359_((Entity)recruit);
            companion.applyRecruitValues(recruit);
            companion.setOwnerName(player.m_7755_().getString());
            recruit.m_146870_();
            abstractRecruit.m_20193_().m_7967_((Entity)abstractRecruit);
        }
    }

    public static void openPromoteScreen(Player player, final AbstractRecruitEntity recruit) {
        if (player instanceof ServerPlayer) {
            NetworkHooks.openScreen((ServerPlayer)((ServerPlayer)player), (MenuProvider)new MenuProvider(){

                @NotNull
                public Component m_5446_() {
                    return recruit.m_7755_();
                }

                public AbstractContainerMenu m_7208_(int i, @NotNull Inventory playerInventory, @NotNull Player playerEntity) {
                    return new PromoteContainer(i, playerEntity, recruit);
                }
            }, packetBuffer -> packetBuffer.m_130077_(recruit.m_20148_()));
        } else {
            Main.SIMPLE_CHANNEL.sendToServer((Object)new MessageOpenPromoteScreen(player, recruit.m_20148_()));
        }
    }

    @SubscribeEvent
    public void onServerStarting(ServerStartingEvent event) {
        server = event.getServer();
        recruitsPlayerUnitManager = new RecruitsPlayerUnitManager();
        recruitsPlayerUnitManager.load(server.m_129783_());
    }

    @SubscribeEvent
    public void onServerStopping(ServerStoppingEvent event) {
        recruitsPlayerUnitManager.save(server.m_129783_());
    }

    @SubscribeEvent
    public void onWorldSave(LevelEvent.Save event) {
        recruitsPlayerUnitManager.save(server.m_129783_());
    }

    @SubscribeEvent
    public void onTeleportEvent(EntityTeleportEvent event) {
        Entity entity = event.getEntity();
        if (entity instanceof ServerPlayer) {
            ServerPlayer player = (ServerPlayer)entity;
            if (!(event instanceof EntityTeleportEvent.EnderPearl || event instanceof EntityTeleportEvent.ChorusFruit || event instanceof EntityTeleportEvent.EnderEntity)) {
                double targetX = event.getTargetX();
                double targetY = event.getTargetY();
                double targetZ = event.getTargetZ();
                UUID player_uuid = player.m_20148_();
                List recruits = player.m_20193_().m_6443_(AbstractRecruitEntity.class, player.m_20191_().m_82377_(64.0, 32.0, 64.0), recruit -> recruit.m_6084_() && recruit.getFollowState() == 1 && recruit.getOwnerUUID().equals(player_uuid));
                recruits.forEach(recruit -> recruit.m_6021_(targetX, targetY, targetZ));
            }
        }
    }

    @SubscribeEvent
    public void onServerTick(TickEvent.LevelTickEvent event) {
        Level level;
        if (!event.level.f_46443_ && (level = event.level) instanceof ServerLevel) {
            ServerLevel serverWorld = (ServerLevel)level;
            if (((Boolean)RecruitsServerConfig.ShouldRecruitPatrolsSpawn.get()).booleanValue()) {
                RECRUIT_PATROL.computeIfAbsent(serverWorld, serverLevel -> new RecruitsPatrolSpawn(serverWorld));
                RecruitsPatrolSpawn spawner = RECRUIT_PATROL.get(serverWorld);
                spawner.tick();
            }
            if (((Boolean)RecruitsServerConfig.ShouldPillagerPatrolsSpawn.get()).booleanValue()) {
                PILLAGER_PATROL.computeIfAbsent(serverWorld, serverLevel -> new PillagerPatrolSpawn(serverWorld));
                PillagerPatrolSpawn pillagerSpawner = PILLAGER_PATROL.get(serverWorld);
                pillagerSpawner.tick();
            }
        }
    }

    @SubscribeEvent
    public void onProjectileImpact(ProjectileImpactEvent event) {
        Player player;
        AbstractArrow arrow;
        Entity entity = event.getEntity();
        HitResult rayTrace = event.getRayTraceResult();
        if (canceledProjectiles.contains(entity)) {
            return;
        }
        if (!(entity instanceof Projectile)) {
            return;
        }
        Projectile projectile = (Projectile)entity;
        Entity owner = projectile.m_19749_();
        if (owner == null) {
            return;
        }
        if (rayTrace.m_6662_() != HitResult.Type.ENTITY) {
            return;
        }
        Entity impactEntity = ((EntityHitResult)rayTrace).m_82443_();
        String encode = impactEntity.m_20078_();
        if (encode != null && encode.contains("corpse:corpse")) {
            event.setImpactResult(ProjectileImpactEvent.ImpactResult.SKIP_ENTITY);
            return;
        }
        if (!(impactEntity instanceof LivingEntity)) {
            return;
        }
        LivingEntity impactLiving = (LivingEntity)impactEntity;
        if (projectile instanceof AbstractArrow && (arrow = (AbstractArrow)projectile).m_36796_() > 0 && !RecruitEvents.canAttack((LivingEntity)owner, impactLiving)) {
            event.setImpactResult(ProjectileImpactEvent.ImpactResult.SKIP_ENTITY);
            canceledProjectiles.add(projectile);
            return;
        }
        if (owner instanceof AbstractRecruitEntity) {
            AbstractRecruitEntity recruit = (AbstractRecruitEntity)owner;
            if (impactLiving instanceof Animal) {
                Player player2;
                Animal animal = (Animal)impactLiving;
                Entity passenger = animal.m_146895_();
                if (passenger instanceof AbstractRecruitEntity) {
                    AbstractRecruitEntity passengerRecruit = (AbstractRecruitEntity)passenger;
                    if (!RecruitEvents.canAttack((LivingEntity)recruit, (LivingEntity)passengerRecruit)) {
                        event.setImpactResult(ProjectileImpactEvent.ImpactResult.SKIP_ENTITY);
                        return;
                    }
                } else if (passenger instanceof Player && !RecruitEvents.canAttack((LivingEntity)recruit, (LivingEntity)(player2 = (Player)passenger))) {
                    event.setImpactResult(ProjectileImpactEvent.ImpactResult.SKIP_ENTITY);
                    return;
                }
            }
            if (!RecruitEvents.canAttack((LivingEntity)recruit, impactLiving)) {
                event.setImpactResult(ProjectileImpactEvent.ImpactResult.SKIP_ENTITY);
                return;
            }
            recruit.addXp(2);
            recruit.checkLevel();
        }
        if (owner instanceof AbstractIllager) {
            AbstractIllager illager = (AbstractIllager)owner;
            if (!((Boolean)RecruitsServerConfig.PillagerFriendlyFire.get()).booleanValue() && illager.m_7307_((Entity)impactLiving)) {
                event.setImpactResult(ProjectileImpactEvent.ImpactResult.SKIP_ENTITY);
                canceledProjectiles.add(projectile);
                return;
            }
        }
        if (owner instanceof Player && !RecruitEvents.canHarmTeam((LivingEntity)(player = (Player)owner), impactLiving)) {
            event.setImpactResult(ProjectileImpactEvent.ImpactResult.SKIP_ENTITY);
            return;
        }
    }

    @SubscribeEvent
    public void onEntityLeaveWorld(EntityLeaveLevelEvent event) {
        if (event.getLevel().m_5776_()) {
            return;
        }
        Entity entity = event.getEntity();
        if (entity instanceof Projectile) {
            Projectile projectile = (Projectile)entity;
            canceledProjectiles.remove(projectile);
        }
    }

    @SubscribeEvent
    public void onPlayerInteractWithCaravan(PlayerInteractEvent.EntityInteract entityInteract) {
        if (entityInteract.getLevel().m_5776_()) {
            return;
        }
        Player player = entityInteract.getEntity();
        Entity interacting = entityInteract.getTarget();
        if (interacting instanceof AbstractChestedHorse) {
            AbstractChestedHorse chestedHorse = (AbstractChestedHorse)interacting;
            CompoundTag nbt = chestedHorse.getPersistentData();
            if (!nbt.m_128441_("Caravan") || !chestedHorse.m_30502_()) {
                return;
            }
            player.m_20193_().m_6443_(AbstractRecruitEntity.class, player.m_20191_().m_82400_(64.0), recruit -> !recruit.isOwned() && (recruit.m_7755_().getString().equals("Caravan Leader") || recruit.m_7755_().getString().equals("Caravan Guard"))).forEach(recruit -> recruit.m_6710_((LivingEntity)player));
        }
    }

    @SubscribeEvent
    public void onLivingHurt(LivingHurtEvent event) {
        LivingEntity target;
        AbstractRecruitEntity owner;
        Entity sourceEntity;
        if (event.getEntity().m_20193_().m_5776_()) {
            return;
        }
        if (Main.isMusketModLoaded && (sourceEntity = event.getSource().m_7639_()) instanceof AbstractRecruitEntity && IWeapon.isMusketModWeapon((owner = (AbstractRecruitEntity)sourceEntity).m_21205_()) && (target = event.getEntity()) instanceof LivingEntity) {
            LivingEntity impactEntity = target;
            if (!RecruitEvents.canAttack((LivingEntity)owner, impactEntity)) {
                event.setCanceled(true);
            } else {
                owner.addXp(2);
                owner.checkLevel();
            }
        }
        LivingEntity target2 = event.getEntity();
        Entity source = event.getSource().m_7639_();
        if (source instanceof LivingEntity) {
            LivingEntity sourceEntity2 = (LivingEntity)source;
            if (target2.m_5647_() == null) {
                return;
            }
            target2.m_20193_().m_6443_(AbstractRecruitEntity.class, target2.m_20191_().m_82400_(32.0), arg_0 -> RecruitEvents.lambda$onLivingHurt$7((Entity)target2, arg_0)).forEach(recruit -> recruit.m_6710_(sourceEntity2));
        }
    }

    @SubscribeEvent
    public void onLivingAttack(LivingAttackEvent event) {
        if (event.getEntity().m_20193_().m_5776_()) {
            return;
        }
        LivingEntity target = event.getEntity();
        Entity source = event.getSource().m_7639_();
        if (!target.m_20193_().m_5776_() && target instanceof LivingEntity) {
            LivingEntity livingTarget = target;
            if (source instanceof LivingEntity) {
                LivingEntity livingSource = (LivingEntity)source;
                if (!RecruitEvents.canAttack(livingSource, livingTarget)) {
                    event.setCanceled(true);
                } else {
                    this.handleSignificantDamage(livingSource, livingTarget, event.getAmount(), (ServerLevel)livingTarget.m_20193_());
                }
            }
        }
    }

    private void handleSignificantDamage(LivingEntity attacker, LivingEntity target, double damage, ServerLevel level) {
        double damageThreshold;
        Team attackerTeam = attacker.m_5647_();
        Team targetTeam = target.m_5647_();
        if (attackerTeam == null || targetTeam == null) {
            return;
        }
        double newHealth = (double)target.m_21223_() - damage;
        if (newHealth < (damageThreshold = (double)target.m_21233_() * 0.75)) {
            this.setTeamsAsEnemies(attackerTeam, targetTeam, level);
        }
    }

    private void setTeamsAsEnemies(Team attackerTeam, Team targetTeam, ServerLevel level) {
        String attackerTeamName = attackerTeam.m_5758_();
        String targetTeamName = targetTeam.m_5758_();
        if (TeamEvents.recruitsDiplomacyManager != null) {
            TeamEvents.recruitsDiplomacyManager.setRelation(attackerTeamName, targetTeamName, RecruitsDiplomacyManager.DiplomacyStatus.ENEMY, level);
            TeamEvents.recruitsDiplomacyManager.setRelation(targetTeamName, attackerTeamName, RecruitsDiplomacyManager.DiplomacyStatus.ENEMY, level);
        }
    }

    @SubscribeEvent
    public void onHorseJoinWorld(EntityJoinLevelEvent event) {
        Entity entity = event.getEntity();
        if (entity instanceof AbstractHorse) {
            AbstractHorse horse = (AbstractHorse)entity;
            horse.f_21345_.m_25352_(0, (Goal)new HorseRiddenByRecruitGoal(horse));
        }
    }

    @SubscribeEvent
    public void onBlockBreakEvent(BlockEvent.BreakEvent event) {
        String[] name;
        boolean[] warn;
        Player blockBreaker;
        if (event.getLevel().m_5776_()) {
            return;
        }
        if (((Boolean)RecruitsServerConfig.AggroRecruitsBlockPlaceBreakEvents.get()).booleanValue()) {
            blockBreaker = event.getPlayer();
            if (blockBreaker == null) {
                return;
            }
            warn = new boolean[]{false};
            name = new String[1];
            blockBreaker.m_20193_().m_45976_(AbstractRecruitEntity.class, blockBreaker.m_20191_().m_82400_(32.0)).forEach(recruit -> {
                if (this.canDamageTargetBlockEvent((AbstractRecruitEntity)((Object)recruit), (LivingEntity)blockBreaker) && recruit.getState() == 1) {
                    recruit.m_6710_((LivingEntity)blockBreaker);
                }
                if (!warn[0] && this.canDamageTargetBlockEvent((AbstractRecruitEntity)((Object)recruit), (LivingEntity)blockBreaker) && recruit.getState() == 0 && recruit.isOwned()) {
                    warn[0] = true;
                    name[0] = recruit.m_7755_().toString();
                }
            });
            if (warn[0]) {
                this.warnPlayer(blockBreaker, (Component)RecruitEvents.TEXT_BLOCK_WARN(name[0]));
            }
        }
        if (((Boolean)RecruitsServerConfig.NeutralRecruitsBlockPlaceBreakEvents.get()).booleanValue()) {
            blockBreaker = event.getPlayer();
            if (blockBreaker == null) {
                return;
            }
            warn = new boolean[]{false};
            name = new String[1];
            blockBreaker.m_20193_().m_45976_(AbstractRecruitEntity.class, blockBreaker.m_20191_().m_82400_(32.0)).forEach(recruit -> {
                if (this.canDamageTargetBlockEvent((AbstractRecruitEntity)((Object)recruit), (LivingEntity)blockBreaker) && recruit.getState() == 0 && recruit.isOwned()) {
                    recruit.m_6710_((LivingEntity)blockBreaker);
                }
                if (!warn[0] && this.canDamageTargetBlockEvent((AbstractRecruitEntity)((Object)recruit), (LivingEntity)blockBreaker) && recruit.getState() == 0 && recruit.isOwned()) {
                    warn[0] = true;
                    name[0] = recruit.m_7755_().toString();
                }
            });
            if (warn[0]) {
                this.warnPlayer(blockBreaker, (Component)RecruitEvents.TEXT_BLOCK_WARN(name[0]));
            }
        }
    }

    @SubscribeEvent
    public void onBlockPlaceEvent(BlockEvent.EntityPlaceEvent event) {
        Player player;
        Entity blockPlacer;
        if (event.getLevel().m_5776_()) {
            return;
        }
        if (((Boolean)RecruitsServerConfig.AggroRecruitsBlockPlaceBreakEvents.get()).booleanValue() && (blockPlacer = event.getEntity()) instanceof LivingEntity) {
            LivingEntity livingBlockPlacer = (LivingEntity)blockPlacer;
            boolean[] warn = new boolean[]{false};
            String[] name = new String[1];
            livingBlockPlacer.m_20193_().m_6443_(AbstractRecruitEntity.class, livingBlockPlacer.m_20191_().m_82400_(32.0), recruit -> this.canDamageTargetBlockEvent((AbstractRecruitEntity)((Object)recruit), livingBlockPlacer)).forEach(recruit -> {
                if (recruit.getState() == 1) {
                    recruit.m_6710_(livingBlockPlacer);
                }
                if (blockPlacer instanceof Player && !warn[0] && recruit.getState() == 0 && recruit.isOwned()) {
                    warn[0] = true;
                    name[0] = recruit.m_7755_().toString();
                }
            });
            if (blockPlacer instanceof Player) {
                player = (Player)blockPlacer;
                if (warn[0]) {
                    this.warnPlayer(player, (Component)RecruitEvents.TEXT_BLOCK_WARN(name[0]));
                }
            }
        }
        if (((Boolean)RecruitsServerConfig.NeutralRecruitsBlockPlaceBreakEvents.get()).booleanValue()) {
            blockPlacer = event.getEntity();
            boolean[] warn = new boolean[]{false};
            String[] name = new String[1];
            if (blockPlacer instanceof LivingEntity) {
                LivingEntity livingBlockPlacer = (LivingEntity)blockPlacer;
                livingBlockPlacer.m_20193_().m_6443_(AbstractRecruitEntity.class, livingBlockPlacer.m_20191_().m_82400_(32.0), recruit -> this.canDamageTargetBlockEvent((AbstractRecruitEntity)((Object)recruit), livingBlockPlacer) && recruit.getState() == 0 && recruit.isOwned()).forEach(recruit -> {
                    recruit.m_6710_(livingBlockPlacer);
                    if (blockPlacer instanceof Player && !warn[0]) {
                        warn[0] = true;
                        name[0] = recruit.m_7755_().toString();
                    }
                });
                if (blockPlacer instanceof Player) {
                    player = (Player)blockPlacer;
                    if (warn[0]) {
                        this.warnPlayer(player, (Component)RecruitEvents.TEXT_BLOCK_WARN(name[0]));
                    }
                }
            }
        }
    }

    @SubscribeEvent
    public void onBlockInteract(PlayerInteractEvent.RightClickBlock event) {
        if (event.getLevel().m_5776_()) {
            return;
        }
        BlockPos pos = event.getHitVec().m_82425_();
        Player player = event.getEntity();
        BlockState selectedBlock = player.m_20193_().m_8055_(pos);
        BlockEntity blockEntity = player.m_20193_().m_7702_(pos);
        if (selectedBlock.m_204336_(BlockTags.f_13093_) || selectedBlock.m_204336_(BlockTags.f_13103_) || selectedBlock.m_204336_(BlockTags.f_13102_) || selectedBlock.m_204336_(BlockTags.f_13092_) || selectedBlock.m_204336_(BlockTags.f_13095_) || selectedBlock.m_204336_(BlockTags.f_13083_) || selectedBlock.m_204336_(BlockTags.f_13055_) || selectedBlock.m_204336_(BlockTags.f_13033_) || blockEntity instanceof Container) {
            List list;
            if (((Boolean)RecruitsServerConfig.AggroRecruitsBlockInteractingEvents.get()).booleanValue()) {
                list = player.m_20193_().m_45976_(AbstractRecruitEntity.class, player.m_20191_().m_82400_(32.0));
                for (AbstractRecruitEntity recruits : list) {
                    if (!this.canDamageTargetBlockEvent(recruits, (LivingEntity)player) || recruits.getState() != 1) continue;
                    recruits.m_6710_((LivingEntity)player);
                }
                if (list.stream().anyMatch(recruit -> this.canDamageTargetBlockEvent((AbstractRecruitEntity)((Object)recruit), (LivingEntity)player) && recruit.getState() == 0 && recruit.isOwned())) {
                    this.warnPlayer(player, (Component)RecruitEvents.TEXT_INTERACT_WARN(((AbstractRecruitEntity)((Object)list.get(0))).m_7755_().getString()));
                }
            }
            if (((Boolean)RecruitsServerConfig.NeutralRecruitsBlockInteractingEvents.get()).booleanValue()) {
                list = Objects.requireNonNull(player.m_20193_().m_45976_(AbstractRecruitEntity.class, player.m_20191_().m_82400_(32.0)));
                for (AbstractRecruitEntity recruits : list) {
                    if (!this.canDamageTargetBlockEvent(recruits, (LivingEntity)player) || recruits.getState() != 0 || !recruits.isOwned()) continue;
                    recruits.m_6710_((LivingEntity)player);
                }
                if (list.stream().anyMatch(recruit -> this.canDamageTargetBlockEvent((AbstractRecruitEntity)((Object)recruit), (LivingEntity)player) && recruit.getState() == 0 && recruit.isOwned())) {
                    this.warnPlayer(player, (Component)RecruitEvents.TEXT_INTERACT_WARN(((AbstractRecruitEntity)((Object)list.get(0))).m_7755_().getString()));
                }
            }
        }
    }

    public boolean canDamageTargetBlockEvent(AbstractRecruitEntity recruit, LivingEntity target) {
        if (recruit.isOwned() && target instanceof AbstractRecruitEntity) {
            AbstractRecruitEntity recruitEntityTarget = (AbstractRecruitEntity)target;
            if (recruit.getOwnerUUID().equals(recruitEntityTarget.getOwnerUUID())) {
                return false;
            }
            if (recruit.m_5647_() != null && recruitEntityTarget.m_5647_() != null && recruit.m_5647_().equals(recruitEntityTarget.m_5647_())) {
                return false;
            }
        } else if (recruit.isOwned() && target instanceof Player) {
            Player player = (Player)target;
            if (recruit.getOwnerUUID().equals(player.m_20148_())) {
                return false;
            }
        } else if (target instanceof AbstractRecruitEntity) {
            AbstractRecruitEntity recruitEntityTarget = (AbstractRecruitEntity)target;
            if (recruit.getProtectUUID() != null && recruitEntityTarget.getProtectUUID() != null && recruit.getProtectUUID().equals(recruitEntityTarget.getProtectUUID())) {
                return false;
            }
        }
        return RecruitEvents.canHarmTeamNoFriendlyFire((LivingEntity)recruit, target);
    }

    public static boolean canAttack(LivingEntity attacker, LivingEntity target) {
        if (target == null || !target.m_6084_()) {
            return false;
        }
        if (target instanceof Player) {
            Player player = (Player)target;
            return RecruitEvents.canAttackPlayer(attacker, player);
        }
        if (target instanceof AbstractRecruitEntity) {
            AbstractRecruitEntity targetRecruit = (AbstractRecruitEntity)target;
            return RecruitEvents.canAttackRecruit(attacker, targetRecruit);
        }
        if (target instanceof Animal) {
            Animal animal = (Animal)target;
            return RecruitEvents.canAttackAnimal(attacker, animal);
        }
        return RecruitEvents.canHarmTeam(attacker, target);
    }

    public static boolean canAttackAnimal(LivingEntity attacker, Animal animal) {
        if (attacker instanceof AbstractRecruitEntity) {
            AbstractRecruitEntity recruit = (AbstractRecruitEntity)attacker;
            if (recruit.m_20202_() != null && recruit.m_20202_().m_20148_().equals(animal.m_20148_())) {
                return false;
            }
            if (recruit.getProtectUUID() != null && recruit.getProtectUUID().equals(recruit.getProtectUUID())) {
                return false;
            }
            if (animal.m_20160_()) {
                Entity entity = animal.m_146895_();
                if (entity instanceof AbstractRecruitEntity) {
                    AbstractRecruitEntity targetRecruit = (AbstractRecruitEntity)entity;
                    return RecruitEvents.canAttackRecruit(attacker, targetRecruit);
                }
                entity = animal.m_146895_();
                if (entity instanceof Player) {
                    Player playerTarget = (Player)entity;
                    return RecruitEvents.canAttackPlayer(attacker, playerTarget);
                }
            }
        }
        return RecruitEvents.canHarmTeam(attacker, (LivingEntity)animal);
    }

    public static boolean canAttackPlayer(LivingEntity attacker, Player player) {
        if (attacker instanceof AbstractRecruitEntity) {
            AbstractRecruitEntity recruit = (AbstractRecruitEntity)attacker;
            if (player.m_20148_().equals(recruit.getOwnerUUID()) || player.m_20148_().equals(recruit.getProtectUUID()) || player.m_7500_() || player.m_5833_()) {
                return false;
            }
        }
        return RecruitEvents.canHarmTeam(attacker, (LivingEntity)player);
    }

    public static boolean canAttackRecruit(LivingEntity attacker, AbstractRecruitEntity targetRecruit) {
        if (attacker.equals((Object)targetRecruit)) {
            return false;
        }
        if (attacker instanceof AbstractRecruitEntity) {
            MessengerEntity messenger;
            AbstractRecruitEntity attackerRecruit = (AbstractRecruitEntity)attacker;
            if (attackerRecruit.isOwned() && targetRecruit.isOwned() && attackerRecruit.getOwnerUUID().equals(targetRecruit.getOwnerUUID())) {
                return false;
            }
            if (attackerRecruit.m_5647_() != null && targetRecruit.m_5647_() != null && attackerRecruit.m_5647_().equals(targetRecruit.m_5647_()) && !attackerRecruit.m_5647_().m_6260_()) {
                return false;
            }
            if (attackerRecruit.getProtectUUID() != null && attackerRecruit.getProtectUUID().equals(targetRecruit.getProtectUUID())) {
                return false;
            }
            if (targetRecruit instanceof MessengerEntity && (messenger = (MessengerEntity)targetRecruit).isAtMission()) {
                return false;
            }
        }
        return RecruitEvents.canHarmTeam(attacker, (LivingEntity)targetRecruit);
    }

    public static boolean isAlly(Team team1, Team team2) {
        if (team1 == null || team2 == null || TeamEvents.recruitsDiplomacyManager == null) {
            return false;
        }
        return TeamEvents.recruitsDiplomacyManager.getRelation(team1.m_5758_(), team2.m_5758_()) == RecruitsDiplomacyManager.DiplomacyStatus.ALLY;
    }

    public static boolean isEnemy(Team team1, Team team2) {
        if (team1 == null || team2 == null || TeamEvents.recruitsDiplomacyManager == null) {
            return false;
        }
        return TeamEvents.recruitsDiplomacyManager.getRelation(team1.m_5758_(), team2.m_5758_()) == RecruitsDiplomacyManager.DiplomacyStatus.ENEMY;
    }

    public static boolean isNeutral(Team team1, Team team2) {
        if (team1 == null || team2 == null || TeamEvents.recruitsDiplomacyManager == null) {
            return true;
        }
        return TeamEvents.recruitsDiplomacyManager.getRelation(team1.m_5758_(), team2.m_5758_()) == RecruitsDiplomacyManager.DiplomacyStatus.NEUTRAL;
    }

    public static boolean canHarmTeam(LivingEntity attacker, LivingEntity target) {
        Team attackerTeam = attacker.m_5647_();
        Team targetTeam = target.m_5647_();
        if (attackerTeam == null || targetTeam == null) {
            return true;
        }
        if (attackerTeam.equals(targetTeam) && !attackerTeam.m_6260_()) {
            return false;
        }
        return !RecruitEvents.isAlly(attackerTeam, targetTeam);
    }

    public static boolean canHarmTeamNoFriendlyFire(LivingEntity attacker, LivingEntity target) {
        Team team = attacker.m_5647_();
        Team team1 = target.m_5647_();
        if (team == null) {
            return true;
        }
        if (team1 == null) {
            return true;
        }
        if (team == team1) {
            return false;
        }
        RecruitsDiplomacyManager.DiplomacyStatus relation = TeamEvents.recruitsDiplomacyManager.getRelation(team.m_5758_(), team1.m_5758_());
        return relation != RecruitsDiplomacyManager.DiplomacyStatus.ALLY;
    }

    @SubscribeEvent
    public void onRecruitDeath(LivingDeathEvent event) {
        LivingEntity target = event.getEntity();
        if (target instanceof AbstractRecruitEntity) {
            AbstractRecruitEntity recruit = (AbstractRecruitEntity)target;
            if (!recruit.getIsOwned() || server.m_129783_().m_5776_()) {
                return;
            }
            UUID owner = recruit.getOwnerUUID();
            recruit.m_20193_().m_6443_(AbstractRecruitEntity.class, recruit.m_20191_().m_82400_(64.0), entity -> entity.getOwnerUUID() != null && entity.getOwnerUUID().equals(owner)).forEach(entity -> {
                float currentMoral = entity.getMorale();
                float newMorale = currentMoral - 0.2f;
                entity.setMoral(Math.max(newMorale, 0.0f));
            });
        }
    }

    @SubscribeEvent
    public void onWorldTickArrowCleaner(TickEvent.LevelTickEvent event) {
        if (event.level.m_5776_()) {
            return;
        }
        if (!((Boolean)RecruitsServerConfig.AllowArrowCleaning.get()).booleanValue()) {
            return;
        }
        if (event.phase != TickEvent.Phase.END) {
            return;
        }
        if (server == null) {
            return;
        }
        if (++this.tickCounter < 100) {
            return;
        }
        this.tickCounter = 0;
        List arrows = event.level.m_45976_(AbstractArrow.class, event.level.m_6857_().m_61946_().m_83215_());
        this.trackedArrows.addAll(arrows);
        Iterator<AbstractArrow> iterator = this.trackedArrows.iterator();
        while (iterator.hasNext()) {
            AbstractArrow arrow = iterator.next();
            if (arrow.f_36705_ != AbstractArrow.Pickup.DISALLOWED || arrow.f_36704_ <= 300) continue;
            arrow.m_146870_();
            iterator.remove();
        }
    }

    private void removeArrow(Entity entity) {
        if (entity instanceof AbstractArrow) {
            AbstractArrow arrow = (AbstractArrow)entity;
            if (arrow.f_36705_ == AbstractArrow.Pickup.DISALLOWED && arrow.f_36704_ > 300) {
                entity.m_146870_();
            }
        }
    }

    public byte getSavedWarning(Player player) {
        CompoundTag playerNBT = player.getPersistentData();
        CompoundTag nbt = playerNBT.m_128469_("PlayerPersisted");
        return nbt.m_128445_("RecruitWarnings");
    }

    public void saveCurrentWarning(Player player, byte x) {
        CompoundTag playerNBT = player.getPersistentData();
        CompoundTag nbt = playerNBT.m_128469_("PlayerPersisted");
        nbt.m_128344_("RecruitWarnings", x);
        playerNBT.m_128365_("PlayerPersisted", (Tag)nbt);
    }

    private void warnPlayer(Player player, Component component) {
        this.saveCurrentWarning(player, (byte)(this.getSavedWarning(player) + 1));
        if (this.getSavedWarning(player) >= 0) {
            player.m_213846_(component);
            this.saveCurrentWarning(player, (byte)-10);
        }
    }

    public static MutableComponent TEXT_BLOCK_WARN(String name) {
        return Component.m_237110_((String)"chat.recruits.text.block_placing_warn", (Object[])new Object[]{name});
    }

    public static MutableComponent TEXT_INTERACT_WARN(String name) {
        return Component.m_237110_((String)"chat.recruits.text.block_interact_warn", (Object[])new Object[]{name});
    }

    private static /* synthetic */ boolean lambda$onLivingHurt$7(Entity target, AbstractRecruitEntity recruit) {
        return recruit.m_5448_() == null && recruit.m_5647_() != null && recruit.m_5647_().equals(target.m_5647_());
    }

    static {
        entitiesByProfession = new HashMap<Integer, EntityType<? extends AbstractRecruitEntity>>(){
            {
                this.put(0, (EntityType)ModEntityTypes.MESSENGER.get());
                this.put(1, (EntityType)ModEntityTypes.SCOUT.get());
                this.put(2, (EntityType)ModEntityTypes.PATROL_LEADER.get());
                this.put(3, (EntityType)ModEntityTypes.CAPTAIN.get());
            }
        };
        canceledProjectiles = new HashSet<Projectile>();
    }
}

