/*
 * Decompiled with CFR 0.152.
 */
package com.talhanation.recruits.client.gui;

import com.talhanation.recruits.Main;
import com.talhanation.recruits.client.events.ClientEvent;
import com.talhanation.recruits.client.events.CommandCategoryManager;
import com.talhanation.recruits.client.gui.commandscreen.ICommandCategory;
import com.talhanation.recruits.client.gui.group.RecruitsCategoryButton;
import com.talhanation.recruits.client.gui.group.RecruitsGroup;
import com.talhanation.recruits.client.gui.group.RecruitsGroupButton;
import com.talhanation.recruits.client.gui.group.RecruitsGroupListScreen;
import com.talhanation.recruits.config.RecruitsClientConfig;
import com.talhanation.recruits.inventory.CommandMenu;
import com.talhanation.recruits.network.MessageMovement;
import com.talhanation.recruits.network.MessageSaveFormationFollowMovement;
import com.talhanation.recruits.network.MessageServerSavePlayerGroups;
import de.maxhenkel.recruits.corelib.inventory.ScreenBase;
import java.util.ArrayList;
import java.util.List;
import net.minecraft.client.gui.GuiGraphics;
import net.minecraft.client.gui.components.Renderable;
import net.minecraft.client.gui.components.Tooltip;
import net.minecraft.client.gui.components.events.GuiEventListener;
import net.minecraft.client.gui.screens.Screen;
import net.minecraft.core.BlockPos;
import net.minecraft.nbt.CompoundTag;
import net.minecraft.nbt.Tag;
import net.minecraft.network.chat.Component;
import net.minecraft.network.chat.MutableComponent;
import net.minecraft.resources.ResourceLocation;
import net.minecraft.world.entity.Entity;
import net.minecraft.world.entity.player.Inventory;
import net.minecraft.world.entity.player.Player;
import net.minecraft.world.phys.BlockHitResult;
import net.minecraft.world.phys.HitResult;
import net.minecraftforge.api.distmarker.Dist;
import net.minecraftforge.api.distmarker.OnlyIn;
import net.minecraftforge.client.gui.widget.ExtendedButton;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;

@OnlyIn(value=Dist.CLIENT)
public class CommandScreen
extends ScreenBase<CommandMenu> {
    private static final ResourceLocation RESOURCE_LOCATION = new ResourceLocation("recruits", "textures/gui/command_gui.png");
    private static final MutableComponent TEXT_EVERYONE = Component.m_237115_((String)"gui.recruits.command.text.everyone");
    private static final int fontColor = 0xF7F7F7;
    public final Player player;
    public BlockPos rayBlockPos;
    public Entity rayEntity;
    private ICommandCategory currentCategory;
    public static List<RecruitsGroup> groups;
    public static Formation formation;
    public boolean mouseGroupsInverted;
    private List<RecruitsGroupButton> groupButtons;
    private boolean buttonsSet = false;
    boolean statusSet = false;
    int xTipPos = 140;
    int yTipPos = 157;

    public CommandScreen(CommandMenu commandContainer, Inventory playerInventory, Component title) {
        super(RESOURCE_LOCATION, commandContainer, playerInventory, (Component)Component.m_237113_((String)""));
        this.player = playerInventory.f_35978_;
    }

    public boolean m_7920_(int x, int y, int z) {
        super.m_7920_(x, y, z);
        if (!((Boolean)RecruitsClientConfig.CommandScreenToggle.get()).booleanValue()) {
            this.m_7379_();
        }
        return true;
    }

    @NotNull
    public <T extends GuiEventListener & Renderable> T m_142416_(@NotNull T widget) {
        this.f_169369_.add((Renderable)widget);
        return (T)this.m_7787_(widget);
    }

    public void m_7379_() {
        super.m_7379_();
        this.saveGroups();
        groups = new ArrayList<RecruitsGroup>();
        this.groupButtons = new ArrayList<RecruitsGroupButton>();
        this.saveCategoryOnClient();
    }

    protected void m_7856_() {
        super.m_7856_();
        this.rayBlockPos = this.getBlockPos();
        this.rayEntity = ClientEvent.getEntityByLooking();
        this.currentCategory = this.getSelectionFromClient();
        formation = this.getSavedFormationFromClient();
    }

    protected void m_181908_() {
        super.m_181908_();
        if (!this.buttonsSet) {
            this.setButtons();
            this.saveGroups();
            this.buttonsSet = true;
        }
    }

    private void saveGroups() {
        if (groups != null && !groups.isEmpty()) {
            Main.SIMPLE_CHANNEL.sendToServer((Object)new MessageServerSavePlayerGroups(groups, true));
        }
    }

    private void setButtons() {
        int x = this.f_96543_ / 2;
        int y = this.f_96544_ / 2;
        formation = this.getSavedFormationFromClient();
        this.m_169413_();
        this.groupButtons = new ArrayList<RecruitsGroupButton>();
        int index = 0;
        if (groups != null && !groups.isEmpty()) {
            for (RecruitsGroup group : groups) {
                if (index >= 9) continue;
                this.createRecruitsGroupButton(group, index, x, y);
                ++index;
            }
        }
        this.createManageGroupsButton(index, x, y);
        this.createCategoryButtons(x, y);
        this.currentCategory.createButtons(this, x, y, groups, this.player);
        if (!this.statusSet) {
            this.mouseGroupsInverted = this.getInvertedStatus();
            this.statusSet = true;
        }
    }

    private void createRecruitsGroupButton(RecruitsGroup group, int index, int x, int y) {
        RecruitsGroupButton groupButton = new RecruitsGroupButton(group, x - 200 + 45 * index, y - 120, 40, 40, (Component)Component.m_237113_((String)group.getName()), button -> {
            group.setDisabled(!group.isDisabled());
            this.setButtons();
        });
        this.m_142416_(groupButton);
        groupButton.f_93623_ = !group.isDisabled();
        this.groupButtons.add(groupButton);
    }

    private void createManageGroupsButton(int index, int x, int y) {
        int posX = x - 200 + 45 * index;
        int posY = y - 100;
        if (index > 8) {
            posX = x + 180;
            posY = y - 70;
        }
        ExtendedButton groupButton = new ExtendedButton(posX, posY, 20, 20, (Component)Component.m_237113_((String)"+/-"), button -> this.f_96541_.m_91152_((Screen)new RecruitsGroupListScreen(this.player)));
        this.m_142416_(groupButton);
    }

    private void setCurrentCategory(ICommandCategory currentCategory) {
        this.currentCategory = currentCategory;
        this.saveCategoryOnClient();
        this.setButtons();
    }

    public void setFormation(Formation f) {
        formation = f;
        this.saveFormationSelection();
        this.setButtons();
    }

    private ICommandCategory getSelectionFromClient() {
        CompoundTag playerNBT = this.player.getPersistentData();
        CompoundTag nbt = playerNBT.m_128469_("PlayerPersisted");
        byte x = nbt.m_128445_("RecruitsCategory");
        return CommandCategoryManager.getByIndex(x);
    }

    private void saveCategoryOnClient() {
        CompoundTag playerNBT = this.player.getPersistentData();
        CompoundTag nbt = playerNBT.m_128469_("PlayerPersisted");
        nbt.m_128405_("RecruitsCategory", CommandCategoryManager.getCategories().indexOf(this.currentCategory));
        playerNBT.m_128365_("PlayerPersisted", (Tag)nbt);
    }

    private void createCategoryButtons(int centerX, int centerY) {
        List<ICommandCategory> allCategories = CommandCategoryManager.getCategories();
        int spacing = 21;
        int count = allCategories.size();
        int totalWidth = (count - 1) * spacing;
        int startX = centerX - totalWidth / 2;
        int buttonY = centerY + 85;
        for (int i = 0; i < count; ++i) {
            ICommandCategory category = allCategories.get(i);
            int x = startX + i * spacing;
            RecruitsCategoryButton button = new RecruitsCategoryButton(category.getIcon(), x, buttonY, (Component)Component.m_237113_((String)""), press -> this.setCurrentCategory(category));
            button.m_257544_(Tooltip.m_257550_((Component)category.getToolTipName()));
            button.f_93623_ = category == this.currentCategory;
            this.m_142416_(button);
        }
    }

    public void sendMovementCommandToServer(int state) {
        if (state != 1) {
            Main.SIMPLE_CHANNEL.sendToServer((Object)new MessageSaveFormationFollowMovement(this.player.m_20148_(), new int[0], -1));
        }
        if (!groups.isEmpty()) {
            for (RecruitsGroup group : groups) {
                if (group.isDisabled()) continue;
                Main.SIMPLE_CHANNEL.sendToServer((Object)new MessageMovement(this.player.m_20148_(), state, group.getId(), formation.getIndex()));
            }
        }
    }

    public Formation getSavedFormationFromClient() {
        CompoundTag playerNBT = this.player.getPersistentData();
        CompoundTag nbt = playerNBT.m_128469_("PlayerPersisted");
        return Formation.fromIndex((byte)nbt.m_128451_("FormationSelection"));
    }

    public void saveFormationSelection() {
        CompoundTag playerNBT = this.player.getPersistentData();
        CompoundTag nbt = playerNBT.m_128469_("PlayerPersisted");
        nbt.m_128344_("FormationSelection", formation.getIndex());
        playerNBT.m_128365_("PlayerPersisted", (Tag)nbt);
    }

    public void sendCommandInChat(int state) {
        StringBuilder group_string = new StringBuilder();
        int i = 0;
        for (RecruitsGroup group : groups) {
            if (group.isDisabled()) continue;
            ++i;
        }
        if (i >= 9) {
            group_string = new StringBuilder(TEXT_EVERYONE.getString() + ", ");
        } else {
            for (RecruitsGroup group : groups) {
                if (group.isDisabled()) continue;
                group_string.append(group.getName()).append(", ");
            }
        }
        switch (state) {
            case 0: {
                this.player.m_213846_((Component)CommandScreen.TEXT_WANDER(group_string.toString()));
                break;
            }
            case 1: {
                this.player.m_213846_((Component)CommandScreen.TEXT_FOLLOW(group_string.toString()));
                break;
            }
            case 2: {
                this.player.m_213846_((Component)CommandScreen.TEXT_HOLD_POS(group_string.toString()));
                break;
            }
            case 3: {
                this.player.m_213846_((Component)CommandScreen.TEXT_BACK_TO_POS(group_string.toString()));
                break;
            }
            case 4: {
                this.player.m_213846_((Component)CommandScreen.TEXT_HOLD_MY_POS(group_string.toString()));
                break;
            }
            case 5: {
                this.player.m_213846_((Component)CommandScreen.TEXT_PROTECT(group_string.toString()));
                break;
            }
            case 6: {
                this.player.m_213846_((Component)CommandScreen.TEXT_MOVE(group_string.toString()));
                break;
            }
            case 7: {
                this.player.m_213846_((Component)CommandScreen.TEXT_FORWARD(group_string.toString()));
                break;
            }
            case 8: {
                this.player.m_213846_((Component)CommandScreen.TEXT_BACKWARD(group_string.toString()));
                break;
            }
            case 9: {
                this.player.m_213846_((Component)CommandScreen.TEXT_CLEAR_TARGETS(group_string.toString()));
                break;
            }
            case 10: {
                this.player.m_213846_((Component)CommandScreen.TEXT_NEUTRAL(group_string.toString()));
                break;
            }
            case 11: {
                this.player.m_213846_((Component)CommandScreen.TEXT_AGGRESSIVE(group_string.toString()));
                break;
            }
            case 12: {
                this.player.m_213846_((Component)CommandScreen.TEXT_RAID(group_string.toString()));
                break;
            }
            case 13: {
                this.player.m_213846_((Component)CommandScreen.TEXT_PASSIVE(group_string.toString()));
                break;
            }
            case 70: {
                this.player.m_213846_((Component)CommandScreen.TEXT_FIRE_AT_WILL(group_string.toString()));
                break;
            }
            case 71: {
                this.player.m_213846_((Component)CommandScreen.TEXT_HOLD_FIRE(group_string.toString()));
                break;
            }
            case 72: {
                this.player.m_213846_((Component)CommandScreen.TEXT_STRATEGIC_FIRE(group_string.toString()));
                break;
            }
            case 73: {
                this.player.m_213846_((Component)CommandScreen.TEXT_STRATEGIC_FIRE_OFF(group_string.toString()));
                break;
            }
            case 74: {
                this.player.m_213846_((Component)CommandScreen.TEXT_SHIELDS(group_string.toString()));
                break;
            }
            case 75: {
                this.player.m_213846_((Component)CommandScreen.TEXT_SHIELDS_OFF(group_string.toString()));
                break;
            }
            case 88: {
                this.player.m_213846_((Component)CommandScreen.TEXT_REST(group_string.toString()));
                break;
            }
            case 91: {
                this.player.m_213846_((Component)CommandScreen.TEXT_BACK_TO_MOUNT(group_string.toString()));
                break;
            }
            case 92: {
                this.player.m_213846_((Component)CommandScreen.TEXT_UPKEEP(group_string.toString()));
                break;
            }
            case 93: {
                this.player.m_213846_((Component)CommandScreen.TEXT_CLEAR_UPKEEP(group_string.toString()));
                break;
            }
            case 98: {
                this.player.m_213846_((Component)CommandScreen.TEXT_DISMOUNT(group_string.toString()));
                break;
            }
            case 99: {
                this.player.m_213846_((Component)CommandScreen.TEXT_MOUNT(group_string.toString()));
            }
        }
    }

    private static MutableComponent TEXT_WANDER(String group_string) {
        return Component.m_237110_((String)"chat.recruits.command.wander", (Object[])new Object[]{group_string});
    }

    private static MutableComponent TEXT_FOLLOW(String group_string) {
        return Component.m_237110_((String)"chat.recruits.command.follow", (Object[])new Object[]{group_string});
    }

    private static MutableComponent TEXT_HOLD_POS(String group_string) {
        return Component.m_237110_((String)"chat.recruits.command.holdPos", (Object[])new Object[]{group_string});
    }

    private static MutableComponent TEXT_BACK_TO_POS(String group_string) {
        return Component.m_237110_((String)"chat.recruits.command.backToPos", (Object[])new Object[]{group_string});
    }

    private static MutableComponent TEXT_BACK_TO_MOUNT(String group_string) {
        return Component.m_237110_((String)"chat.recruits.command.backToMount", (Object[])new Object[]{group_string});
    }

    private static MutableComponent TEXT_REST(String group_string) {
        return Component.m_237110_((String)"chat.recruits.command.rest", (Object[])new Object[]{group_string});
    }

    private static MutableComponent TEXT_HOLD_MY_POS(String group_string) {
        return Component.m_237110_((String)"chat.recruits.command.holdMyPos", (Object[])new Object[]{group_string});
    }

    private static MutableComponent TEXT_PROTECT(String group_string) {
        return Component.m_237110_((String)"chat.recruits.command.protect", (Object[])new Object[]{group_string});
    }

    private static MutableComponent TEXT_UPKEEP(String group_string) {
        return Component.m_237110_((String)"chat.recruits.command.upkeep", (Object[])new Object[]{group_string});
    }

    private static MutableComponent TEXT_CLEAR_UPKEEP(String group_string) {
        return Component.m_237110_((String)"chat.recruits.command.clear_upkeep", (Object[])new Object[]{group_string});
    }

    private static MutableComponent TEXT_SHIELDS_OFF(String group_string) {
        return Component.m_237110_((String)"chat.recruits.command.shields_off", (Object[])new Object[]{group_string});
    }

    private static MutableComponent TEXT_STRATEGIC_FIRE_OFF(String group_string) {
        return Component.m_237110_((String)"chat.recruits.command.strategic_fire_off", (Object[])new Object[]{group_string});
    }

    private static MutableComponent TEXT_SHIELDS(String group_string) {
        return Component.m_237110_((String)"chat.recruits.command.shields", (Object[])new Object[]{group_string});
    }

    private static MutableComponent TEXT_STRATEGIC_FIRE(String group_string) {
        return Component.m_237110_((String)"chat.recruits.command.strategic_fire", (Object[])new Object[]{group_string});
    }

    private static MutableComponent TEXT_MOVE(String group_string) {
        return Component.m_237110_((String)"chat.recruits.command.move", (Object[])new Object[]{group_string});
    }

    private static MutableComponent TEXT_FORWARD(String group_string) {
        return Component.m_237110_((String)"chat.recruits.command.forward", (Object[])new Object[]{group_string});
    }

    private static MutableComponent TEXT_BACKWARD(String group_string) {
        return Component.m_237110_((String)"chat.recruits.command.backward", (Object[])new Object[]{group_string});
    }

    private static MutableComponent TEXT_CLEAR_TARGETS(String group_string) {
        return Component.m_237110_((String)"chat.recruits.command.clearTargets", (Object[])new Object[]{group_string});
    }

    private static MutableComponent TEXT_DISMOUNT(String group_string) {
        return Component.m_237110_((String)"chat.recruits.command.dismount", (Object[])new Object[]{group_string});
    }

    private static MutableComponent TEXT_MOUNT(String group_string) {
        return Component.m_237110_((String)"chat.recruits.command.mount", (Object[])new Object[]{group_string});
    }

    private static MutableComponent TEXT_PASSIVE(String group_string) {
        return Component.m_237110_((String)"chat.recruits.command.passive", (Object[])new Object[]{group_string});
    }

    private static MutableComponent TEXT_RAID(String group_string) {
        return Component.m_237110_((String)"chat.recruits.command.raid", (Object[])new Object[]{group_string});
    }

    private static MutableComponent TEXT_AGGRESSIVE(String group_string) {
        return Component.m_237110_((String)"chat.recruits.command.aggressive", (Object[])new Object[]{group_string});
    }

    private static MutableComponent TEXT_NEUTRAL(String group_string) {
        return Component.m_237110_((String)"chat.recruits.command.neutral", (Object[])new Object[]{group_string});
    }

    private static MutableComponent TEXT_SHIELDS_UP(String group_string) {
        return Component.m_237110_((String)"chat.recruits.command.shields", (Object[])new Object[]{group_string});
    }

    private static MutableComponent TEXT_SHIELDS_DOWN(String group_string) {
        return Component.m_237110_((String)"chat.recruits.command.shields_off", (Object[])new Object[]{group_string});
    }

    private static MutableComponent TEXT_FIRE_AT_WILL(String group_string) {
        return Component.m_237110_((String)"chat.recruits.command.fire_at_will", (Object[])new Object[]{group_string});
    }

    private static MutableComponent TEXT_HOLD_FIRE(String group_string) {
        return Component.m_237110_((String)"chat.recruits.command.hold_fire", (Object[])new Object[]{group_string});
    }

    private static MutableComponent TEXT_SELECT_ALL_GROUPS() {
        return Component.m_237115_((String)"gui.recruits.command.tip.de_select_groups");
    }

    private static MutableComponent TEXT_SCROLL_CATEGORIES() {
        return Component.m_237115_((String)"gui.recruits.command.tip.scrollCategories");
    }

    @Override
    protected void m_280003_(GuiGraphics guiGraphics, int mouseX, int mouseY) {
        super.m_280003_(guiGraphics, mouseX, mouseY);
        String tipAllGroups = CommandScreen.TEXT_SELECT_ALL_GROUPS().getString();
        String tipScroll = CommandScreen.TEXT_SCROLL_CATEGORIES().getString();
        guiGraphics.m_280056_(this.f_96547_, tipAllGroups, this.xTipPos, this.yTipPos, 0x404040, false);
        guiGraphics.m_280056_(this.f_96547_, tipScroll, this.xTipPos, this.yTipPos + 15, 0x404040, false);
    }

    @Override
    protected void m_7286_(GuiGraphics guiGraphics, float partialTicks, int mouseX, int mouseY) {
        super.m_7286_(guiGraphics, partialTicks, mouseX, mouseY);
    }

    @Nullable
    private BlockPos getBlockPos() {
        HitResult rayTraceResult = this.player.m_19907_(100.0, 1.0f, true);
        if (rayTraceResult != null && rayTraceResult.m_6662_() == HitResult.Type.BLOCK) {
            BlockHitResult blockraytraceresult = (BlockHitResult)rayTraceResult;
            return blockraytraceresult.m_82425_();
        }
        return null;
    }

    public boolean m_6375_(double x, double y, int id) {
        if (id == 1) {
            this.invertGroups();
        }
        return super.m_6375_(x, y, id);
    }

    public boolean m_6050_(double p_94686_, double p_94687_, double p_94688_) {
        if (p_94688_ > 0.0) {
            this.setCurrentCategory(CommandCategoryManager.getPrevious(this.currentCategory));
        } else {
            this.setCurrentCategory(CommandCategoryManager.getNext(this.currentCategory));
        }
        return super.m_6050_(p_94686_, p_94687_, p_94688_);
    }

    private void invertGroups() {
        for (RecruitsGroupButton button : this.groupButtons) {
            button.getGroup().setDisabled(this.mouseGroupsInverted);
        }
        this.setButtons();
        this.mouseGroupsInverted = !this.mouseGroupsInverted;
    }

    private boolean getInvertedStatus() {
        boolean allActive = true;
        boolean allInactive = true;
        for (RecruitsGroupButton button : this.groupButtons) {
            if (button.f_93623_) {
                allInactive = false;
            } else {
                allActive = false;
            }
            if (allActive || allInactive) continue;
            return false;
        }
        return allActive;
    }

    @OnlyIn(value=Dist.CLIENT)
    public static enum Formation {
        NONE(0),
        LINE(1),
        SQUARE(2),
        TRIANGLE(3),
        HCIRCLE(4),
        HSQUARE(5),
        VFORM(6),
        CIRCLE(7),
        MOVEMENT(8);

        private final byte index;

        private Formation(byte index) {
            this.index = index;
        }

        public byte getIndex() {
            return this.index;
        }

        public static Formation fromIndex(byte index) {
            for (Formation state : Formation.values()) {
                if (state.getIndex() != index) continue;
                return state;
            }
            throw new IllegalArgumentException("Invalid Selection index: " + index);
        }
    }
}

