/*
 * Decompiled with CFR 0.152.
 */
package com.talhanation.recruits.client.gui.group;

import com.talhanation.recruits.client.gui.group.RecruitsGroup;
import com.talhanation.recruits.client.gui.group.RecruitsGroupListScreen;
import com.talhanation.recruits.client.gui.widgets.ListScreenEntryBase;
import com.talhanation.recruits.client.gui.widgets.ListScreenListBase;
import java.util.Objects;
import net.minecraft.client.Minecraft;
import net.minecraft.client.gui.GuiGraphics;
import net.minecraft.util.FastColor;
import net.minecraftforge.api.distmarker.Dist;
import net.minecraftforge.api.distmarker.OnlyIn;
import org.jetbrains.annotations.NotNull;

@OnlyIn(value=Dist.CLIENT)
public class RecruitsGroupEntry
extends ListScreenEntryBase<RecruitsGroupEntry> {
    protected static final int SKIN_SIZE = 24;
    protected static final int PADDING = 4;
    protected static final int BG_FILL = FastColor.ARGB32.m_13660_((int)255, (int)60, (int)60, (int)60);
    protected static final int BG_FILL_HOVERED = FastColor.ARGB32.m_13660_((int)255, (int)100, (int)100, (int)100);
    protected static final int BG_FILL_SELECTED = FastColor.ARGB32.m_13660_((int)255, (int)10, (int)10, (int)10);
    protected static final int PLAYER_NAME_COLOR = FastColor.ARGB32.m_13660_((int)255, (int)255, (int)255, (int)255);
    protected final Minecraft minecraft = Minecraft.m_91087_();
    protected final RecruitsGroupListScreen screen;
    @NotNull
    protected final RecruitsGroup group;

    public RecruitsGroupEntry(RecruitsGroupListScreen screen, @NotNull RecruitsGroup group) {
        this.screen = screen;
        this.group = group;
    }

    public void m_6311_(GuiGraphics guiGraphics, int index, int top, int left, int width, int height, int mouseX, int mouseY, boolean hovered, float delta) {
        int skinX = left + 4;
        int skinY = top + (height - 24) / 2;
        int textX = skinX + 24 + 4;
        Objects.requireNonNull(this.minecraft.f_91062_);
        int textY = top + (height - 9) / 2;
        guiGraphics.m_280509_(left, top, left + width, top + height, BG_FILL);
        this.renderElement(guiGraphics, index, top, left, width, height, mouseX, mouseY, hovered, delta, skinX, skinY, textX, textY);
    }

    public void renderElement(GuiGraphics guiGraphics, int index, int top, int left, int width, int height, int mouseX, int mouseY, boolean hovered, float delta, int skinX, int skinY, int textX, int textY) {
        boolean selected = this.group.equals(this.screen.getSelected());
        if (selected) {
            guiGraphics.m_280509_(left, top, left + width, top + height, BG_FILL_SELECTED);
        } else if (hovered) {
            guiGraphics.m_280509_(left, top, left + width, top + height, BG_FILL_HOVERED);
        } else {
            guiGraphics.m_280509_(left, top, left + width, top + height, BG_FILL);
        }
        guiGraphics.drawString(this.minecraft.f_91062_, this.group.getName(), (float)textX + 15.0f, (float)textY, PLAYER_NAME_COLOR, false);
    }

    public RecruitsGroup getGroup() {
        return this.group;
    }

    @Override
    public ListScreenListBase<RecruitsGroupEntry> getList() {
        return this.screen.groupList;
    }
}

