/*
 * Decompiled with CFR 0.152.
 */
package com.talhanation.recruits.client.gui.player;

import com.google.common.collect.Lists;
import com.talhanation.recruits.client.gui.player.IPlayerSelection;
import com.talhanation.recruits.client.gui.player.RecruitsPlayerEntry;
import com.talhanation.recruits.client.gui.widgets.ListScreenListBase;
import com.talhanation.recruits.world.RecruitsPlayerInfo;
import com.talhanation.recruits.world.RecruitsTeam;
import java.util.ArrayList;
import java.util.List;
import java.util.Locale;
import net.minecraft.world.entity.player.Player;

public class PlayersList
extends ListScreenListBase<RecruitsPlayerEntry> {
    protected IPlayerSelection screen;
    protected final List<RecruitsPlayerEntry> entries;
    protected String filter;
    protected final FilterType filterType;
    public static List<RecruitsPlayerInfo> onlinePlayers;
    public final Player player;
    public RecruitsTeam recruitsTeam;
    protected final boolean includeSelf;

    public PlayersList(int width, int height, int x, int y, int size, IPlayerSelection screen, FilterType filterType, Player player, boolean includeSelf) {
        super(width, height, x, y, size);
        this.screen = screen;
        this.entries = Lists.newArrayList();
        this.filter = "";
        this.filterType = filterType;
        this.player = player;
        this.includeSelf = includeSelf;
        this.m_93488_(false);
        this.m_93496_(false);
        this.m_93471_(true);
    }

    public void tick() {
        if (onlinePlayers != null) {
            this.updateEntryList();
        }
    }

    public void updateEntryList() {
        this.entries.clear();
        this.recruitsTeam = this.getRecruitsTeam();
        block4: for (RecruitsPlayerInfo player : onlinePlayers) {
            if (!this.includeSelf && player.getUUID().equals(this.player.m_20148_())) continue;
            switch (this.filterType) {
                default: {
                    this.entries.add(new RecruitsPlayerEntry(this.screen, player));
                    break;
                }
                case SAME_TEAM: {
                    RecruitsTeam recruitsTeam = player.getRecruitsTeam();
                    if (recruitsTeam == null || !recruitsTeam.getStringID().equals(this.recruitsTeam.getStringID())) continue block4;
                    this.entries.add(new RecruitsPlayerEntry(this.screen, player));
                    break;
                }
                case TEAM_JOIN_REQUEST: {
                    if (this.recruitsTeam == null || !this.recruitsTeam.getJoinRequests().contains(player.getName())) continue block4;
                    this.entries.add(new RecruitsPlayerEntry(this.screen, player));
                }
            }
        }
        this.updateFilter();
    }

    private RecruitsTeam getRecruitsTeam() {
        RecruitsTeam recruitsTeam = null;
        for (RecruitsPlayerInfo player : onlinePlayers) {
            if (!player.getUUID().equals(this.player.m_20148_())) continue;
            recruitsTeam = player.getRecruitsTeam();
            break;
        }
        return recruitsTeam;
    }

    public void updateFilter() {
        this.m_93516_();
        ArrayList<RecruitsPlayerEntry> filteredEntries = new ArrayList<RecruitsPlayerEntry>(this.entries);
        if (!this.filter.isEmpty()) {
            filteredEntries.removeIf(playerEntry -> playerEntry.getPlayerInfo() == null || !playerEntry.getPlayerInfo().getName().toLowerCase(Locale.ROOT).contains(this.filter));
        }
        filteredEntries.sort((e1, e2) -> {
            if (!((Object)e1).getClass().equals(((Object)e2).getClass())) {
                if (e1 instanceof RecruitsPlayerEntry) {
                    return 1;
                }
                return -1;
            }
            return this.volumeEntryToString((RecruitsPlayerEntry)((Object)e1)).compareToIgnoreCase(this.volumeEntryToString((RecruitsPlayerEntry)((Object)e2)));
        });
        this.m_5988_(filteredEntries);
    }

    private String volumeEntryToString(RecruitsPlayerEntry entry) {
        return entry.getPlayerInfo() == null ? "" : entry.getPlayerInfo().getName();
    }

    public void setFilter(String filter) {
        this.filter = filter;
        this.updateFilter();
    }

    public boolean isEmpty() {
        return this.m_6702_().isEmpty();
    }

    public int size() {
        return this.m_6702_().size();
    }

    public static enum FilterType {
        NONE,
        SAME_TEAM,
        TEAM_JOIN_REQUEST;

    }
}

