/*
 * Decompiled with CFR 0.152.
 */
package com.talhanation.recruits.client.gui.player;

import com.mojang.blaze3d.systems.RenderSystem;
import com.talhanation.recruits.client.gui.component.BannerRenderer;
import com.talhanation.recruits.client.gui.player.IPlayerSelection;
import com.talhanation.recruits.client.gui.widgets.ListScreenEntryBase;
import com.talhanation.recruits.client.gui.widgets.ListScreenListBase;
import com.talhanation.recruits.util.GameProfileUtils;
import com.talhanation.recruits.world.RecruitsPlayerInfo;
import java.util.Objects;
import net.minecraft.client.Minecraft;
import net.minecraft.client.gui.GuiGraphics;
import net.minecraft.resources.ResourceLocation;
import net.minecraft.util.FastColor;
import org.jetbrains.annotations.NotNull;

public class RecruitsPlayerEntry
extends ListScreenEntryBase<RecruitsPlayerEntry> {
    protected static final int SKIN_SIZE = 24;
    protected static final int PADDING = 4;
    protected static final int BG_FILL = FastColor.ARGB32.m_13660_((int)255, (int)60, (int)60, (int)60);
    protected static final int BG_FILL_HOVERED = FastColor.ARGB32.m_13660_((int)255, (int)100, (int)100, (int)100);
    protected static final int BG_FILL_SELECTED = FastColor.ARGB32.m_13660_((int)255, (int)10, (int)10, (int)10);
    protected static final int PLAYER_NAME_COLOR = FastColor.ARGB32.m_13660_((int)255, (int)255, (int)255, (int)255);
    protected final Minecraft minecraft = Minecraft.m_91087_();
    protected final IPlayerSelection screen;
    @NotNull
    protected final RecruitsPlayerInfo player;
    protected final BannerRenderer bannerRenderer;

    public RecruitsPlayerEntry(IPlayerSelection screen, @NotNull RecruitsPlayerInfo player) {
        this.screen = screen;
        this.player = player;
        this.bannerRenderer = new BannerRenderer(player.getRecruitsTeam());
    }

    public void m_6311_(GuiGraphics guiGraphics, int index, int top, int left, int width, int height, int mouseX, int mouseY, boolean hovered, float delta) {
        int skinX = left + 4;
        int skinY = top + (height - 24) / 2;
        int textX = skinX + 24 + 4;
        Objects.requireNonNull(this.minecraft.f_91062_);
        int textY = top + (height - 9) / 2;
        guiGraphics.m_280509_(left, top, left + width, top + height, BG_FILL);
        this.renderElement(guiGraphics, index, top, left, width, height, mouseX, mouseY, hovered, delta, skinX, skinY, textX, textY);
    }

    public void renderElement(GuiGraphics guiGraphics, int index, int top, int left, int width, int height, int mouseX, int mouseY, boolean hovered, float delta, int skinX, int skinY, int textX, int textY) {
        boolean selected;
        boolean bl = selected = this.screen.getSelected() != null && this.player.getUUID().equals(this.screen.getSelected().getUUID());
        if (selected) {
            guiGraphics.m_280509_(left, top, left + width, top + height, BG_FILL_SELECTED);
        } else if (hovered) {
            guiGraphics.m_280509_(left, top, left + width, top + height, BG_FILL_HOVERED);
        } else {
            guiGraphics.m_280509_(left, top, left + width, top + height, BG_FILL);
        }
        RenderSystem.setShaderTexture((int)0, (ResourceLocation)GameProfileUtils.getSkin(this.player.getUUID()));
        guiGraphics.m_280411_(GameProfileUtils.getSkin(this.player.getUUID()), skinX, skinY, 24, 24, 8.0f, 8.0f, 8, 8, 64, 64);
        RenderSystem.enableBlend();
        guiGraphics.m_280411_(GameProfileUtils.getSkin(this.player.getUUID()), skinX, skinY, 24, 24, 40.0f, 8.0f, 8, 8, 64, 64);
        RenderSystem.disableBlend();
        guiGraphics.drawString(this.minecraft.f_91062_, this.player.getName(), (float)textX, (float)textY, PLAYER_NAME_COLOR, false);
        if (this.bannerRenderer != null) {
            this.bannerRenderer.renderBanner(guiGraphics, left + 185, top, width, height, 15);
        }
    }

    @NotNull
    public RecruitsPlayerInfo getPlayerInfo() {
        return this.player;
    }

    @Override
    public ListScreenListBase<RecruitsPlayerEntry> getList() {
        return this.screen.getPlayerList();
    }
}

